/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.resource.gifbitmap;

import android.graphics.Bitmap;
import com.hpplay.glide.load.ResourceDecoder;
import com.hpplay.glide.load.engine.Resource;
import com.hpplay.glide.load.engine.bitmap_recycle.BitmapPool;
import com.hpplay.glide.load.model.ImageVideoWrapper;
import com.hpplay.glide.load.resource.bitmap.BitmapResource;
import com.hpplay.glide.load.resource.bitmap.ImageHeaderParser;
import com.hpplay.glide.load.resource.bitmap.RecyclableBufferedInputStream;
import com.hpplay.glide.load.resource.gif.GifDrawable;
import com.hpplay.glide.load.resource.gifbitmap.GifBitmapWrapper;
import com.hpplay.glide.load.resource.gifbitmap.GifBitmapWrapperResource;
import com.hpplay.glide.util.ByteArrayPool;
import java.io.InputStream;

public class GifBitmapWrapperResourceDecoder
implements ResourceDecoder<ImageVideoWrapper, GifBitmapWrapper> {
    private static final ImageTypeParser DEFAULT_PARSER = new ImageTypeParser();
    private static final BufferedStreamFactory DEFAULT_STREAM_FACTORY = new BufferedStreamFactory();
    static final int MARK_LIMIT_BYTES = 2048;
    private final ResourceDecoder<ImageVideoWrapper, Bitmap> bitmapDecoder;
    private final ResourceDecoder<InputStream, GifDrawable> gifDecoder;
    private final BitmapPool bitmapPool;
    private final ImageTypeParser parser;
    private final BufferedStreamFactory streamFactory;
    private String id;

    public GifBitmapWrapperResourceDecoder(ResourceDecoder<ImageVideoWrapper, Bitmap> resourceDecoder, ResourceDecoder<InputStream, GifDrawable> resourceDecoder2, BitmapPool bitmapPool) {
        this(resourceDecoder, resourceDecoder2, bitmapPool, DEFAULT_PARSER, DEFAULT_STREAM_FACTORY);
    }

    GifBitmapWrapperResourceDecoder(ResourceDecoder<ImageVideoWrapper, Bitmap> resourceDecoder, ResourceDecoder<InputStream, GifDrawable> resourceDecoder2, BitmapPool bitmapPool, ImageTypeParser imageTypeParser, BufferedStreamFactory bufferedStreamFactory) {
        this.bitmapDecoder = resourceDecoder;
        this.gifDecoder = resourceDecoder2;
        this.bitmapPool = bitmapPool;
        this.parser = imageTypeParser;
        this.streamFactory = bufferedStreamFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource<GifBitmapWrapper> decode(ImageVideoWrapper imageVideoWrapper, int n2, int n3) {
        ByteArrayPool byteArrayPool = ByteArrayPool.get();
        byte[] byArray = byteArrayPool.getBytes();
        GifBitmapWrapper gifBitmapWrapper = null;
        try {
            gifBitmapWrapper = this.decode(imageVideoWrapper, n2, n3, byArray);
        }
        finally {
            byteArrayPool.releaseBytes(byArray);
        }
        return gifBitmapWrapper != null ? new GifBitmapWrapperResource(gifBitmapWrapper) : null;
    }

    private GifBitmapWrapper decode(ImageVideoWrapper imageVideoWrapper, int n2, int n3, byte[] byArray) {
        GifBitmapWrapper gifBitmapWrapper = imageVideoWrapper.getStream() != null ? this.decodeStream(imageVideoWrapper, n2, n3, byArray) : this.decodeBitmapWrapper(imageVideoWrapper, n2, n3);
        return gifBitmapWrapper;
    }

    private GifBitmapWrapper decodeStream(ImageVideoWrapper imageVideoWrapper, int n2, int n3, byte[] byArray) {
        InputStream inputStream = this.streamFactory.build(imageVideoWrapper.getStream(), byArray);
        inputStream.mark(2048);
        ImageHeaderParser.ImageType imageType = this.parser.parse(inputStream);
        inputStream.reset();
        GifBitmapWrapper gifBitmapWrapper = null;
        if (imageType == ImageHeaderParser.ImageType.GIF) {
            gifBitmapWrapper = this.decodeGifWrapper(inputStream, n2, n3);
        }
        if (gifBitmapWrapper == null) {
            ImageVideoWrapper imageVideoWrapper2 = new ImageVideoWrapper(inputStream, imageVideoWrapper.getFileDescriptor());
            gifBitmapWrapper = this.decodeBitmapWrapper(imageVideoWrapper2, n2, n3);
        }
        return gifBitmapWrapper;
    }

    private GifBitmapWrapper decodeGifWrapper(InputStream inputStream, int n2, int n3) {
        GifBitmapWrapper gifBitmapWrapper = null;
        Resource<GifDrawable> resource = this.gifDecoder.decode(inputStream, n2, n3);
        if (resource != null) {
            GifDrawable gifDrawable = resource.get();
            if (gifDrawable.getFrameCount() > 1) {
                gifBitmapWrapper = new GifBitmapWrapper(null, resource);
            } else {
                BitmapResource bitmapResource = new BitmapResource(gifDrawable.getFirstFrame(), this.bitmapPool);
                gifBitmapWrapper = new GifBitmapWrapper(bitmapResource, null);
            }
        }
        return gifBitmapWrapper;
    }

    private GifBitmapWrapper decodeBitmapWrapper(ImageVideoWrapper imageVideoWrapper, int n2, int n3) {
        GifBitmapWrapper gifBitmapWrapper = null;
        Resource<Bitmap> resource = this.bitmapDecoder.decode(imageVideoWrapper, n2, n3);
        if (resource != null) {
            gifBitmapWrapper = new GifBitmapWrapper(resource, null);
        }
        return gifBitmapWrapper;
    }

    @Override
    public String getId() {
        if (this.id == null) {
            this.id = this.gifDecoder.getId() + this.bitmapDecoder.getId();
        }
        return this.id;
    }

    static class ImageTypeParser {
        ImageTypeParser() {
        }

        public ImageHeaderParser.ImageType parse(InputStream inputStream) {
            return new ImageHeaderParser(inputStream).getType();
        }
    }

    static class BufferedStreamFactory {
        BufferedStreamFactory() {
        }

        public InputStream build(InputStream inputStream, byte[] byArray) {
            return new RecyclableBufferedInputStream(inputStream, byArray);
        }
    }
}

