/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.resource.bitmap;

import android.graphics.Bitmap;
import android.media.MediaMetadataRetriever;
import android.os.ParcelFileDescriptor;
import com.hpplay.glide.load.DecodeFormat;
import com.hpplay.glide.load.engine.bitmap_recycle.BitmapPool;
import com.hpplay.glide.load.resource.bitmap.BitmapDecoder;

public class VideoBitmapDecoder
implements BitmapDecoder<ParcelFileDescriptor> {
    private static final MediaMetadataRetrieverFactory DEFAULT_FACTORY = new MediaMetadataRetrieverFactory();
    private static final int NO_FRAME = -1;
    private MediaMetadataRetrieverFactory factory;
    private int frame;

    public VideoBitmapDecoder() {
        this(DEFAULT_FACTORY, -1);
    }

    public VideoBitmapDecoder(int n2) {
        this(DEFAULT_FACTORY, VideoBitmapDecoder.checkValidFrame(n2));
    }

    VideoBitmapDecoder(MediaMetadataRetrieverFactory mediaMetadataRetrieverFactory) {
        this(mediaMetadataRetrieverFactory, -1);
    }

    VideoBitmapDecoder(MediaMetadataRetrieverFactory mediaMetadataRetrieverFactory, int n2) {
        this.factory = mediaMetadataRetrieverFactory;
        this.frame = n2;
    }

    @Override
    public Bitmap decode(ParcelFileDescriptor parcelFileDescriptor, BitmapPool bitmapPool, int n2, int n3, DecodeFormat decodeFormat) {
        MediaMetadataRetriever mediaMetadataRetriever = this.factory.build();
        mediaMetadataRetriever.setDataSource(parcelFileDescriptor.getFileDescriptor());
        Bitmap bitmap = this.frame >= 0 ? mediaMetadataRetriever.getFrameAtTime((long)this.frame) : mediaMetadataRetriever.getFrameAtTime();
        mediaMetadataRetriever.release();
        parcelFileDescriptor.close();
        return bitmap;
    }

    @Override
    public String getId() {
        return "VideoBitmapDecoder.com.bumptech.glide.load.resource.bitmap";
    }

    private static int checkValidFrame(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Requested frame must be non-negative");
        }
        return n2;
    }

    static class MediaMetadataRetrieverFactory {
        MediaMetadataRetrieverFactory() {
        }

        public MediaMetadataRetriever build() {
            return new MediaMetadataRetriever();
        }
    }
}

