/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.gifencoder;

import java.io.OutputStream;

class LZWEncoder {
    private static final int EOF = -1;
    private int imgW;
    private int imgH;
    private byte[] pixAry;
    private int initCodeSize;
    private int remaining;
    private int curPixel;
    static final int BITS = 12;
    static final int HSIZE = 5003;
    int n_bits;
    int maxbits = 12;
    int maxcode;
    int maxmaxcode = 4096;
    int[] htab = new int[5003];
    int[] codetab = new int[5003];
    int hsize = 5003;
    int free_ent = 0;
    boolean clear_flg = false;
    int g_init_bits;
    int ClearCode;
    int EOFCode;
    int cur_accum = 0;
    int cur_bits = 0;
    int[] masks = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535};
    int a_count;
    byte[] accum = new byte[256];

    LZWEncoder(int n2, int n3, byte[] byArray, int n4) {
        this.imgW = n2;
        this.imgH = n3;
        this.pixAry = byArray;
        this.initCodeSize = Math.max(2, n4);
    }

    void char_out(byte by, OutputStream outputStream) {
        this.accum[this.a_count++] = by;
        if (this.a_count >= 254) {
            this.flush_char(outputStream);
        }
    }

    void cl_block(OutputStream outputStream) {
        this.cl_hash(this.hsize);
        this.free_ent = this.ClearCode + 2;
        this.clear_flg = true;
        this.output(this.ClearCode, outputStream);
    }

    void cl_hash(int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            this.htab[i2] = -1;
        }
    }

    void compress(int n2, OutputStream outputStream) {
        int n3;
        int n4;
        this.g_init_bits = n2;
        this.clear_flg = false;
        this.n_bits = this.g_init_bits;
        this.maxcode = this.MAXCODE(this.n_bits);
        this.ClearCode = 1 << n2 - 1;
        this.EOFCode = this.ClearCode + 1;
        this.free_ent = this.ClearCode + 2;
        this.a_count = 0;
        int n5 = this.nextPixel();
        int n6 = 0;
        for (n4 = this.hsize; n4 < 65536; n4 *= 2) {
            ++n6;
        }
        n6 = 8 - n6;
        int n7 = this.hsize;
        this.cl_hash(n7);
        this.output(this.ClearCode, outputStream);
        block1: while ((n3 = this.nextPixel()) != -1) {
            int n8 = n3 << n6 ^ n5;
            n4 = (n3 << this.maxbits) + n5;
            if (this.htab[n8] == n4) {
                n5 = this.codetab[n8];
                continue;
            }
            if (this.htab[n8] >= 0) {
                int n9 = n7 - n8;
                if (n8 == 0) {
                    n9 = 1;
                }
                do {
                    if ((n8 -= n9) < 0) {
                        n8 += n7;
                    }
                    if (this.htab[n8] != n4) continue;
                    n5 = this.codetab[n8];
                    continue block1;
                } while (this.htab[n8] >= 0);
            }
            this.output(n5, outputStream);
            n5 = n3;
            if (this.free_ent < this.maxmaxcode) {
                ++this.free_ent;
                this.htab[n8] = n4;
                continue;
            }
            this.cl_block(outputStream);
        }
        this.output(n5, outputStream);
        this.output(this.EOFCode, outputStream);
    }

    void encode(OutputStream outputStream) {
        outputStream.write(this.initCodeSize);
        this.remaining = this.imgW * this.imgH;
        this.curPixel = 0;
        this.compress(this.initCodeSize + 1, outputStream);
        outputStream.write(0);
    }

    void flush_char(OutputStream outputStream) {
        if (this.a_count > 0) {
            outputStream.write(this.a_count);
            outputStream.write(this.accum, 0, this.a_count);
            this.a_count = 0;
        }
    }

    final int MAXCODE(int n2) {
        return (1 << n2) - 1;
    }

    private int nextPixel() {
        if (this.remaining == 0) {
            return -1;
        }
        --this.remaining;
        byte by = this.pixAry[this.curPixel++];
        return by & 0xFF;
    }

    void output(int n2, OutputStream outputStream) {
        this.cur_accum &= this.masks[this.cur_bits];
        this.cur_accum = this.cur_bits > 0 ? (this.cur_accum |= n2 << this.cur_bits) : n2;
        this.cur_bits += this.n_bits;
        while (this.cur_bits >= 8) {
            this.char_out((byte)(this.cur_accum & 0xFF), outputStream);
            this.cur_accum >>= 8;
            this.cur_bits -= 8;
        }
        if (this.free_ent > this.maxcode || this.clear_flg) {
            if (this.clear_flg) {
                this.n_bits = this.g_init_bits;
                this.maxcode = this.MAXCODE(this.n_bits);
                this.clear_flg = false;
            } else {
                ++this.n_bits;
                this.maxcode = this.n_bits == this.maxbits ? this.maxmaxcode : this.MAXCODE(this.n_bits);
            }
        }
        if (n2 == this.EOFCode) {
            while (this.cur_bits > 0) {
                this.char_out((byte)(this.cur_accum & 0xFF), outputStream);
                this.cur_accum >>= 8;
                this.cur_bits -= 8;
            }
            this.flush_char(outputStream);
        }
    }
}

