/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.disklrucache;

import android.annotation.TargetApi;
import android.os.Build;
import android.os.StrictMode;
import com.hpplay.glide.disklrucache.StrictLineReader;
import com.hpplay.glide.disklrucache.Util;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class DiskLruCache
implements Closeable {
    static final String JOURNAL_FILE = "journal";
    static final String JOURNAL_FILE_TEMP = "journal.tmp";
    static final String JOURNAL_FILE_BACKUP = "journal.bkp";
    static final String MAGIC = "libcore.io.DiskLruCache";
    static final String VERSION_1 = "1";
    static final long ANY_SEQUENCE_NUMBER = -1L;
    private static final String CLEAN = "CLEAN";
    private static final String DIRTY = "DIRTY";
    private static final String REMOVE = "REMOVE";
    private static final String READ = "READ";
    private final File directory;
    private final File journalFile;
    private final File journalFileTmp;
    private final File journalFileBackup;
    private final int appVersion;
    private long maxSize;
    private final int valueCount;
    private long size = 0L;
    private Writer journalWriter;
    private final LinkedHashMap<String, Entry> lruEntries = new LinkedHashMap(0, 0.75f, true);
    private int redundantOpCount;
    private long nextSequenceNumber = 0L;
    final ThreadPoolExecutor executorService = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DiskLruCacheThreadFactory());
    private final Callable<Void> cleanupCallable = new Callable<Void>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (DiskLruCache.this.journalWriter == null) {
                    return null;
                }
                DiskLruCache.this.trimToSize();
                if (DiskLruCache.this.journalRebuildRequired()) {
                    DiskLruCache.this.rebuildJournal();
                    DiskLruCache.this.redundantOpCount = 0;
                }
            }
            return null;
        }
    };

    private DiskLruCache(File file, int n2, int n3, long l2) {
        this.directory = file;
        this.appVersion = n2;
        this.journalFile = new File(file, JOURNAL_FILE);
        this.journalFileTmp = new File(file, JOURNAL_FILE_TEMP);
        this.journalFileBackup = new File(file, JOURNAL_FILE_BACKUP);
        this.valueCount = n3;
        this.maxSize = l2;
    }

    public static DiskLruCache open(File file, int n2, int n3, long l2) {
        Object object;
        if (l2 <= 0L) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException("valueCount <= 0");
        }
        File file2 = new File(file, JOURNAL_FILE_BACKUP);
        if (file2.exists()) {
            object = new File(file, JOURNAL_FILE);
            if (((File)object).exists()) {
                file2.delete();
            } else {
                DiskLruCache.renameTo(file2, (File)object, false);
            }
        }
        object = new DiskLruCache(file, n2, n3, l2);
        if (((DiskLruCache)object).journalFile.exists()) {
            try {
                super.readJournal();
                super.processJournal();
                return object;
            }
            catch (IOException iOException) {
                System.out.println("DiskLruCache " + file + " is corrupt: " + iOException.getMessage() + ", removing");
                ((DiskLruCache)object).delete();
            }
        }
        file.mkdirs();
        object = new DiskLruCache(file, n2, n3, l2);
        super.rebuildJournal();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readJournal() {
        StrictLineReader strictLineReader = new StrictLineReader(new FileInputStream(this.journalFile), Util.US_ASCII);
        try {
            String string = strictLineReader.readLine();
            String string2 = strictLineReader.readLine();
            String string3 = strictLineReader.readLine();
            String string4 = strictLineReader.readLine();
            String string5 = strictLineReader.readLine();
            if (!(MAGIC.equals(string) && VERSION_1.equals(string2) && Integer.toString(this.appVersion).equals(string3) && Integer.toString(this.valueCount).equals(string4) && "".equals(string5))) {
                throw new IOException("unexpected journal header: [" + string + ", " + string2 + ", " + string4 + ", " + string5 + "]");
            }
            int n2 = 0;
            try {
                while (true) {
                    this.readJournalLine(strictLineReader.readLine());
                    ++n2;
                }
            }
            catch (EOFException eOFException) {
                this.redundantOpCount = n2 - this.lruEntries.size();
                if (strictLineReader.hasUnterminatedLine()) {
                    this.rebuildJournal();
                } else {
                    this.journalWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.journalFile, true), Util.US_ASCII));
                }
                Util.closeQuietly(strictLineReader);
            }
        }
        catch (Throwable throwable) {
            Util.closeQuietly(strictLineReader);
            throw throwable;
        }
    }

    private void readJournalLine(String string) {
        Entry entry;
        String string2;
        int n2 = string.indexOf(32);
        if (n2 == -1) {
            throw new IOException("unexpected journal line: " + string);
        }
        int n3 = n2 + 1;
        int n4 = string.indexOf(32, n3);
        if (n4 == -1) {
            string2 = string.substring(n3);
            if (n2 == REMOVE.length() && string.startsWith(REMOVE)) {
                this.lruEntries.remove(string2);
                return;
            }
        } else {
            string2 = string.substring(n3, n4);
        }
        if ((entry = this.lruEntries.get(string2)) == null) {
            entry = new Entry(string2);
            this.lruEntries.put(string2, entry);
        }
        if (n4 != -1 && n2 == CLEAN.length() && string.startsWith(CLEAN)) {
            String[] stringArray = string.substring(n4 + 1).split(" ");
            entry.readable = true;
            entry.currentEditor = null;
            entry.setLengths(stringArray);
        } else if (n4 == -1 && n2 == DIRTY.length() && string.startsWith(DIRTY)) {
            entry.currentEditor = new Editor(entry);
        } else if (n4 != -1 || n2 != READ.length() || !string.startsWith(READ)) {
            throw new IOException("unexpected journal line: " + string);
        }
    }

    private void processJournal() {
        DiskLruCache.deleteIfExists(this.journalFileTmp);
        Iterator<Entry> iterator = this.lruEntries.values().iterator();
        while (iterator.hasNext()) {
            int n2;
            Entry entry = iterator.next();
            if (entry.currentEditor == null) {
                for (n2 = 0; n2 < this.valueCount; ++n2) {
                    this.size += entry.lengths[n2];
                }
                continue;
            }
            entry.currentEditor = null;
            for (n2 = 0; n2 < this.valueCount; ++n2) {
                DiskLruCache.deleteIfExists(entry.getCleanFile(n2));
                DiskLruCache.deleteIfExists(entry.getDirtyFile(n2));
            }
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void rebuildJournal() {
        if (this.journalWriter != null) {
            DiskLruCache.closeWriter(this.journalWriter);
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.journalFileTmp), Util.US_ASCII));
        try {
            bufferedWriter.write(MAGIC);
            bufferedWriter.write("\n");
            bufferedWriter.write(VERSION_1);
            bufferedWriter.write("\n");
            bufferedWriter.write(Integer.toString(this.appVersion));
            bufferedWriter.write("\n");
            bufferedWriter.write(Integer.toString(this.valueCount));
            bufferedWriter.write("\n");
            bufferedWriter.write("\n");
            for (Entry entry : this.lruEntries.values()) {
                if (entry.currentEditor != null) {
                    bufferedWriter.write("DIRTY " + entry.key + '\n');
                    continue;
                }
                bufferedWriter.write("CLEAN " + entry.key + entry.getLengths() + '\n');
            }
        }
        finally {
            DiskLruCache.closeWriter(bufferedWriter);
        }
        if (this.journalFile.exists()) {
            DiskLruCache.renameTo(this.journalFile, this.journalFileBackup, true);
        }
        DiskLruCache.renameTo(this.journalFileTmp, this.journalFile, false);
        this.journalFileBackup.delete();
        this.journalWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.journalFile, true), Util.US_ASCII));
    }

    private static void deleteIfExists(File file) {
        if (file.exists() && !file.delete()) {
            throw new IOException();
        }
    }

    private static void renameTo(File file, File file2, boolean bl) {
        if (bl) {
            DiskLruCache.deleteIfExists(file2);
        }
        if (!file.renameTo(file2)) {
            throw new IOException();
        }
    }

    public synchronized Value get(String string) {
        this.checkNotClosed();
        Entry entry = this.lruEntries.get(string);
        if (entry == null) {
            return null;
        }
        if (!entry.readable) {
            return null;
        }
        for (File file : entry.cleanFiles) {
            if (file.exists()) continue;
            return null;
        }
        ++this.redundantOpCount;
        this.journalWriter.append(READ);
        this.journalWriter.append(' ');
        this.journalWriter.append(string);
        this.journalWriter.append('\n');
        if (this.journalRebuildRequired()) {
            this.executorService.submit(this.cleanupCallable);
        }
        return new Value(string, entry.sequenceNumber, entry.cleanFiles, entry.lengths);
    }

    public Editor edit(String string) {
        return this.edit(string, -1L);
    }

    private synchronized Editor edit(String string, long l2) {
        this.checkNotClosed();
        Entry entry = this.lruEntries.get(string);
        if (l2 != -1L && (entry == null || entry.sequenceNumber != l2)) {
            return null;
        }
        if (entry == null) {
            entry = new Entry(string);
            this.lruEntries.put(string, entry);
        } else if (entry.currentEditor != null) {
            return null;
        }
        Editor editor = new Editor(entry);
        entry.currentEditor = editor;
        this.journalWriter.append(DIRTY);
        this.journalWriter.append(' ');
        this.journalWriter.append(string);
        this.journalWriter.append('\n');
        DiskLruCache.flushWriter(this.journalWriter);
        return editor;
    }

    public File getDirectory() {
        return this.directory;
    }

    public synchronized long getMaxSize() {
        return this.maxSize;
    }

    public synchronized void setMaxSize(long l2) {
        this.maxSize = l2;
        this.executorService.submit(this.cleanupCallable);
    }

    public synchronized long size() {
        return this.size;
    }

    private synchronized void completeEdit(Editor editor, boolean bl) {
        int n2;
        Entry entry = editor.entry;
        if (entry.currentEditor != editor) {
            throw new IllegalStateException();
        }
        if (bl && !entry.readable) {
            for (n2 = 0; n2 < this.valueCount; ++n2) {
                if (!editor.written[n2]) {
                    editor.abort();
                    throw new IllegalStateException("Newly created entry didn't create value for index " + n2);
                }
                if (entry.getDirtyFile(n2).exists()) continue;
                editor.abort();
                return;
            }
        }
        for (n2 = 0; n2 < this.valueCount; ++n2) {
            File file = entry.getDirtyFile(n2);
            if (bl) {
                long l2;
                if (!file.exists()) continue;
                File file2 = entry.getCleanFile(n2);
                file.renameTo(file2);
                long l3 = entry.lengths[n2];
                ((Entry)entry).lengths[n2] = l2 = file2.length();
                this.size = this.size - l3 + l2;
                continue;
            }
            DiskLruCache.deleteIfExists(file);
        }
        ++this.redundantOpCount;
        entry.currentEditor = null;
        if (entry.readable | bl) {
            entry.readable = true;
            this.journalWriter.append(CLEAN);
            this.journalWriter.append(' ');
            this.journalWriter.append(entry.key);
            this.journalWriter.append(entry.getLengths());
            this.journalWriter.append('\n');
            if (bl) {
                entry.sequenceNumber = this.nextSequenceNumber++;
            }
        } else {
            this.lruEntries.remove(entry.key);
            this.journalWriter.append(REMOVE);
            this.journalWriter.append(' ');
            this.journalWriter.append(entry.key);
            this.journalWriter.append('\n');
        }
        DiskLruCache.flushWriter(this.journalWriter);
        if (this.size > this.maxSize || this.journalRebuildRequired()) {
            this.executorService.submit(this.cleanupCallable);
        }
    }

    private boolean journalRebuildRequired() {
        int n2 = 2000;
        return this.redundantOpCount >= 2000 && this.redundantOpCount >= this.lruEntries.size();
    }

    public synchronized boolean remove(String string) {
        this.checkNotClosed();
        Entry entry = this.lruEntries.get(string);
        if (entry == null || entry.currentEditor != null) {
            return false;
        }
        for (int i2 = 0; i2 < this.valueCount; ++i2) {
            File file = entry.getCleanFile(i2);
            if (file.exists() && !file.delete()) {
                throw new IOException("failed to delete " + file);
            }
            this.size -= entry.lengths[i2];
            ((Entry)entry).lengths[i2] = 0L;
        }
        ++this.redundantOpCount;
        this.journalWriter.append(REMOVE);
        this.journalWriter.append(' ');
        this.journalWriter.append(string);
        this.journalWriter.append('\n');
        this.lruEntries.remove(string);
        if (this.journalRebuildRequired()) {
            this.executorService.submit(this.cleanupCallable);
        }
        return true;
    }

    public synchronized boolean isClosed() {
        return this.journalWriter == null;
    }

    private void checkNotClosed() {
        if (this.journalWriter == null) {
            throw new IllegalStateException("cache is closed");
        }
    }

    public synchronized void flush() {
        this.checkNotClosed();
        this.trimToSize();
        DiskLruCache.flushWriter(this.journalWriter);
    }

    @Override
    public synchronized void close() {
        if (this.journalWriter == null) {
            return;
        }
        for (Entry entry : new ArrayList<Entry>(this.lruEntries.values())) {
            if (entry.currentEditor == null) continue;
            entry.currentEditor.abort();
        }
        this.trimToSize();
        DiskLruCache.closeWriter(this.journalWriter);
        this.journalWriter = null;
    }

    private void trimToSize() {
        while (this.size > this.maxSize) {
            Map.Entry<String, Entry> entry = this.lruEntries.entrySet().iterator().next();
            this.remove(entry.getKey());
        }
    }

    public void delete() {
        this.close();
        Util.deleteContents(this.directory);
    }

    private static String inputStreamToString(InputStream inputStream) {
        return Util.readFully(new InputStreamReader(inputStream, Util.UTF_8));
    }

    @TargetApi(value=26)
    private static void closeWriter(Writer writer) {
        if (Build.VERSION.SDK_INT < 26) {
            writer.close();
            return;
        }
        StrictMode.ThreadPolicy threadPolicy = StrictMode.getThreadPolicy();
        StrictMode.ThreadPolicy threadPolicy2 = new StrictMode.ThreadPolicy.Builder(threadPolicy).permitUnbufferedIo().build();
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy2);
        try {
            writer.close();
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    @TargetApi(value=26)
    private static void flushWriter(Writer writer) {
        if (Build.VERSION.SDK_INT < 26) {
            writer.flush();
            return;
        }
        StrictMode.ThreadPolicy threadPolicy = StrictMode.getThreadPolicy();
        StrictMode.ThreadPolicy threadPolicy2 = new StrictMode.ThreadPolicy.Builder(threadPolicy).permitUnbufferedIo().build();
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy2);
        try {
            writer.flush();
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    private static final class DiskLruCacheThreadFactory
    implements ThreadFactory {
        private DiskLruCacheThreadFactory() {
        }

        @Override
        public synchronized Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "glide-disk-lru-cache-thread");
            thread.setPriority(1);
            return thread;
        }
    }

    private final class Entry {
        private final String key;
        private final long[] lengths;
        File[] cleanFiles;
        File[] dirtyFiles;
        private boolean readable;
        private Editor currentEditor;
        private long sequenceNumber;

        private Entry(String string) {
            this.key = string;
            this.lengths = new long[DiskLruCache.this.valueCount];
            this.cleanFiles = new File[DiskLruCache.this.valueCount];
            this.dirtyFiles = new File[DiskLruCache.this.valueCount];
            StringBuilder stringBuilder = new StringBuilder(string).append('.');
            int n2 = stringBuilder.length();
            for (int i2 = 0; i2 < DiskLruCache.this.valueCount; ++i2) {
                stringBuilder.append(i2);
                this.cleanFiles[i2] = new File(DiskLruCache.this.directory, stringBuilder.toString());
                stringBuilder.append(".tmp");
                this.dirtyFiles[i2] = new File(DiskLruCache.this.directory, stringBuilder.toString());
                stringBuilder.setLength(n2);
            }
        }

        public String getLengths() {
            StringBuilder stringBuilder = new StringBuilder();
            for (long l2 : this.lengths) {
                stringBuilder.append(' ').append(l2);
            }
            return stringBuilder.toString();
        }

        private void setLengths(String[] stringArray) {
            if (stringArray.length != DiskLruCache.this.valueCount) {
                throw this.invalidLengths(stringArray);
            }
            try {
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    this.lengths[i2] = Long.parseLong(stringArray[i2]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw this.invalidLengths(stringArray);
            }
        }

        private IOException invalidLengths(String[] stringArray) {
            throw new IOException("unexpected journal line: " + Arrays.toString(stringArray));
        }

        public File getCleanFile(int n2) {
            return this.cleanFiles[n2];
        }

        public File getDirtyFile(int n2) {
            return this.dirtyFiles[n2];
        }
    }

    public final class Editor {
        private final Entry entry;
        private final boolean[] written;
        private boolean committed;

        private Editor(Entry entry) {
            this.entry = entry;
            this.written = entry.readable ? null : new boolean[DiskLruCache.this.valueCount];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private InputStream newInputStream(int n2) {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (this.entry.currentEditor != this) {
                    throw new IllegalStateException();
                }
                if (!this.entry.readable) {
                    return null;
                }
                try {
                    return new FileInputStream(this.entry.getCleanFile(n2));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return null;
                }
            }
        }

        public String getString(int n2) {
            InputStream inputStream = this.newInputStream(n2);
            return inputStream != null ? DiskLruCache.inputStreamToString(inputStream) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public File getFile(int n2) {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (this.entry.currentEditor != this) {
                    throw new IllegalStateException();
                }
                if (!this.entry.readable) {
                    this.written[n2] = true;
                }
                File file = this.entry.getDirtyFile(n2);
                DiskLruCache.this.directory.mkdirs();
                return file;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(int n2, String string) {
            OutputStreamWriter outputStreamWriter = null;
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.getFile(n2));
                outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, Util.UTF_8);
                outputStreamWriter.write(string);
            }
            catch (Throwable throwable) {
                Util.closeQuietly(outputStreamWriter);
                throw throwable;
            }
            Util.closeQuietly(outputStreamWriter);
        }

        public void commit() {
            DiskLruCache.this.completeEdit(this, true);
            this.committed = true;
        }

        public void abort() {
            DiskLruCache.this.completeEdit(this, false);
        }

        public void abortUnlessCommitted() {
            if (!this.committed) {
                try {
                    this.abort();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public final class Value {
        private final String key;
        private final long sequenceNumber;
        private final long[] lengths;
        private final File[] files;

        private Value(String string, long l2, File[] fileArray, long[] lArray) {
            this.key = string;
            this.sequenceNumber = l2;
            this.files = fileArray;
            this.lengths = lArray;
        }

        public Editor edit() {
            return DiskLruCache.this.edit(this.key, this.sequenceNumber);
        }

        public File getFile(int n2) {
            return this.files[n2];
        }

        public String getString(int n2) {
            FileInputStream fileInputStream = new FileInputStream(this.files[n2]);
            return DiskLruCache.inputStreamToString(fileInputStream);
        }

        public long getLength(int n2) {
            return this.lengths[n2];
        }
    }
}

