/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.cybergarage.xml;

import com.hpplay.component.common.utils.CLog;
import com.hpplay.cybergarage.http.HTTPRequest;
import com.hpplay.cybergarage.http.HTTPResponse;
import com.hpplay.cybergarage.xml.Node;
import com.hpplay.cybergarage.xml.ParserException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;

public abstract class Parser {
    public abstract Node parse(InputStream var1);

    public Node parseUrl(String string) {
        return this.parse(string, 30000);
    }

    public Node parse(String string, int n2) {
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (Exception exception) {
            uRL = new URL(URLDecoder.decode(string));
        }
        String string2 = uRL.getHost();
        int n3 = uRL.getPort();
        if (n3 == -1) {
            n3 = 80;
        }
        String string3 = uRL.getPath();
        CLog.i("parserp", "   start " + uRL.toString());
        long l2 = System.currentTimeMillis();
        try {
            return this.httpGet(uRL, n2, string2);
        }
        catch (Exception exception) {
            CLog.i("parserp", "first parse failed");
            CLog.i("parserp", uRL + "   error ");
            HTTPRequest hTTPRequest = new HTTPRequest();
            hTTPRequest.setMethod("GET");
            hTTPRequest.setURI(string3);
            HTTPResponse hTTPResponse = hTTPRequest.post(string2, n3);
            if (!hTTPResponse.isSuccessful()) {
                throw new ParserException("HTTP comunication failed: no answer from peer.Unable to retrive resoure -> " + uRL.toString());
            }
            String string4 = new String(hTTPResponse.getContent());
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string4.getBytes());
            CLog.i("parserp", "   end ======== " + (System.currentTimeMillis() - l2));
            return this.parse(byteArrayInputStream);
        }
    }

    private Node httpGet(URL uRL, int n2, String string) {
        long l2 = System.currentTimeMillis();
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestMethod("GET");
        httpURLConnection.setConnectTimeout(n2);
        httpURLConnection.setRequestProperty("Content-Length", "0");
        if (string != null) {
            httpURLConnection.setRequestProperty("HOST", string);
        }
        InputStream inputStream = httpURLConnection.getInputStream();
        Node node = this.parse(inputStream);
        inputStream.close();
        httpURLConnection.disconnect();
        CLog.i("parserp", "   end ======== " + (System.currentTimeMillis() - l2));
        return node;
    }

    public Node parse(File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            Node node = this.parse(fileInputStream);
            ((InputStream)fileInputStream).close();
            return node;
        }
        catch (Exception exception) {
            throw new ParserException(exception);
        }
    }

    public Node parse(String string) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            Node node = this.parse(byteArrayInputStream);
            return node;
        }
        catch (Exception exception) {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(URLDecoder.decode(string).getBytes());
                Node node = this.parse(byteArrayInputStream);
                return node;
            }
            catch (Exception exception2) {
                throw new ParserException(exception2);
            }
        }
    }
}

