/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.cybergarage.upnp.ssdp;

import com.hpplay.component.common.utils.CLog;
import com.hpplay.cybergarage.net.HostInterface;
import com.hpplay.cybergarage.upnp.ControlPoint;
import com.hpplay.cybergarage.upnp.ssdp.SSDP;
import com.hpplay.cybergarage.upnp.ssdp.SSDPSearchRequest;
import com.hpplay.cybergarage.upnp.ssdp.SSDPSearchResponseSocket;
import java.net.InetAddress;
import java.util.Vector;

public class SSDPSearchResponseSocketList
extends Vector {
    private InetAddress[] binds = null;

    public SSDPSearchResponseSocketList() {
    }

    public SSDPSearchResponseSocketList(InetAddress[] inetAddressArray) {
        this.binds = inetAddressArray;
    }

    public void setControlPoint(ControlPoint controlPoint) {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            SSDPSearchResponseSocket sSDPSearchResponseSocket = this.getSSDPSearchResponseSocket(i2);
            sSDPSearchResponseSocket.setControlPoint(controlPoint);
        }
    }

    public SSDPSearchResponseSocket getSSDPSearchResponseSocket(int n2) {
        return (SSDPSearchResponseSocket)this.get(n2);
    }

    public boolean open(int n2) {
        int n3;
        String[] stringArray;
        InetAddress[] inetAddressArray = this.binds;
        if (inetAddressArray != null) {
            stringArray = new String[inetAddressArray.length];
            for (n3 = 0; n3 < inetAddressArray.length; ++n3) {
                stringArray[n3] = inetAddressArray[n3].getHostAddress();
            }
        } else {
            n3 = HostInterface.getNHostAddresses();
            stringArray = new String[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                stringArray[i2] = HostInterface.getHostAddress(i2);
            }
        }
        try {
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                SSDPSearchResponseSocket sSDPSearchResponseSocket = new SSDPSearchResponseSocket(stringArray[n3], n2);
                this.add(sSDPSearchResponseSocket);
            }
        }
        catch (Exception exception) {
            this.callbackErrorCode();
            this.stop();
            this.close();
            this.clear();
            return false;
        }
        return true;
    }

    public boolean open() {
        return this.open(1900);
    }

    public void callbackErrorCode() {
        try {
            int n2 = this.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                SSDPSearchResponseSocket sSDPSearchResponseSocket = this.getSSDPSearchResponseSocket(i2);
                if (sSDPSearchResponseSocket.getControlPoint() == null) continue;
                sSDPSearchResponseSocket.getControlPoint().callbackResultCode(5);
            }
        }
        catch (Exception exception) {
            CLog.w("SSDPSearchList", exception);
        }
    }

    public void close() {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            SSDPSearchResponseSocket sSDPSearchResponseSocket = this.getSSDPSearchResponseSocket(i2);
            sSDPSearchResponseSocket.close();
        }
        this.clear();
    }

    public void start() {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            SSDPSearchResponseSocket sSDPSearchResponseSocket = this.getSSDPSearchResponseSocket(i2);
            sSDPSearchResponseSocket.start();
        }
    }

    public void stop() {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            SSDPSearchResponseSocket sSDPSearchResponseSocket = this.getSSDPSearchResponseSocket(i2);
            sSDPSearchResponseSocket.stop();
        }
    }

    public boolean post(SSDPSearchRequest sSDPSearchRequest) {
        boolean bl = true;
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            SSDPSearchResponseSocket sSDPSearchResponseSocket = this.getSSDPSearchResponseSocket(i2);
            String string = sSDPSearchResponseSocket.getLocalAddress();
            sSDPSearchRequest.setLocalAddress(string);
            String string2 = "239.255.255.250";
            if (HostInterface.isIPv6Address(string)) {
                string2 = SSDP.getIPv6Address();
            }
            if (sSDPSearchResponseSocket.post(string2, 1900, sSDPSearchRequest)) continue;
            bl = false;
        }
        return bl;
    }
}

