/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.cybergarage.upnp;

import com.hpplay.cybergarage.upnp.Action;
import com.hpplay.cybergarage.upnp.Service;
import com.hpplay.cybergarage.upnp.StateVariable;
import com.hpplay.cybergarage.upnp.xml.ArgumentData;
import com.hpplay.cybergarage.xml.Node;

public class Argument {
    public static final String ELEM_NAME = "argument";
    public static final String IN = "in";
    public static final String OUT = "out";
    private Node argumentNode;
    private Node serviceNode;
    private static final String NAME = "name";
    private static final String DIRECTION = "direction";
    private static final String RELATED_STATE_VARIABLE = "relatedStateVariable";
    private Object userData = null;

    public Node getArgumentNode() {
        return this.argumentNode;
    }

    private Node getServiceNode() {
        return this.serviceNode;
    }

    public Service getService() {
        return new Service(this.getServiceNode());
    }

    void setService(Service service) {
        service.getServiceNode();
    }

    public Node getActionNode() {
        Node node = this.getArgumentNode().getParentNode();
        if (node == null) {
            return null;
        }
        Node node2 = node.getParentNode();
        if (node2 == null) {
            return null;
        }
        if (!Action.isActionNode(node2)) {
            return null;
        }
        return node2;
    }

    public Action getAction() {
        return new Action(this.getServiceNode(), this.getActionNode());
    }

    public Argument() {
        this.argumentNode = new Node(ELEM_NAME);
        this.serviceNode = null;
    }

    public Argument(Node node) {
        this.argumentNode = new Node(ELEM_NAME);
        this.serviceNode = node;
    }

    public Argument(Node node, Node node2) {
        this.serviceNode = node;
        this.argumentNode = node2;
    }

    public Argument(String string, String string2) {
        this();
        this.setName(string);
        this.setValue(string2);
    }

    public static boolean isArgumentNode(Node node) {
        return ELEM_NAME.equals(node.getName());
    }

    public void setName(String string) {
        this.getArgumentNode().setNode(NAME, string);
    }

    public String getName() {
        return this.getArgumentNode().getNodeValue(NAME);
    }

    public void setDirection(String string) {
        this.getArgumentNode().setNode(DIRECTION, string);
    }

    public String getDirection() {
        return this.getArgumentNode().getNodeValue(DIRECTION);
    }

    public boolean isInDirection() {
        String string = this.getDirection();
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase(IN);
    }

    public boolean isOutDirection() {
        return !this.isInDirection();
    }

    public void setRelatedStateVariableName(String string) {
        this.getArgumentNode().setNode(RELATED_STATE_VARIABLE, string);
    }

    public String getRelatedStateVariableName() {
        return this.getArgumentNode().getNodeValue(RELATED_STATE_VARIABLE);
    }

    public StateVariable getRelatedStateVariable() {
        Service service = this.getService();
        if (service == null) {
            return null;
        }
        String string = this.getRelatedStateVariableName();
        return service.getStateVariable(string);
    }

    private ArgumentData getArgumentData() {
        Node node = this.getArgumentNode();
        ArgumentData argumentData = (ArgumentData)node.getUserData();
        if (argumentData == null) {
            argumentData = new ArgumentData();
            node.setUserData(argumentData);
            argumentData.setNode(node);
        }
        return argumentData;
    }

    public void setValue(String string) {
        this.getArgumentData().setValue(string);
    }

    public void setValue(int n2) {
        this.setValue(Integer.toString(n2));
    }

    public String getValue() {
        return this.getArgumentData().getValue();
    }

    public int getIntegerValue() {
        String string = this.getValue();
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void setUserData(Object object) {
        this.userData = object;
    }

    public Object getUserData() {
        return this.userData;
    }
}

