/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.cybergarage.http;

import com.hpplay.cybergarage.http.HTTP;
import com.hpplay.cybergarage.http.HTTPResponse;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Calendar;

public class HTTPSocket {
    private Socket socket = null;
    private InputStream sockIn = null;
    private OutputStream sockOut = null;

    public HTTPSocket(Socket socket) {
        this.setSocket(socket);
        this.open();
    }

    public HTTPSocket(HTTPSocket hTTPSocket) {
        this.setSocket(hTTPSocket.getSocket());
        this.setInputStream(hTTPSocket.getInputStream());
        this.setOutputStream(hTTPSocket.getOutputStream());
    }

    public void finalize() {
        this.close();
    }

    private void setSocket(Socket socket) {
        this.socket = socket;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public String getLocalAddress() {
        return this.getSocket().getLocalAddress().getHostAddress();
    }

    public int getLocalPort() {
        return this.getSocket().getLocalPort();
    }

    private void setInputStream(InputStream inputStream) {
        this.sockIn = inputStream;
    }

    public InputStream getInputStream() {
        return this.sockIn;
    }

    private void setOutputStream(OutputStream outputStream) {
        this.sockOut = outputStream;
    }

    private OutputStream getOutputStream() {
        return this.sockOut;
    }

    public boolean open() {
        Socket socket = this.getSocket();
        try {
            this.sockIn = socket.getInputStream();
            this.sockOut = socket.getOutputStream();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean close() {
        try {
            if (this.sockIn != null) {
                this.sockIn.close();
            }
            if (this.sockOut != null) {
                this.sockOut.close();
            }
            this.getSocket().close();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean post(HTTPResponse hTTPResponse, byte[] byArray, long l2, long l3, boolean bl) {
        hTTPResponse.setDate(Calendar.getInstance());
        OutputStream outputStream = this.getOutputStream();
        try {
            hTTPResponse.setContentLength(l3);
            outputStream.write(hTTPResponse.getHeader().getBytes());
            outputStream.write("\r\n".getBytes());
            if (bl) {
                outputStream.flush();
                return true;
            }
            boolean bl2 = hTTPResponse.isChunked();
            if (bl2) {
                String string = Long.toHexString(l3);
                outputStream.write(string.getBytes());
                outputStream.write("\r\n".getBytes());
            }
            outputStream.write(byArray, (int)l2, (int)l3);
            if (bl2) {
                outputStream.write("\r\n".getBytes());
                outputStream.write("0".getBytes());
                outputStream.write("\r\n".getBytes());
            }
            outputStream.flush();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean post(HTTPResponse hTTPResponse, InputStream inputStream, long l2, long l3, boolean bl) {
        hTTPResponse.setDate(Calendar.getInstance());
        OutputStream outputStream = this.getOutputStream();
        try {
            hTTPResponse.setContentLength(l3);
            outputStream.write(hTTPResponse.getHeader().getBytes());
            outputStream.write("\r\n".getBytes());
            if (bl) {
                outputStream.flush();
                return true;
            }
            boolean bl2 = hTTPResponse.isChunked();
            if (0L < l2) {
                inputStream.skip(l2);
            }
            int n2 = HTTP.getChunkSize();
            byte[] byArray = new byte[n2];
            long l4 = 0L;
            long l5 = (long)n2 < l3 ? (long)n2 : l3;
            int n3 = inputStream.read(byArray, 0, (int)l5);
            while (0 < n3 && l4 < l3) {
                if (bl2) {
                    String string = Long.toHexString(n3);
                    outputStream.write(string.getBytes());
                    outputStream.write("\r\n".getBytes());
                }
                outputStream.write(byArray, 0, n3);
                if (bl2) {
                    outputStream.write("\r\n".getBytes());
                }
                l5 = (long)n2 < l3 - (l4 += (long)n3) ? (long)n2 : l3 - l4;
                n3 = inputStream.read(byArray, 0, (int)l5);
            }
            if (bl2) {
                outputStream.write("0".getBytes());
                outputStream.write("\r\n".getBytes());
            }
            outputStream.flush();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean post(HTTPResponse hTTPResponse, long l2, long l3, boolean bl) {
        if (hTTPResponse.hasContentInputStream()) {
            return this.post(hTTPResponse, hTTPResponse.getContentInputStream(), l2, l3, bl);
        }
        return this.post(hTTPResponse, hTTPResponse.getContent(), l2, l3, bl);
    }
}

