/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.utils;

import android.app.Activity;
import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.hpplay.component.common.utils.CLog;
import java.lang.reflect.Field;

public class ScreenUtil {
    private static final String TAG = "ScreenUtil";

    private ScreenUtil() {
    }

    public static int getScreenWidth(Context context) {
        if (null == context) {
            CLog.i(TAG, "getScreenWidth fail  context is: null");
            return -1;
        }
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return displayMetrics.widthPixels;
    }

    public static int getScreenHeight(Context context) {
        if (null == context) {
            CLog.i(TAG, "getScreenWidth fail  context is: null");
            return -1;
        }
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return displayMetrics.heightPixels;
    }

    public static int getDensityDpi(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        if (displayMetrics != null) {
            return displayMetrics.densityDpi;
        }
        return 0;
    }

    public static float getDensity(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return displayMetrics.density;
    }

    private static double getScreenInches(Context context) {
        int n2 = ScreenUtil.getScreenWidth(context);
        int n3 = ScreenUtil.getScreenHeight(context);
        double d2 = Math.pow(n2, 2.0);
        double d3 = Math.pow(n3, 2.0);
        double d4 = Math.sqrt(d2 + d3);
        int n4 = ScreenUtil.getDensityDpi(context);
        return d4 / (double)n4;
    }

    public static int getStatusBarHeight(Activity activity) {
        Rect rect = new Rect();
        activity.getWindow().getDecorView().getWindowVisibleDisplayFrame(rect);
        int n2 = rect.top;
        if (n2 <= 0) {
            try {
                Class<?> clazz = Class.forName("com.android.internal.R$dimen");
                Object obj = clazz.newInstance();
                Field field = clazz.getField("status_bar_height");
                int n3 = Integer.parseInt(field.get(obj).toString());
                n2 = activity.getResources().getDimensionPixelSize(n3);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return n2;
    }

    public static int[] getRelScreenSize(Context context) {
        int[] nArray = new int[2];
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        display.getMetrics(displayMetrics);
        int n2 = displayMetrics.widthPixels;
        int n3 = displayMetrics.heightPixels;
        if (Build.VERSION.SDK_INT >= 14 && Build.VERSION.SDK_INT < 17) {
            try {
                n2 = (Integer)Display.class.getMethod("getRawWidth", new Class[0]).invoke((Object)display, new Object[0]);
                n3 = (Integer)Display.class.getMethod("getRawHeight", new Class[0]).invoke((Object)display, new Object[0]);
            }
            catch (Exception exception) {
                CLog.w(TAG, exception);
            }
        }
        if (Build.VERSION.SDK_INT >= 17) {
            try {
                Point point = new Point();
                Display.class.getMethod("getRealSize", Point.class).invoke((Object)display, point);
                n2 = point.x;
                n3 = point.y;
            }
            catch (Exception exception) {
                CLog.w(TAG, exception);
            }
        }
        nArray[0] = n2;
        nArray[1] = n3;
        CLog.d("ScreenUtils", " widthPixels  " + n2 + " heightPixels " + n3);
        return nArray;
    }
}

