/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.srp6.cli;

import com.hpplay.component.protocol.srp6.BigIntegerUtils;
import com.hpplay.component.protocol.srp6.SRP6CryptoParams;
import com.hpplay.component.protocol.srp6.SRP6Exception;
import com.hpplay.component.protocol.srp6.SRP6ServerSession;
import com.hpplay.component.protocol.srp6.cli.SRP6Tool;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SRP6Server
extends SRP6Tool {
    protected SecureRandom random = new SecureRandom();

    @Override
    public void run() {
        BigInteger bigInteger;
        this.println("*** Nimbus SRP-6a server ***");
        this.println();
        this.println("Initialize server session");
        SRP6CryptoParams sRP6CryptoParams = this.getConfig("\t");
        SRP6ServerSession sRP6ServerSession = new SRP6ServerSession(sRP6CryptoParams){
            {
                this.random = SRP6Server.this.random;
            }
        };
        this.println("Server session step 1");
        this.print("\tEnter user identity 'I': ");
        String string = this.readInput();
        this.print("\tEnter password salt 's' (hex): ");
        BigInteger bigInteger2 = this.readBigInteger();
        this.print("\tEnter password verifier 'v' (hex): ");
        BigInteger bigInteger3 = this.readBigInteger();
        BigInteger bigInteger4 = sRP6ServerSession.step1(string, bigInteger2, bigInteger3);
        this.println();
        this.logB(BigIntegerUtils.toHex(bigInteger4));
        this.println();
        this.println("Server session step 2");
        this.print("\tEnter client public value 'A' (hex): ");
        BigInteger bigInteger5 = this.readBigInteger();
        this.print("\tEnter client evidence message 'M1' (hex): ");
        BigInteger bigInteger6 = this.readBigInteger();
        try {
            bigInteger = sRP6ServerSession.step2(bigInteger5, bigInteger6);
        }
        catch (SRP6Exception sRP6Exception) {
            this.println(sRP6Exception.getMessage());
            return;
        }
        this.println();
        this.logM2(BigIntegerUtils.toHex(bigInteger));
        this.println();
        this.println("Mutual authentication successfully completed");
        this.println();
        this.logS(BigIntegerUtils.toHex(sRP6ServerSession.getSessionKey()));
        this.logShash(sRP6ServerSession.getSessionKeyHash());
    }

    void logM2(String string) {
        this.println("\tComputed server evidence message 'M2' (hex): " + string);
    }

    void logB(String string) {
        this.println("\tComputed public server value 'B' (hex): " + string);
    }

    public static void main(String[] stringArray) {
        SRP6Server sRP6Server = new SRP6Server();
        sRP6Server.run();
    }
}

