/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.push;

import android.text.TextUtils;
import com.hpplay.component.common.ParamsMap;
import com.hpplay.component.common.protocol.ProtocolListener;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.component.protocol.NLProtocolBuiler;
import com.hpplay.component.protocol.PlistBuilder;
import com.hpplay.component.protocol.ProtocolUtils;
import com.hpplay.component.protocol.plist.NSDictionary;
import com.hpplay.component.protocol.plist.PropertyListParser;
import com.hpplay.component.protocol.push.IPushHandler;
import com.hpplay.component.protocol.push.PushControllerImpl;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LelinkV2PushHandler
extends IPushHandler {
    private static final String TAG = "LelinkV2PushHandler";
    private int cseq = -1;
    private String currentMediaType;
    public static final int TYPE_SET_PLAYLIST = 1;
    public static final int TYPE_APPEND_PLAYLIST = 2;
    public static final int TYPE_CLEAR_PLAYLIST = 3;
    public static final int TYPE_PLAY_PRE = 4;
    public static final int TYPE_PLAY_NEXT = 5;
    public static final int TYPE_PLAY_ASSIGN = 6;

    public LelinkV2PushHandler(ParamsMap paramsMap) {
        super(paramsMap);
    }

    @Override
    String buildPush(String string, ParamsMap paramsMap) {
        String string2 = this.buildPlayContent(string, paramsMap);
        String string3 = this.builderHeader(new NLProtocolBuiler().getNewLeinkPlayCmd(), string2.length());
        return string3 + string2;
    }

    @Override
    String buildGetPlayInfo() {
        return this.builderHeader(new NLProtocolBuiler().getNewLeinkPlayBackInfoCmd(), 0);
    }

    @Override
    String buildGetStateInfo() {
        return null;
    }

    @Override
    String buildPause() {
        String string = new PlistBuilder().addStringToRoot("uuid", this.mPushUri).getPotocol();
        String string2 = this.builderHeader(new NLProtocolBuiler().getNewLeinkPuase(), string.length());
        return string2 + string;
    }

    @Override
    String buildResume() {
        String string = new PlistBuilder().addStringToRoot("uuid", this.mPushUri).getPotocol();
        String string2 = this.builderHeader(new NLProtocolBuiler().getNewResumeCmd(), string.length());
        return string2 + string;
    }

    @Override
    String buildSeekTo(int n2) {
        String string = new PlistBuilder().addStringToRoot("type", "position").addStringToRoot("uuid", this.mPushUri).addIntagerToRoot("seek-position", n2).getPotocol();
        String string2 = this.builderHeader(new NLProtocolBuiler().getNewLelinkSeekToScrubCmd(), string.length());
        return string2 + string;
    }

    @Override
    String buildIncreaseVolume() {
        String string = new PlistBuilder().addStringToRoot("type", "volume").addStringToRoot("event", "increase").getPotocol();
        String string2 = this.builderHeader(new NLProtocolBuiler().getNewLelinkVolumeContr(), string.length());
        return string2 + string;
    }

    @Override
    String buildDecreaseVolume() {
        String string = new PlistBuilder().addStringToRoot("type", "volume").addStringToRoot("event", "decrease").getPotocol();
        String string2 = this.builderHeader(new NLProtocolBuiler().getNewLelinkVolumeContr(), string.length());
        return string2 + string;
    }

    @Override
    String buildStopPlay() {
        String string = new PlistBuilder().addStringToRoot("media-type", this.currentMediaType).addStringToRoot("uuid", this.mPushUri).getPotocol();
        String string2 = this.builderHeader(new NLProtocolBuiler().getStopCmd(), string.length());
        return string2 + string;
    }

    @Override
    String setVolume(int n2) {
        String string = new PlistBuilder().addStringToRoot("prop-type", "volume").addIntagerToRoot("value", n2).getPotocol();
        String string2 = this.builderHeader(new NLProtocolBuiler().getSetHttpProperty(), string.length());
        return string2 + string;
    }

    @Override
    public String buildAudiotrack(int n2) {
        String string = new PlistBuilder().addStringToRoot("prop-type", "audiotrack").addIntagerToRoot("value", n2).addStringToRoot("uuid", this.mPushUri).getPotocol();
        String string2 = this.builderHeader(new NLProtocolBuiler().getSetHttpProperty(), string.length());
        return string2 + string;
    }

    public String builderHeader(NLProtocolBuiler nLProtocolBuiler, int n2) {
        ++this.cseq;
        return nLProtocolBuiler.setPlatfrom().setUserAgent("HappyCast5,0/500.0").setContentType("application/plist+xml").setNewLelinkClientId("0x" + this.mMac).setNewSessionId(this.mSessionId).setNewClientUid(this.mUid).setNewCSEQ(String.valueOf(this.cseq)).setContentLength(n2 + "").getString(true);
    }

    @Override
    public String getReverseData() {
        return new NLProtocolBuiler().getReverseCmd().setPlatfrom().setUserAgent("HappyCast5,0/500.0").setNewLelinkClientId("0x" + this.mMac).setNewSessionId(this.mSessionId).setPurposeKey("event").setConnectionKey("Upgrade").setContentLength("0").getString(true);
    }

    @Override
    public String buildSelectPlay(ParamsMap paramsMap) {
        String string = this.buildActionContent(paramsMap, 6);
        String string2 = this.builderHeader(new NLProtocolBuiler().getPlayActionCmd(), string.length());
        return string2 + string;
    }

    @Override
    public String buildSetPlayList(ParamsMap paramsMap) {
        String string = this.buildActionContent(paramsMap, 1);
        String string2 = this.builderHeader(new NLProtocolBuiler().getPlayActionCmd(), string.length());
        return string2 + string;
    }

    @Override
    public String buildAddPlayList(ParamsMap paramsMap) {
        String string = this.buildActionContent(paramsMap, 2);
        String string2 = this.builderHeader(new NLProtocolBuiler().getPlayActionCmd(), string.length());
        return string2 + string;
    }

    @Override
    public String buildPlayNext() {
        String string = this.buildActionContent(null, 5);
        String string2 = this.builderHeader(new NLProtocolBuiler().getPlayActionCmd(), string.length());
        return string2 + string;
    }

    @Override
    public String buildClearList() {
        String string = this.buildActionContent(null, 3);
        String string2 = this.builderHeader(new NLProtocolBuiler().getPlayActionCmd(), string.length());
        return string2 + string;
    }

    @Override
    public String buildPlayPre() {
        String string = this.buildActionContent(null, 4);
        String string2 = this.builderHeader(new NLProtocolBuiler().getPlayActionCmd(), string.length());
        return string2 + string;
    }

    @Override
    public void parseReversePlist(PushControllerImpl pushControllerImpl, String ... stringArray) {
        NSDictionary nSDictionary;
        if (stringArray == null || stringArray[0] == null) {
            return;
        }
        String string = stringArray[0];
        CLog.d(TAG, "---------------->" + string);
        if (string.contains("Switching Protocols")) {
            return;
        }
        if (string.contains("photohide") && pushControllerImpl != null) {
            CLog.d(TAG, "on PHOTO_HIDE");
            pushControllerImpl.disConnect();
            pushControllerImpl.eventCallback(16, new String[0]);
            return;
        }
        try {
            nSDictionary = (NSDictionary)PropertyListParser.parse(string.getBytes());
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
            return;
        }
        if (nSDictionary != null) {
            String string2 = "0";
            String string3 = "0";
            String string4 = "";
            String string5 = "";
            if (nSDictionary.containsKey("playid")) {
                string5 = nSDictionary.objectForKey("playid").toString();
            }
            if (nSDictionary.containsKey("uuid")) {
                string4 = nSDictionary.objectForKey("uuid").toString();
            }
            if (nSDictionary.containsKey("duration")) {
                string2 = nSDictionary.objectForKey("duration").toString();
            }
            if (nSDictionary.containsKey("position")) {
                string3 = nSDictionary.objectForKey("position").toString();
            }
            if (nSDictionary.containsKey("readyToPlay")) {
                return;
            }
            try {
                if (Integer.parseInt(string2) > 0 && Integer.parseInt(string3) > 0 && pushControllerImpl != null) {
                    CLog.d(TAG, "reverse to uiduration : " + string2 + "position : " + string3);
                    pushControllerImpl.eventCallback(17, string2, string3, string4);
                    return;
                }
            }
            catch (Exception exception) {
                CLog.w(TAG, exception);
            }
            if (nSDictionary.containsKey("stoptype") && pushControllerImpl != null) {
                String string6 = nSDictionary.objectForKey("stoptype").toString();
                if (TextUtils.equals((CharSequence)string6, (CharSequence)"media_completion")) {
                    pushControllerImpl.eventCallback(12, string4, string5);
                } else if (TextUtils.equals((CharSequence)string6, (CharSequence)"phonevideohide")) {
                    pushControllerImpl.eventCallback(16, string4, string5);
                    CLog.d(TAG, "on stop");
                }
                pushControllerImpl.disConnect();
                return;
            }
            if (nSDictionary.containsKey("state") && pushControllerImpl != null) {
                String string7;
                switch (string7 = nSDictionary.objectForKey("state").toString()) {
                    case "playing": {
                        pushControllerImpl.eventCallback(13, string4, string5);
                        CLog.i(TAG, "--- PLAYING ---");
                        break;
                    }
                    case "loading": {
                        pushControllerImpl.eventCallback(14, string4, string5);
                        CLog.i(TAG, "LOADING");
                        break;
                    }
                    case "paused": {
                        CLog.i(TAG, "PAUSED " + this.isPlaying);
                        pushControllerImpl.eventCallback(15, string4, string5);
                        break;
                    }
                    case "stopped": {
                        if (nSDictionary.containsKey("reason")) {
                            String string8 = nSDictionary.objectForKey("reason").toString();
                            if (TextUtils.equals((CharSequence)string8, (CharSequence)"ended")) {
                                pushControllerImpl.eventCallback(12, string4, string5);
                                return;
                            }
                            if (TextUtils.equals((CharSequence)string8, (CharSequence)"episode_stopped")) {
                                pushControllerImpl.eventCallback(26, string4, string5);
                                return;
                            }
                            if (TextUtils.equals((CharSequence)string8, (CharSequence)"preempt_stopped")) {
                                pushControllerImpl.eventCallback(28, string4, string5);
                                return;
                            }
                        }
                        pushControllerImpl.eventCallback(16, string4, string5);
                        pushControllerImpl.disConnect();
                        CLog.i(TAG, "state on stop---------");
                        break;
                    }
                    case "error": {
                        CLog.d(TAG, "ERROR");
                        pushControllerImpl.eventCallback(16, string4, string5);
                    }
                }
            }
        }
    }

    @Override
    public boolean parsePlayBackInfo(int n2, String string, ProtocolListener protocolListener) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            try {
                NSDictionary nSDictionary = (NSDictionary)PropertyListParser.parse(ProtocolUtils.removeHeader(string.getBytes()));
                String string2 = "";
                if (nSDictionary.containsKey("duration")) {
                    if (nSDictionary.containsKey("uuid")) {
                        string2 = nSDictionary.objectForKey("uuid").toString();
                    }
                    String string3 = nSDictionary.objectForKey("duration").toString();
                    String string4 = nSDictionary.objectForKey("position").toString();
                    String string5 = "";
                    if (nSDictionary.containsKey("playid")) {
                        string5 = nSDictionary.objectForKey("playid").toString();
                    }
                    if (protocolListener != null) {
                        protocolListener.onResult(n2, string3, string4, string2, string5);
                    }
                    return true;
                }
                if (nSDictionary.containsKey("playid")) {
                    if (nSDictionary.containsKey("uuid")) {
                        string2 = nSDictionary.objectForKey("uuid").toString();
                    }
                    String string6 = nSDictionary.objectForKey("playid").toString();
                    if (protocolListener != null) {
                        protocolListener.onResult(n2, "curPlayInfo", string6, string2);
                    }
                    return true;
                }
            }
            catch (Exception exception) {
                CLog.w(TAG, exception);
            }
        }
        return false;
    }

    private String buildPlayContent(String string, ParamsMap paramsMap) {
        String string2;
        String string3 = paramsMap.getStringParam("mediatype");
        String string4 = paramsMap.getStringParam("mediaAssetName");
        String string5 = paramsMap.getStringParam("category");
        String string6 = paramsMap.getStringParam("playid");
        if (string3.equals("101") || string3.equals("102")) {
            String string7 = "items";
            string3 = string3.equals("101") ? "music" : "video";
            string2 = new PlistBuilder().addStringToRoot("media-type", string3).createIPlistArray(string7, 1).addIntagerToArray(string7, 0, "start-position", this.mStartPosition).addStringToArray(string7, 0, "uuid", this.mPushUri).addStringToArray(string7, 0, "content-location", string).addStringToArray(string7, 0, "name", string4).addStringToArray(string7, 0, "category", string5).addStringToArray(string7, 0, "playid", string6).addArrayToRoot(string7).getPotocol();
        } else {
            String string8 = "items";
            string3 = "image/url";
            string2 = new PlistBuilder().addStringToRoot("media-type", string3).createIPlistArray(string8, 1).addStringToArray(string8, 0, "uuid", this.mPushUri).addStringToArray(string8, 0, "content-location", string).addArrayToRoot(string8).getPotocol();
        }
        this.currentMediaType = string3;
        return string2;
    }

    private String buildActionContent(ParamsMap paramsMap, int n2) {
        String string;
        PlistBuilder plistBuilder = new PlistBuilder();
        String string2 = "";
        if (n2 == 1) {
            string2 = "set-playlist";
        } else if (n2 == 2) {
            string2 = "append-playlist";
        } else if (n2 == 3) {
            string2 = "clear-playlist";
        } else if (n2 == 4) {
            string2 = "play_prev";
        } else if (n2 == 5) {
            string2 = "play_next";
        } else if (n2 == 6) {
            string2 = "play_assign";
        }
        plistBuilder.addStringToRoot("prop-type", string2);
        String string3 = "";
        if (paramsMap != null) {
            string3 = paramsMap.getStringParam("category");
        }
        if (n2 == 2 || n2 == 1) {
            plistBuilder.addStringToRoot("curplayid", paramsMap.getStringParam("curplayid")).addIntagerToRoot("period", paramsMap.getIntParam("period")).addStringToRoot("category", string3).addIntagerToRoot("headduration", paramsMap.getIntParam("headduration")).addIntagerToRoot("tailduration", paramsMap.getIntParam("tailduration")).addStringToRoot("uuid", this.mPushUri);
            string = paramsMap.getStringParam("mediatype");
            this.currentMediaType = string.equals("101") ? "music" : "video";
            JSONObject jSONObject = (JSONObject)paramsMap.get("playlist");
            try {
                JSONArray jSONArray = jSONObject.getJSONArray("playlist");
                plistBuilder.createIPlistArray("playlist", jSONArray.length());
                for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                    JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                    String string4 = jSONObject2.optString("name");
                    plistBuilder.addStringToArray("playlist", i2, "name", string4);
                    JSONArray jSONArray2 = jSONObject2.getJSONArray("urls");
                    plistBuilder.createIPlistArray("urls", jSONArray2.length());
                    for (int i3 = 0; i3 < jSONArray2.length(); ++i3) {
                        JSONObject jSONObject3 = jSONArray2.getJSONObject(i3);
                        int n3 = jSONObject3.optInt("width");
                        int n4 = jSONObject3.optInt("height");
                        String string5 = jSONObject3.optString("url");
                        String string6 = jSONObject3.optString("playid");
                        String string7 = jSONObject3.optString("category");
                        plistBuilder.addIntagerToArray("urls", i3, "width", n3);
                        plistBuilder.addIntagerToArray("urls", i3, "height", n4);
                        plistBuilder.addStringToArray("urls", i3, "url", string5);
                        plistBuilder.addStringToArray("urls", i3, "id", string6);
                        plistBuilder.addStringToArray("urls", i3, "category", string7);
                    }
                    plistBuilder.addArrayToArray("playlist", i2, "urls");
                }
                plistBuilder.addArrayToRoot("playlist");
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        } else if (n2 == 6) {
            string = paramsMap.getStringParam("mediaAssetName");
            String string8 = paramsMap.getStringParam("curplayid");
            String string9 = paramsMap.getStringParam("url");
            int n5 = 0;
            int n6 = 0;
            try {
                n5 = (Integer)paramsMap.get("width");
                n6 = (Integer)paramsMap.get("height");
            }
            catch (Exception exception) {
                CLog.w(TAG, exception);
            }
            plistBuilder.addStringToRoot("name", string);
            plistBuilder.addStringToRoot("curplayid", string8);
            plistBuilder.addStringToRoot("url", string9);
            plistBuilder.addIntagerToRoot("width", n5);
            plistBuilder.addIntagerToRoot("height", n6);
        }
        string = plistBuilder.getPotocol();
        CLog.i(TAG, " content : " + string);
        return string;
    }
}

