/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.push;

import android.text.TextUtils;
import com.hpplay.component.common.ParamsMap;
import com.hpplay.component.common.protocol.ProtocolListener;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.component.protocol.push.LelinkV2PushHandler;
import com.hpplay.component.protocol.push.PushControllerImpl;
import org.json.JSONObject;

public abstract class IPushHandler {
    private static final String TAG = "IPushHandler";
    public static final String SUPPORT_HAISENSE_VERSION_NUM = "5.3.2.9";
    public static final String SUPPORT_DANGBEI_APP_VERSION_NUM1 = "5.0.1.6";
    public static final String SUPPORT_DANGBEI_APP_VERSION_NUM2 = "5.2.1.1";
    public static final String DURATION = "duration";
    public static final String POSITION = "position";
    public static final String KEY_UUID = "uuid";
    public static final String KEY_URL = "url";
    public static final String KEY_URL_ID = "urlID";
    public static final String READY_PLAY = "readyToPlay";
    public static final String PLAYING = "playing";
    public static final String STOPPED = "stopped";
    public static final String LOADING = "loading";
    public static final String PAUSED = "paused";
    public static final String ERROR = "error";
    public static final String ENDED = "ended";
    public static final String SP = "Switching Protocols";
    public static final String STOP_TYPE = "stoptype";
    public static final String STATE = "state";
    public static final String REASON = "reason";
    public static final String PHOTO_HIDE = "photohide";
    public static final String EPISODE_STOPED = "episode_stopped";
    public static final String PREEMPT_STOPPED = "preempt_stopped";
    public static final String MEDIA_COMPLETION = "media_completion";
    public static final String PHONE_VIDEO_HIDE = "phonevideohide";
    public boolean isPlaying;
    public String mPushUri;
    public String mImei;
    public String mAppid;
    public String mUid;
    public String mHid;
    public String mSessionId;
    public String mConnectSessionId;
    public String mUserAgent = "MediaControl/1.0";
    public String mMac;
    public String mediaAssetName;
    public String dlnaDuration;
    public String dlnaResolution;
    public String dlnaAlbum;
    public String dlnaAlbumUrl;
    public String dlnaArtist;
    public String dlnaCreator;
    public String dlnaID;
    public long dlnaSize;
    public String mRealm;
    public String mNonce;
    public String mMethod;
    public String mUri;
    public int mStartPosition = 0;

    public IPushHandler(ParamsMap paramsMap) {
        this.mPushUri = paramsMap.getStringParam("uri");
        this.mImei = paramsMap.getStringParam("imei");
        this.mAppid = paramsMap.getStringParam("appid");
        this.dlnaDuration = paramsMap.getStringParam("dlna_duration");
        try {
            this.dlnaSize = Long.parseLong(paramsMap.getParam("dlna_size", 0).toString());
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
        if (paramsMap.containsKey("start_postion")) {
            this.mStartPosition = Integer.parseInt(paramsMap.get("start_postion").toString());
        }
        this.dlnaResolution = paramsMap.getStringParam("dlna_resolution");
        this.mUid = paramsMap.getStringParam("uid");
        this.mHid = paramsMap.getStringParam("hid");
        this.mSessionId = paramsMap.getStringParam("sessionId");
        this.mConnectSessionId = paramsMap.getStringParam("connectSessionId");
        this.mMac = paramsMap.getStringParam("mac");
        this.mediaAssetName = paramsMap.getStringParam("mediaAssetName");
        this.dlnaAlbum = paramsMap.getStringParam("dlna_album");
        this.dlnaAlbumUrl = paramsMap.getStringParam("dlna_album_url");
        this.dlnaArtist = paramsMap.getStringParam("dlna_artist");
        this.dlnaCreator = paramsMap.getStringParam("dlna_creator");
        this.dlnaID = paramsMap.getStringParam("playid");
        String string = paramsMap.getStringParam("channel_version");
        if (!TextUtils.isEmpty((CharSequence)string) && (string.contains(SUPPORT_DANGBEI_APP_VERSION_NUM1) || string.contains(SUPPORT_DANGBEI_APP_VERSION_NUM2))) {
            this.mUserAgent = "HappyCast3,1";
        }
    }

    abstract String buildPush(String var1, ParamsMap var2);

    abstract String buildGetPlayInfo();

    abstract String buildGetStateInfo();

    abstract String buildPause();

    abstract String buildResume();

    abstract String buildSeekTo(int var1);

    abstract String buildIncreaseVolume();

    abstract String buildDecreaseVolume();

    abstract String buildStopPlay();

    abstract String setVolume(int var1);

    public String buildSelectPlay(ParamsMap paramsMap) {
        return null;
    }

    public String buildSetPlayList(ParamsMap paramsMap) {
        return null;
    }

    public String buildAddPlayList(ParamsMap paramsMap) {
        return null;
    }

    public String buildPlayNext() {
        return null;
    }

    public String buildPlayPre() {
        return null;
    }

    public String buildClearList() {
        return null;
    }

    public String buildAudiotrack(int n2) {
        return null;
    }

    public void parseReversePlist(PushControllerImpl pushControllerImpl, String ... stringArray) {
    }

    public ProtocolListener getProtocolListener(int n2, ProtocolListener protocolListener) {
        return new ProtocolResultParser(n2, protocolListener);
    }

    public String getReverseData() {
        return null;
    }

    public boolean parsePlayBackInfo(int n2, String string, ProtocolListener protocolListener) {
        return false;
    }

    class ProtocolResultParser
    extends ProtocolListener {
        private final ProtocolListener listener;

        public ProtocolResultParser(int n2, ProtocolListener protocolListener) {
            this.listener = protocolListener;
            this.cmdType = n2;
        }

        @Override
        public void onResult(int n2, String ... stringArray) {
            try {
                CLog.d(IPushHandler.TAG, " result  :  " + stringArray[0]);
                this.convertAndCallback(n2, this.listener, stringArray);
            }
            catch (Exception exception) {
                CLog.w(IPushHandler.TAG, exception);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void convertAndCallback(int n2, ProtocolListener protocolListener, String ... stringArray) {
            if (stringArray != null && stringArray.length > 0) {
                switch (n2) {
                    case 1: {
                        if (stringArray[0].contains("401") && this.screenCodeCallback(n2, protocolListener, stringArray[0])) return;
                        if (stringArray[0].contains("200") || stringArray[0].contains("successful")) {
                            JSONObject jSONObject = new JSONObject();
                            this.addReportInfo(jSONObject);
                            protocolListener.onResult(n2, "successful", jSONObject.toString());
                            return;
                        }
                        if ("failed".equals(stringArray[0])) {
                            JSONObject jSONObject = new JSONObject(stringArray[1]);
                            this.addReportInfo(jSONObject);
                            stringArray[1] = jSONObject.toString();
                            protocolListener.onResult(n2, stringArray);
                            CLog.i(IPushHandler.TAG, "======RESULT_FAILED============>>> " + jSONObject.toString().replace(".", ""));
                            return;
                        }
                        if (IPushHandler.this instanceof LelinkV2PushHandler) {
                            JSONObject jSONObject = new JSONObject();
                            this.addReportInfo(jSONObject);
                            protocolListener.onResult(n2, "successful", jSONObject.toString());
                            return;
                        }
                        protocolListener.onResult(n2, stringArray);
                        return;
                    }
                    case 9: {
                        protocolListener.onResult(n2, stringArray);
                        return;
                    }
                    case 8: {
                        if (IPushHandler.this.parsePlayBackInfo(n2, stringArray[0], protocolListener)) return;
                        protocolListener.onResult(n2, stringArray);
                        return;
                    }
                    default: {
                        if (stringArray[0].contains("200") || stringArray[0].contains("successful")) {
                            if (protocolListener == null) return;
                            protocolListener.onResult(n2, "successful");
                            return;
                        }
                        protocolListener.onResult(n2, "failed");
                        return;
                    }
                }
            } else {
                protocolListener.onResult(n2, "failed");
            }
        }

        private boolean screenCodeCallback(int n2, ProtocolListener protocolListener, String string) {
            String string2;
            String[] stringArray = string.split("\r\n");
            if (stringArray != null && stringArray.length > 0 && !TextUtils.isEmpty((CharSequence)(string2 = stringArray[stringArray.length - 1]))) {
                int n3 = string2.indexOf("=");
                int n4 = string2.indexOf(",");
                String string3 = string2.substring(n3 + 1, n4 - 1).replace("\"", "");
                String string4 = string2.substring(n4 + 1);
                n3 = string4.indexOf("=");
                String string5 = string4.substring(n3 + 1).replace("\"", "");
                IPushHandler.this.mRealm = string3;
                IPushHandler.this.mNonce = string5;
                IPushHandler.this.mMethod = "POST";
                IPushHandler.this.mUri = "/play";
                CLog.d(IPushHandler.TAG, "author  :  " + string2);
                if (protocolListener != null) {
                    protocolListener.onResult(n2, "screencode");
                    return true;
                }
            }
            return false;
        }

        private void addReportInfo(JSONObject jSONObject) {
            jSONObject.put("uri", (Object)IPushHandler.this.mPushUri);
            jSONObject.put("sessionId", (Object)IPushHandler.this.mSessionId);
            jSONObject.put("connectSessionId", (Object)IPushHandler.this.mConnectSessionId);
        }
    }
}

