/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.plist;

import com.hpplay.component.protocol.plist.Base64;
import com.hpplay.component.protocol.plist.BinaryPropertyListWriter;
import com.hpplay.component.protocol.plist.NSObject;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class NSData
extends NSObject {
    private final byte[] bytes;

    public NSData(byte[] byArray) {
        this.bytes = byArray;
    }

    public NSData(String string) {
        String string2 = string.replaceAll("\\s+", "");
        this.bytes = Base64.decode(string2, 4);
    }

    public NSData(File file) {
        this.bytes = new byte[(int)file.length()];
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        randomAccessFile.read(this.bytes);
        randomAccessFile.close();
    }

    public byte[] bytes() {
        return this.bytes;
    }

    public int length() {
        return this.bytes.length;
    }

    public void getBytes(ByteBuffer byteBuffer, int n2) {
        byteBuffer.put(this.bytes, 0, Math.min(this.bytes.length, n2));
    }

    public void getBytes(ByteBuffer byteBuffer, int n2, int n3) {
        byteBuffer.put(this.bytes, n2, Math.min(this.bytes.length, n3));
    }

    public String getBase64EncodedData() {
        return Base64.encodeBytes(this.bytes);
    }

    public boolean equals(Object object) {
        return object.getClass().equals(this.getClass()) && Arrays.equals(((NSData)object).bytes, this.bytes);
    }

    public int hashCode() {
        int n2 = 5;
        n2 = 67 * n2 + Arrays.hashCode(this.bytes);
        return n2;
    }

    @Override
    public NSData clone() {
        return new NSData((byte[])this.bytes.clone());
    }

    @Override
    void toXML(StringBuilder stringBuilder, int n2) {
        this.indent(stringBuilder, n2);
        stringBuilder.append("<data>");
        stringBuilder.append(NEWLINE);
        String string = this.getBase64EncodedData();
        for (String string2 : string.split("\n")) {
            this.indent(stringBuilder, n2 + 1);
            stringBuilder.append(string2);
            stringBuilder.append(NEWLINE);
        }
        this.indent(stringBuilder, n2);
        stringBuilder.append("</data>");
    }

    @Override
    void toBinary(BinaryPropertyListWriter binaryPropertyListWriter) {
        binaryPropertyListWriter.writeIntHeader(4, this.bytes.length);
        binaryPropertyListWriter.write(this.bytes);
    }

    @Override
    protected void toASCII(StringBuilder stringBuilder, int n2) {
        this.indent(stringBuilder, n2);
        stringBuilder.append('<');
        int n3 = stringBuilder.lastIndexOf(NEWLINE);
        for (int i2 = 0; i2 < this.bytes.length; ++i2) {
            int n4 = this.bytes[i2] & 0xFF;
            if (n4 < 16) {
                stringBuilder.append('0');
            }
            stringBuilder.append(Integer.toHexString(n4));
            if (stringBuilder.length() - n3 > 80) {
                stringBuilder.append(NEWLINE);
                n3 = stringBuilder.length();
                continue;
            }
            if ((i2 + 1) % 2 != 0 || i2 == this.bytes.length - 1) continue;
            stringBuilder.append(' ');
        }
        stringBuilder.append('>');
    }

    @Override
    protected void toASCIIGnuStep(StringBuilder stringBuilder, int n2) {
        this.toASCII(stringBuilder, n2);
    }
}

