/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.mirror;

import com.hpplay.component.common.ParamsMap;
import com.hpplay.component.common.protocol.IMirrorController;
import com.hpplay.component.common.protocol.IMirrorStateListener;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.component.protocol.mirror.MirrorEventReceiver;
import com.hpplay.component.protocol.mirror.MirrorProtocolTask;
import java.nio.ByteBuffer;

public class MirrorControllerImp
extends IMirrorController {
    private static final String TAG = "MirrorControllerImp";
    private MirrorProtocolTask mMirrorProtocolTask;
    private MirrorEventReceiver mMirrorEventReceiver;
    private IMirrorStateListener mListener;
    MirrorEventReceiver.MirrorServStartListener mirrorEventReceiver = new MirrorEventReceiver.MirrorServStartListener(){

        @Override
        public void onStart(MirrorEventReceiver mirrorEventReceiver) {
            if (MirrorControllerImp.this.mMirrorProtocolTask != null) {
                MirrorControllerImp.this.mMirrorProtocolTask.setRtspListener(mirrorEventReceiver.genMirrorStateListener());
                MirrorControllerImp.this.mMirrorProtocolTask.setMirrorEventPort(mirrorEventReceiver.getMirrorEventPort());
                MirrorControllerImp.this.mMirrorProtocolTask.start();
            }
        }
    };

    @Override
    public void setMirrorProtocolInfos(ParamsMap paramsMap) {
        if (this.mMirrorProtocolTask != null) {
            this.mMirrorProtocolTask.stopMirror();
        }
        this.mMirrorProtocolTask = new MirrorProtocolTask(paramsMap);
    }

    @Override
    public void startGetSinkInfos(IMirrorStateListener iMirrorStateListener) {
        this.mListener = iMirrorStateListener;
        if (this.mMirrorEventReceiver != null) {
            this.stopMirrorEventServ();
        }
        CLog.i(TAG, "  startGetSinkInfos  ");
        if (this.mMirrorEventReceiver == null) {
            this.mMirrorEventReceiver = new MirrorEventReceiver(this.mListener, false);
            this.mMirrorEventReceiver.setMirrorServStartListener(this.mirrorEventReceiver);
            this.mMirrorEventReceiver.startServer();
        }
    }

    @Override
    public void setAutoBitrate(boolean bl) {
        if (this.mMirrorProtocolTask != null) {
            this.mMirrorProtocolTask.setAutoBitrate(bl);
        }
    }

    @Override
    public void sendVideoData(ByteBuffer byteBuffer, int n2, long l2) {
        if (this.mMirrorProtocolTask != null) {
            this.mMirrorProtocolTask.sendVideoData(byteBuffer, n2, l2);
        }
    }

    @Override
    public void sendAudioData(byte[] byArray, int n2, int n3) {
        if (this.mMirrorProtocolTask != null) {
            this.mMirrorProtocolTask.sendAudioData(byArray, n2, n3);
        }
    }

    @Override
    public void setMirrorMode(String string) {
        if (this.mMirrorProtocolTask != null) {
            this.mMirrorProtocolTask.setMirrorMode(string);
        }
    }

    @Override
    public void switchWLANChannel(int n2) {
        if (this.mMirrorProtocolTask != null) {
            this.mMirrorProtocolTask.switchWLANChannel(n2);
        }
    }

    @Override
    public void setSendDataTimeout(int n2) {
        if (this.mMirrorProtocolTask != null) {
            this.mMirrorProtocolTask.setSendDataTimeout(n2);
        }
    }

    @Override
    public void stopMirror() {
        try {
            if (this.mMirrorProtocolTask != null) {
                this.mMirrorProtocolTask.stopMirror();
                this.mMirrorProtocolTask = null;
            }
            this.stopMirrorEventServ();
            this.mListener = null;
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
    }

    private void stopMirrorEventServ() {
        if (this.mMirrorEventReceiver != null) {
            this.mMirrorEventReceiver.setMirrorServStartListener(null);
            this.mMirrorEventReceiver.stopServer();
            this.mMirrorEventReceiver = null;
        }
    }
}

