/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.encrypt;

import com.hpplay.component.common.utils.CLog;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;

public class TlvBox {
    private static final ByteOrder DEFAULT_BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private HashMap<Integer, byte[]> mObjects = new HashMap();
    private int mTotalBytes = 0;
    private static int MAX_SIZE = 0x200000;

    public static TlvBox parse(byte[] byArray, int n2, int n3, int n4) {
        int n5;
        TlvBox tlvBox = new TlvBox();
        for (int i2 = 0; i2 < n3; i2 += n5) {
            CLog.d("tlvp", "src  len --> " + n3 + "  parsed : " + i2 + "  tag " + n4);
            int n6 = ByteBuffer.wrap(byArray, n2 + i2, 4).order(DEFAULT_BYTE_ORDER).getInt();
            n5 = ByteBuffer.wrap(byArray, n2 + (i2 += 4), 4).order(DEFAULT_BYTE_ORDER).getInt();
            i2 += 4;
            if (n5 > MAX_SIZE) {
                CLog.d("tlvp", "dst size  --> " + n5 + "  parsed : " + i2 + " type  : " + n6 + "  tag " + n4);
                return tlvBox;
            }
            byte[] byArray2 = new byte[n5];
            System.arraycopy(byArray, n2 + i2, byArray2, 0, n5);
            tlvBox.putBytesValue(n6, byArray2);
        }
        return tlvBox;
    }

    public byte[] serialize() {
        int n2 = 0;
        byte[] byArray = new byte[this.mTotalBytes];
        Set<Integer> set = this.mObjects.keySet();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(set);
        Collections.reverse(arrayList);
        for (Integer n3 : arrayList) {
            byte[] byArray2 = this.mObjects.get(n3);
            byte[] byArray3 = ByteBuffer.allocate(4).order(DEFAULT_BYTE_ORDER).putInt(n3).array();
            byte[] byArray4 = ByteBuffer.allocate(4).order(DEFAULT_BYTE_ORDER).putInt(byArray2.length).array();
            System.arraycopy(byArray3, 0, byArray, n2, byArray3.length);
            System.arraycopy(byArray4, 0, byArray, n2 += 4, byArray4.length);
            System.arraycopy(byArray2, 0, byArray, n2 += 4, byArray2.length);
            n2 += byArray2.length;
        }
        return byArray;
    }

    public void putByteValue(int n2, byte by) {
        byte[] byArray = new byte[]{by};
        this.putBytesValue(n2, byArray);
    }

    public void putShortValue(int n2, short s2) {
        byte[] byArray = ByteBuffer.allocate(2).order(DEFAULT_BYTE_ORDER).putShort(s2).array();
        this.putBytesValue(n2, byArray);
    }

    public void putIntValue(int n2, int n3) {
        byte[] byArray = ByteBuffer.allocate(4).order(DEFAULT_BYTE_ORDER).putInt(n3).array();
        this.putBytesValue(n2, byArray);
    }

    public void putLongValue(int n2, long l2) {
        byte[] byArray = ByteBuffer.allocate(8).order(DEFAULT_BYTE_ORDER).putLong(l2).array();
        this.putBytesValue(n2, byArray);
    }

    public void putFloatValue(int n2, float f2) {
        byte[] byArray = ByteBuffer.allocate(4).order(DEFAULT_BYTE_ORDER).putFloat(f2).array();
        this.putBytesValue(n2, byArray);
    }

    public void putDoubleValue(int n2, double d2) {
        byte[] byArray = ByteBuffer.allocate(8).order(DEFAULT_BYTE_ORDER).putDouble(d2).array();
        this.putBytesValue(n2, byArray);
    }

    public void putStringValue(int n2, String string) {
        this.putBytesValue(n2, string.getBytes());
    }

    public void putObjectValue(int n2, TlvBox tlvBox) {
        this.putBytesValue(n2, tlvBox.serialize());
    }

    public void putBytesValue(int n2, byte[] byArray) {
        this.mObjects.put(n2, byArray);
        this.mTotalBytes += byArray.length + 8;
    }

    public Byte getByteValue(int n2) {
        byte[] byArray = this.mObjects.get(n2);
        if (byArray == null) {
            return null;
        }
        return byArray[0];
    }

    public Short getShortValue(int n2) {
        byte[] byArray = this.mObjects.get(n2);
        if (byArray == null) {
            return null;
        }
        return ByteBuffer.wrap(byArray).order(DEFAULT_BYTE_ORDER).getShort();
    }

    public Integer getIntValue(int n2) {
        byte[] byArray = this.mObjects.get(n2);
        if (byArray == null) {
            return null;
        }
        return ByteBuffer.wrap(byArray).order(DEFAULT_BYTE_ORDER).getInt();
    }

    public Long getLongValue(int n2) {
        byte[] byArray = this.mObjects.get(n2);
        if (byArray == null) {
            return null;
        }
        return ByteBuffer.wrap(byArray).order(DEFAULT_BYTE_ORDER).getLong();
    }

    public Float getFloatValue(int n2) {
        byte[] byArray = this.mObjects.get(n2);
        if (byArray == null) {
            return null;
        }
        return Float.valueOf(ByteBuffer.wrap(byArray).order(DEFAULT_BYTE_ORDER).getFloat());
    }

    public Double getDoubleValue(int n2) {
        byte[] byArray = this.mObjects.get(n2);
        if (byArray == null) {
            return null;
        }
        return ByteBuffer.wrap(byArray).order(DEFAULT_BYTE_ORDER).getDouble();
    }

    public TlvBox getObjectValue(int n2) {
        byte[] byArray = this.mObjects.get(n2);
        if (byArray == null) {
            return null;
        }
        return TlvBox.parse(byArray, 0, byArray.length, 1);
    }

    public String getStringValue(int n2) {
        byte[] byArray = this.mObjects.get(n2);
        if (byArray == null) {
            return null;
        }
        return new String(byArray).trim();
    }

    public byte[] getBytesValue(int n2) {
        byte[] byArray = this.mObjects.get(n2);
        return byArray;
    }
}

