/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.connection;

import android.text.TextUtils;
import com.hpplay.component.common.ParamsMap;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.component.protocol.ProtocolSender;
import com.hpplay.component.protocol.ProtocolUtils;
import java.net.URL;

public abstract class IConnection {
    private static final String TAG = "IConnection";
    public static final String SUPPORT_LOW_RECEIVER_APK_VERSION_NUM = "5.0";
    public static final String SUPPORT_LOW_RECEIVER_APK_VERSION_NUM_1 = "3.";
    public static final String SUPPORT_NEW_LELINK_PROTOCOL_VERSION_NUM = "5.5";
    public static final int DEFAULT_TIME_OUT = 10000;
    public String mHid;
    public String mDeviceName;
    public ProtocolSender mProtocolSender;
    public String sessionId;
    public ParamsMap paramsMap;
    public String mIp;
    public int mTimeOut;
    public int mPort;

    public IConnection(ParamsMap paramsMap) {
        block2: {
            this.mPort = 0;
            this.paramsMap = paramsMap;
            this.mProtocolSender = new ProtocolSender();
            this.mIp = paramsMap.getIp();
            this.mTimeOut = paramsMap.getIntParam("connect_timeout");
            this.mTimeOut = this.mTimeOut == 0 ? 10000 : this.mTimeOut;
            CLog.i(TAG, Thread.currentThread() + "  ip == >  " + paramsMap.getIp().replace(".", "") + " port == > " + paramsMap.getPort());
            try {
                this.mPort = paramsMap.getPort();
            }
            catch (Exception exception) {
                String string = paramsMap.getStringParam("location_uri");
                if (TextUtils.isEmpty((CharSequence)string)) break block2;
                this.mPort = this.getPort(string);
                CLog.i(TAG, "parse uri port " + this.mPort);
            }
        }
        CLog.i(TAG, Thread.currentThread() + "  ip == >  " + paramsMap.getIp().replace(".", "") + " port == > " + this.mPort);
        this.mProtocolSender.setConnectInfo(this.mIp, this.mPort);
        this.sessionId = ProtocolUtils.createSessionId(paramsMap.getCuid());
    }

    private int getPort(String string) {
        try {
            URL uRL = new URL(string);
            int n2 = uRL.getPort();
            return n2;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    String getSessionId() {
        return this.sessionId;
    }

    abstract boolean startConnect();

    abstract boolean checkConnection();

    public ProtocolSender getProtocolSender() {
        return this.mProtocolSender;
    }

    void disConnect() {
        this.mProtocolSender.release();
    }
}

