/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.modulelinker;

import android.app.Application;
import android.util.Log;
import com.hpplay.component.modulelinker.patch.SystemHookUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ModuleLoadUtils {
    private static final String TAG = "ModuleLoadUtils";
    private static ClassLoader mExternalClassLoader;
    private static ClassLoader mPatchClassLoader;

    protected static void setExternalClassLoader(ClassLoader classLoader) {
        mExternalClassLoader = classLoader;
    }

    protected static ClassLoader getExternalClassLoader() {
        return mExternalClassLoader;
    }

    protected static void setPatchClassLoader(ClassLoader classLoader) {
        mPatchClassLoader = classLoader;
    }

    public static ClassLoader getPatchClassLoader() {
        return mPatchClassLoader;
    }

    public static Object exeMethod(String string, String string2, Object ... objectArray) {
        Method[] methodArray;
        Class clazz = ModuleLoadUtils.findClass(string);
        if (clazz == null) {
            return null;
        }
        for (Method method : methodArray = clazz.getDeclaredMethods()) {
            if (!method.getName().equals(string2) || method.getParameterTypes().length != objectArray.length) continue;
            Method method2 = method;
            method2.setAccessible(true);
            return method2.invoke((Object)clazz, objectArray);
        }
        return null;
    }

    public static Object exeMethod(Object object, String string, Object ... objectArray) {
        Method[] methodArray;
        Class<?> clazz = object.getClass();
        for (Method method : methodArray = clazz.getDeclaredMethods()) {
            if (!method.getName().equals(string) || method.getParameterTypes().length != objectArray.length) continue;
            Method method2 = method;
            method2.setAccessible(true);
            return method2.invoke(object, objectArray);
        }
        return null;
    }

    public static Object getField(Object object, String string) {
        Class<?> clazz = object.getClass();
        Field[] fieldArray = clazz.getDeclaredFields();
        if (fieldArray == null || fieldArray.length == 0) {
            fieldArray = clazz.getFields();
        }
        for (Field field : fieldArray) {
            if (!field.getName().equals(string)) continue;
            Field field2 = field;
            field2.setAccessible(true);
            return field2.get(object);
        }
        return null;
    }

    public static Object getField(Object object, Class<?> clazz, String string) {
        Field field = clazz.getDeclaredField(string);
        field.setAccessible(true);
        return field.get(object);
    }

    public static Object getStaticField(String string, String string2) {
        Class<?> clazz = Class.forName(string);
        Field field = clazz.getDeclaredField(string2);
        field.setAccessible(true);
        Object object = field.get(null);
        return object;
    }

    public static void setField(Object object, String string, Object object2) {
        Class<?> clazz = object.getClass();
        Field field = clazz.getDeclaredField(string);
        field.setAccessible(true);
        field.set(object, object2);
    }

    public static void setField(String string, String string2, Object object) {
        Class clazz = ModuleLoadUtils.findClass(string);
        Field field = clazz.getDeclaredField(string2);
        field.setAccessible(true);
        field.set(clazz, object);
    }

    public static Object getNewInstance(String string, Class<?>[] classArray, Object[] objectArray) {
        try {
            Class clazz = ModuleLoadUtils.findClass(string);
            if (clazz == null) {
                Log.i((String)TAG, (String)(string.substring(string.lastIndexOf("."), string.length()) + " not find ..."));
                return null;
            }
            Constructor constructor = clazz.getConstructor(classArray);
            Object t2 = constructor.newInstance(objectArray);
            return t2;
        }
        catch (Exception exception) {
            Log.w((String)TAG, (Throwable)exception);
            return null;
        }
    }

    public static Object getSingleInstance(String string, String string2, Class<?>[] classArray, Object[] objectArray) {
        try {
            Class clazz = ModuleLoadUtils.findClass(string);
            Method method = clazz.getDeclaredMethod(string2, classArray);
            Object object = method.invoke((Object)clazz, objectArray);
            return object;
        }
        catch (Exception exception) {
            Log.w((String)TAG, (Throwable)exception);
            return null;
        }
    }

    private static Class findClass(String string) {
        Class<?> clazz;
        block7: {
            try {
                clazz = Class.forName(string);
            }
            catch (Exception exception) {
                Log.i((String)TAG, (String)" main dex find class failed ");
                clazz = SystemHookUtils.findClassByBaseclassLoader(string);
                if (mExternalClassLoader != null && clazz == null) {
                    try {
                        clazz = mExternalClassLoader.loadClass(string);
                    }
                    catch (Exception exception2) {
                        Log.i((String)TAG, (String)" component find class failed");
                    }
                }
                if (mPatchClassLoader == null || clazz != null) break block7;
                try {
                    clazz = mPatchClassLoader.loadClass(string);
                }
                catch (Exception exception3) {
                    Log.i((String)TAG, (String)" component find class failed");
                }
            }
        }
        return clazz;
    }

    public static void releaseCache(Object object) {
        if (object != null) {
            Field[] fieldArray;
            Class<?> clazz = object.getClass();
            Log.i((String)TAG, (String)clazz.getSimpleName());
            for (Field field : fieldArray = clazz.getDeclaredFields()) {
                if (!field.getType().toString().startsWith("class")) continue;
                field.setAccessible(true);
                field.set(object, null);
            }
        }
    }

    public static Application getApplication() {
        Application application = null;
        try {
            Class<?> clazz = Class.forName("android.app.ActivityThread");
            Method method = clazz.getMethod("currentActivityThread", new Class[0]);
            Object object = method.invoke(null, (Object[])null);
            Method method2 = clazz.getMethod("getApplication", new Class[0]);
            application = (Application)method2.invoke(object, (Object[])null);
        }
        catch (Exception exception) {
            Log.w((String)TAG, (Throwable)exception);
        }
        return application;
    }
}

