/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.dlna;

import android.text.TextUtils;
import android.util.Base64;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.cybergarage.upnp.Action;
import com.hpplay.cybergarage.upnp.ActionList;
import com.hpplay.cybergarage.upnp.Device;
import com.hpplay.cybergarage.upnp.Service;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.json.JSONObject;

public class DLNASender {
    private static final String TAG = "DLNASender";
    public static String AV_TRANSPORT_1 = "urn:schemas-upnp-org:service:AVTransport:1";
    public static String RENDERING_CONTROL = "urn:schemas-upnp-org:service:RenderingControl:1";
    public static int DMR_SERVER_ERROR = 500;
    public static String GET_MEDIA_INFO = "GetMediaInfo";
    public static String GET_POSITION_INFO = "GetPositionInfo";
    public static String GET_TRANSPORT_INFO = "GetTransportInfo";
    public static String GET_VOLUME_DB_RANGE = "GetVolumeDBRange";
    public static String PAUSE = "Pause";
    public static String PLAY = "Play";
    public static String SEEK = "Seek";
    public static String SET_AV_TRANSPORT_URI = "SetAVTransportURI";
    public static String STOP = "Stop";
    public static String GET_MUTE = "GetMute";
    public static String SET_MUTE = "SetMute";
    public static String GET_VOLUME = "GetVolume";
    public static String SET_VOLUME = "SetVolume";
    private static final int DEFAULT_POSITION = -1;
    public static String HTTPS = "https";
    public static String HTTP = "http";
    public static String DMR_UNSUPPORTED_RESPONSE = "Resource not found";
    private static final String NOT_IMPLEMENTED = "NOT_IMPLEMENTED";
    public static final String DLNA_DURATION = "duration";
    public static final String DLNA_POSITION = "position";
    private String mCUid;
    private Device mDevice;
    private SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss", Locale.CHINA);
    private boolean isRetryHttp = false;
    private String mDesc;
    private String mLocation;
    public int mErrorCode;
    public String mErrorMsg = "unknow";
    private int mStartPosition = 0;
    private final Action.ResponseCallbackLisener responseCallbackLisener = new Action.ResponseCallbackLisener(){

        @Override
        public void onCallback(String string, String string2) {
            try {
                CLog.i(DLNASender.TAG, "  send play order ===> " + new String(Base64.encode((byte[])string.getBytes(), (int)0)) + " \r\n response === :" + string2);
            }
            catch (Exception exception) {
                CLog.w(DLNASender.TAG, exception);
            }
        }
    };
    public static final String PLAYING = "playing";
    public static final String STOPPED = "stopped";
    public static final String LOADING = "loading";
    public static final String PAUSED = "paused";

    public DLNASender(Device device, String string) {
        this.mCUid = string;
        this.mDevice = device;
    }

    public boolean play(String string, String string2) {
        boolean bl = this.sendPlayOrder(string, string2);
        if (!bl && string.startsWith(HTTPS) && this.isRetryHttp) {
            string = string.replace(HTTPS, HTTP);
            string2 = string.replace(HTTPS, HTTP);
            bl = this.sendPlayOrder(string, string2);
        }
        return bl;
    }

    public void retryHttpSwitch(boolean bl) {
        this.isRetryHttp = bl;
    }

    private boolean sendPlayOrder(String string, String string2) {
        try {
            this.mDesc = this.mDevice.getDesc();
            this.mLocation = this.mDevice.getLocation();
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
        Service service = this.mDevice.getService(AV_TRANSPORT_1);
        if (service == null) {
            this.mErrorCode = 120103103;
            return false;
        }
        Action action = service.getAction(SET_AV_TRANSPORT_URI);
        if (action == null) {
            this.mErrorMsg = service.getErrorMsg();
            this.mErrorCode = 120103104;
            return false;
        }
        Action action2 = service.getAction(PLAY);
        if (action2 == null) {
            this.mErrorMsg = service.getErrorMsg();
            this.mErrorCode = 120103107;
            return false;
        }
        action.setArgumentValue("InstanceID", 0);
        action.setArgumentValue("CurrentURI", string);
        action.setArgumentValue("CurrentURIMetaData", string2);
        action.setResponseCallbackLisener(this.responseCallbackLisener);
        String string3 = "";
        for (int i2 = 0; i2 < 5; ++i2) {
            string3 = action.postPlayAction(this.mCUid);
            if (action.isSuccessful) break;
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        if (!action.isSuccessful) {
            this.mErrorMsg = string3;
            try {
                if (string3.contains(DMR_UNSUPPORTED_RESPONSE) || string3.toLowerCase().contains(DMR_UNSUPPORTED_RESPONSE.toLowerCase())) {
                    this.mErrorCode = 120103108;
                    return false;
                }
            }
            catch (Exception exception) {
                CLog.w(TAG, exception);
            }
            this.mErrorCode = 120103105;
            return false;
        }
        action2.setArgumentValue("InstanceID", 0);
        action2.setArgumentValue("Speed", "1");
        action2.setResponseCallbackLisener(this.responseCallbackLisener);
        string3 = action2.postPlayAction(this.mCUid);
        CLog.i(TAG, "PLAY =========>> " + string3);
        if (!action.isSuccessful) {
            this.mErrorMsg = string3;
            this.mErrorCode = 120103106;
        }
        return true;
    }

    public boolean resume() {
        Service service = this.mDevice.getService(AV_TRANSPORT_1);
        if (service == null) {
            return false;
        }
        ActionList actionList = service.getActionList();
        CLog.i(TAG, "actionList-->" + actionList.toString());
        Action action = service.getAction(PLAY);
        if (action == null) {
            return false;
        }
        action.setArgumentValue("InstanceID", 0);
        action.setArgumentValue("Speed", "1");
        return action.postControlAction(this.mCUid);
    }

    public String getTransportState() {
        Service service = this.mDevice.getService(AV_TRANSPORT_1);
        if (service == null) {
            return null;
        }
        Action action = service.getAction(GET_TRANSPORT_INFO);
        if (action == null) {
            return null;
        }
        action.setArgumentValue("InstanceID", "0");
        if (action.postControlAction(this.mCUid)) {
            String string = action.getArgumentValue("CurrentTransportState");
            CLog.i(TAG, "play state " + string);
            if (!TextUtils.isEmpty((CharSequence)string)) {
                if ((string = string.toLowerCase()).toLowerCase().contains(PAUSED)) {
                    string = PAUSED;
                } else if (string.toLowerCase().contains(PLAYING)) {
                    string = PLAYING;
                } else if (string.toLowerCase().contains(STOPPED)) {
                    string = STOPPED;
                }
            }
            return string;
        }
        return null;
    }

    public String getVolumeDbRange(String string) {
        Service service = this.mDevice.getService(RENDERING_CONTROL);
        if (service == null) {
            return null;
        }
        Action action = service.getAction(GET_VOLUME_DB_RANGE);
        if (action == null) {
            return null;
        }
        action.setArgumentValue("InstanceID", "0");
        action.setArgumentValue("Channel", "Master");
        if (!action.postControlAction(this.mCUid)) {
            return null;
        }
        return action.getArgumentValue(string);
    }

    public int getMinVolumeValue() {
        String string = this.getVolumeDbRange("MinValue");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    public int getMaxVolumeValue() {
        String string = this.getVolumeDbRange("MaxValue");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return 100;
        }
        return Integer.parseInt(string);
    }

    public boolean seek(String string) {
        Service service = this.mDevice.getService(AV_TRANSPORT_1);
        if (service == null) {
            return false;
        }
        string = this.millisToFormat(Long.valueOf(string));
        Action action = service.getAction(SEEK);
        if (action == null) {
            return false;
        }
        action.setArgumentValue("InstanceID", "0");
        action.setArgumentValue("Unit", "REL_TIME");
        action.setArgumentValue("Target", string);
        boolean bl = action.postControlAction(this.mCUid);
        if (!bl) {
            action.setArgumentValue("Unit", "ABS_TIME");
            action.setArgumentValue("Target", string);
            return action.postControlAction(this.mCUid);
        }
        return bl;
    }

    public void setStartPosition(int n2) {
        this.mStartPosition = n2;
    }

    public String getPositionInfo() {
        Service service = this.mDevice.getService(AV_TRANSPORT_1);
        CLog.i(TAG, " start get positionInfo " + (service == null));
        if (service == null) {
            return null;
        }
        Action action = service.getAction(GET_POSITION_INFO);
        CLog.i(TAG, "action is null " + (action == null));
        if (action == null) {
            return null;
        }
        action.setArgumentValue("InstanceID", "0");
        boolean bl = action.postControlAction(this.mCUid);
        CLog.i(TAG, "uis get successful " + bl);
        if (bl) {
            long l2;
            long l3 = -1L;
            String string = action.getArgumentValue("AbsTime");
            String string2 = action.getArgumentValue("RelTime");
            String string3 = action.getArgumentValue("TrackURI");
            String string4 = action.getArgumentValue("TrackDuration");
            CLog.i(TAG, " position is  " + string + " relTime " + string2);
            if (TextUtils.isEmpty((CharSequence)string) || TextUtils.equals((CharSequence)string, (CharSequence)NOT_IMPLEMENTED)) {
                l3 = this.formatToMillis(string2);
                CLog.i(TAG, "use reltime " + l3);
            } else if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.equals((CharSequence)string2, (CharSequence)NOT_IMPLEMENTED)) {
                l2 = this.formatToMillis(string2);
                long l4 = this.formatToMillis(string);
                l3 = l4 > 0L && !TextUtils.equals((CharSequence)string, (CharSequence)string4) ? l4 : (l2 > 0L ? l2 : 0L);
            } else {
                l3 = this.formatToMillis(string);
            }
            CLog.i(TAG, "dlna call back time : position :   " + l3 + " TrackDuration:  " + string4);
            l2 = this.formatToMillis(string4);
            JSONObject jSONObject = new JSONObject();
            try {
                if (l2 > -1L) {
                    l2 /= 1000L;
                }
                if (l3 > -1L) {
                    l3 /= 1000L;
                }
                if (l3 > 0L && this.mStartPosition > 0) {
                    this.seek(String.valueOf(this.mStartPosition * 1000));
                    this.mStartPosition = 0;
                }
                jSONObject.put(DLNA_POSITION, l3);
                jSONObject.put(DLNA_DURATION, l2);
                jSONObject.put("url", (Object)string3);
                return jSONObject.toString();
            }
            catch (Exception exception) {
                CLog.w(TAG, exception);
            }
        }
        return null;
    }

    public String getMediaDuration() {
        Service service = this.mDevice.getService(AV_TRANSPORT_1);
        if (service == null) {
            return null;
        }
        Action action = service.getAction(GET_MEDIA_INFO);
        if (action == null) {
            return null;
        }
        action.setArgumentValue("InstanceID", "0");
        if (action.postControlAction(this.mCUid)) {
            return action.getArgumentValue("MediaDuration");
        }
        return null;
    }

    public boolean setMute(String string) {
        Service service = this.mDevice.getService(RENDERING_CONTROL);
        if (service == null) {
            return false;
        }
        Action action = service.getAction(SET_MUTE);
        if (action == null) {
            return false;
        }
        action.setArgumentValue("InstanceID", "0");
        action.setArgumentValue("Channel", "Master");
        action.setArgumentValue("DesiredMute", string);
        return action.postControlAction(this.mCUid);
    }

    public String getMute() {
        Service service = this.mDevice.getService(RENDERING_CONTROL);
        if (service == null) {
            return null;
        }
        Action action = service.getAction(GET_MUTE);
        if (action == null) {
            return null;
        }
        action.setArgumentValue("InstanceID", "0");
        action.setArgumentValue("Channel", "Master");
        action.postControlAction(this.mCUid);
        return action.getArgumentValue("CurrentMute");
    }

    public boolean setVoice(int n2) {
        Service service = this.mDevice.getService(RENDERING_CONTROL);
        if (service == null) {
            return false;
        }
        Action action = service.getAction(SET_VOLUME);
        if (action == null) {
            return false;
        }
        action.setArgumentValue("InstanceID", "0");
        action.setArgumentValue("Channel", "Master");
        action.setArgumentValue("DesiredVolume", n2);
        return action.postControlAction(this.mCUid);
    }

    public int getVoice() {
        Service service = this.mDevice.getService(RENDERING_CONTROL);
        if (service == null) {
            return -1;
        }
        Action action = service.getAction(GET_VOLUME);
        if (action == null) {
            return -1;
        }
        action.setArgumentValue("InstanceID", "0");
        action.setArgumentValue("Channel", "Master");
        if (action.postControlAction(this.mCUid)) {
            return action.getArgumentIntegerValue("CurrentVolume");
        }
        return -1;
    }

    public boolean stop() {
        Service service = this.mDevice.getService(AV_TRANSPORT_1);
        if (service == null) {
            return false;
        }
        Action action = service.getAction(STOP);
        if (action == null) {
            return false;
        }
        action.setArgumentValue("InstanceID", 0);
        return action.postControlAction(this.mCUid);
    }

    public boolean pause() {
        Service service = this.mDevice.getService(AV_TRANSPORT_1);
        if (service == null) {
            return false;
        }
        Action action = service.getAction(PAUSE);
        if (action == null) {
            return false;
        }
        action.setArgumentValue("InstanceID", 0);
        return action.postControlAction(this.mCUid);
    }

    public long formatToMillis(String string) {
        CLog.d(TAG, "---formatToMillis --> " + string);
        if (TextUtils.isEmpty((CharSequence)string) || TextUtils.equals((CharSequence)string, (CharSequence)NOT_IMPLEMENTED)) {
            return -1L;
        }
        this.formatter.setTimeZone(TimeZone.getTimeZone("GMT+00:00"));
        Date date = null;
        try {
            date = this.formatter.parse(string);
            return date.getTime();
        }
        catch (ParseException parseException) {
            CLog.w(TAG, parseException);
            return -1L;
        }
    }

    public String millisToFormat(long l2) {
        CLog.d(TAG, "---Millis   To   Format --> " + l2);
        if (l2 <= 0L) {
            return "00:00:00";
        }
        this.formatter.setTimeZone(TimeZone.getTimeZone("GMT+00:00"));
        String string = this.formatter.format(l2);
        return string;
    }

    public String getErrMsg() {
        return this.mErrorMsg;
    }

    public int getErrCode() {
        return this.mErrorCode;
    }

    public String getDesc() {
        return this.mDesc;
    }

    public String getLocation() {
        return this.mLocation;
    }
}

