/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.common.utils;

import android.bluetooth.BluetoothAdapter;
import android.content.ContentResolver;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.provider.Settings;
import android.text.TextUtils;
import com.hpplay.common.log.LeLog;
import com.hpplay.common.utils.FieldUtil;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;

public class DeviceUtil {
    private static final String TAG = "DeviceUtil";
    private static String sOAID = "";
    private static String sAID = "";

    public static void setOAID(String string) {
        sOAID = string;
    }

    public static String getOAID(Context context) {
        return sOAID;
    }

    public static String getAID(Context context) {
        if (!TextUtils.isEmpty((CharSequence)sAID)) {
            return sAID;
        }
        try {
            sAID = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)FieldUtil.getString(FieldUtil.a));
            return sAID;
        }
        catch (Exception exception) {
            LeLog.w(TAG, "getAID Settings.Secure can not get aID");
        }
        catch (Error error) {
            LeLog.w(TAG, "getAID Settings.Secure can not get aID");
        }
        try {
            sAID = Settings.System.getString((ContentResolver)context.getContentResolver(), (String)FieldUtil.getString(FieldUtil.a));
            return sAID;
        }
        catch (Exception exception) {
            LeLog.w(TAG, "getAID Settings.System can not get aID");
        }
        catch (Error error) {
            LeLog.w(TAG, "getAID Settings.System can not get aID");
        }
        return "";
    }

    public static String getIPAddress(Context context) {
        String string = "";
        try {
            Object object;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null && networkInfo.isConnected()) {
                object = networkInfo.getTypeName();
                if (((String)object).equalsIgnoreCase("Ethernet") || ((String)object).equalsIgnoreCase("ETH")) {
                    bl = true;
                } else if (((String)object).equalsIgnoreCase("WIFI")) {
                    bl2 = true;
                } else if (((String)object).equalsIgnoreCase("MOBILE")) {
                    bl3 = true;
                }
            }
            if ((object = NetworkInterface.getNetworkInterfaces()) == null) {
                return string;
            }
            block2: while (object.hasMoreElements()) {
                NetworkInterface networkInterface = (NetworkInterface)object.nextElement();
                Enumeration<InetAddress> enumeration = networkInterface.getInetAddresses();
                while (enumeration.hasMoreElements()) {
                    InetAddress inetAddress = enumeration.nextElement();
                    if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                    string = inetAddress.getHostAddress();
                    if (!(bl ? networkInterface.getDisplayName().equals("eth0") : (bl2 ? networkInterface.getDisplayName().equals("wlan0") : bl3))) continue block2;
                    return string;
                }
            }
        }
        catch (Exception exception) {
            LeLog.w(TAG, exception);
        }
        return string;
    }

    public static String getBluetoothName() {
        try {
            BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            return bluetoothAdapter.getName();
        }
        catch (Exception exception) {
            return Build.MANUFACTURER + " " + Build.MODEL;
        }
    }
}

