/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.common.datareport;

import android.content.Context;
import android.text.TextUtils;
import com.hpplay.common.asyncmanager.AsyncManager;
import com.hpplay.common.datareport.ReportBean;
import com.hpplay.common.log.LeLog;
import com.hpplay.common.perfume.CTCipher;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class DataReport {
    private static final String TAG = DataReport.class.getSimpleName();
    private static DataReport instance;
    private final int MAX_SEMAPHORE = 5;
    private AtomicInteger mSemaphore = new AtomicInteger(5);
    private ArrayList<ReportRunnable> mTaskList = new ArrayList();
    private final int MAX_TASK_SIZE = 50;
    private CTCipher mCTCipher;

    public static void initDataReport(Context context, String string) {
        DataReport.initLocalInstance(context.getApplicationContext(), string);
    }

    public static void onDataReport(ReportBean reportBean) {
        DataReport.onDataReport(reportBean, false);
    }

    public static void onDataReport(ReportBean reportBean, boolean bl) {
        if (instance == null) {
            LeLog.w(TAG, "onDataReport ignore,must call initDataReport first");
            return;
        }
        instance.addTask(reportBean, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void initLocalInstance(Context context, String string) {
        Class<DataReport> clazz = DataReport.class;
        synchronized (DataReport.class) {
            if (instance == null) {
                instance = new DataReport();
            }
            instance.setEncrypt(string);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private DataReport() {
    }

    private void setEncrypt(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.mCTCipher = new CTCipher(string);
        }
    }

    private void addTask(ReportBean reportBean, final boolean bl) {
        while (this.mTaskList.size() > 50) {
            this.mTaskList.remove(0);
        }
        ReportRunnable reportRunnable = new ReportRunnable(){

            @Override
            public void run() {
                if (!TextUtils.isEmpty((CharSequence)this.reportBean.httpParameter.in.params) && !TextUtils.isEmpty((CharSequence)this.reportBean.encryptVersion) && DataReport.this.mCTCipher != null) {
                    String string = this.reportBean.httpParameter.in.params;
                    try {
                        string = DataReport.this.mCTCipher.encrypt(string);
                    }
                    catch (Exception exception) {
                        LeLog.w(TAG, exception);
                    }
                    if (this.reportBean.httpParameter.in.requestMethod == 0) {
                        try {
                            string = URLEncoder.encode(string, "utf-8");
                        }
                        catch (Exception exception) {
                            LeLog.w(TAG, exception);
                        }
                        this.reportBean.httpParameter.in.params = "v=" + this.reportBean.encryptVersion + "&s=" + string;
                    } else {
                        String string2 = this.reportBean.httpParameter.in.requestUrl;
                        if (!TextUtils.isEmpty((CharSequence)string2)) {
                            this.reportBean.httpParameter.in.requestUrl = string2.endsWith("?") ? this.reportBean.httpParameter.in.requestUrl + "v=" + this.reportBean.encryptVersion : this.reportBean.httpParameter.in.requestUrl + "?v=" + this.reportBean.encryptVersion;
                        }
                        if (bl) {
                            try {
                                string = URLEncoder.encode(string, "utf-8");
                            }
                            catch (Exception exception) {
                                LeLog.w(TAG, exception);
                            }
                        }
                        this.reportBean.httpParameter.in.params = string;
                    }
                }
                AsyncManager.getInstance().exeHttpTask(this.reportBean.httpParameter, this.reportBean.listener);
                DataReport.this.mSemaphore.set(Math.min(5, DataReport.this.mSemaphore.incrementAndGet()));
                DataReport.this.exeTask();
            }
        };
        reportRunnable.reportBean = reportBean;
        try {
            this.mTaskList.add(reportRunnable);
        }
        catch (Exception exception) {
            LeLog.w(TAG, "addTask " + exception);
        }
        this.exeTask();
    }

    private void exeTask() {
        if (this.mTaskList.size() > 0 && this.mSemaphore.get() > 0) {
            this.mSemaphore.getAndDecrement();
            try {
                ReportRunnable reportRunnable = this.mTaskList.remove(0);
                AsyncManager.getInstance().exeRunnable(reportRunnable, null);
            }
            catch (Exception exception) {
                LeLog.w(TAG, exception);
                this.exeTask();
            }
        } else if (this.mTaskList.size() == 0) {
            this.mSemaphore.set(5);
        }
    }

    public static abstract class ReportRunnable
    implements Runnable {
        public ReportBean reportBean;
    }
}

