/*
 * Decompiled with CFR 0.152.
 */
package dcutli;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class FileUtli {
    public static String getBoardName() {
        return FileUtli.getSystemProperty("ro.board.platform", "unknown");
    }

    public static int dpToPx(Context context, int dps) {
        return Math.round(context.getResources().getDisplayMetrics().density * (float)dps);
    }

    public static byte setSpecifiedBitTo1(byte originByte, int bitIndex) {
        originByte = (byte)(originByte | 1 << bitIndex);
        return originByte;
    }

    public static byte setSpecifiedBitTo0(byte originByte, int bitIndex) {
        originByte = (byte)(originByte & ~(1 << bitIndex));
        return originByte;
    }

    public static byte setSpecifiedBitToReverse(byte originByte, int bitIndex) {
        originByte = (byte)(originByte ^ 1 << bitIndex);
        return originByte;
    }

    public static byte getSpecifiedBitValue(byte originByte, int bitIndex) {
        return (byte)(originByte >> bitIndex & 1);
    }

    public static void CreateIfNotExist(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdir();
        }
        file = null;
    }

    public static int random(int min, int max) {
        if (min == max) {
            return 0;
        }
        int nRes = min + (int)(System.currentTimeMillis() % (long)(max - min));
        return nRes;
    }

    public static boolean isEthNetworkOk(Context context) {
        ConnectivityManager mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo mobNetInfo = mConnectivityManager.getNetworkInfo(9);
        if (mobNetInfo != null) {
            return mobNetInfo.isConnected();
        }
        return false;
    }

    public static boolean isWIFINetworkOk(Context context) {
        ConnectivityManager mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo mobNetInfo = mConnectivityManager.getNetworkInfo(1);
        if (mobNetInfo != null) {
            return mobNetInfo.isConnected();
        }
        return false;
    }

    public static boolean isMobileNetworkOk(Context context) {
        ConnectivityManager mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo mobNetInfo = mConnectivityManager.getNetworkInfo(0);
        if (mobNetInfo != null) {
            return mobNetInfo.isConnected();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String execRootCmd(String cmd) {
        String result = "";
        FilterOutputStream dos = null;
        FilterInputStream dis = null;
        try {
            Process p = Runtime.getRuntime().exec("su");
            dos = new DataOutputStream(p.getOutputStream());
            dis = new DataInputStream(p.getInputStream());
            ((DataOutputStream)dos).writeBytes(cmd + "\n");
            ((DataOutputStream)dos).flush();
            ((DataOutputStream)dos).writeBytes("exit\n");
            ((DataOutputStream)dos).flush();
            String line = null;
            BufferedReader br = new BufferedReader(new InputStreamReader(dis));
            while ((line = br.readLine()) != null) {
                result = result + line;
                result = result + "\n";
            }
            p.waitFor();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public static boolean isExist(String string) {
        File mFile = new File(string);
        return mFile.exists();
    }

    public static String getIPv4(String device) {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                if (!device.equals(intf.getDisplayName())) continue;
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                    return inetAddress.getHostAddress().toString();
                }
            }
        }
        catch (Exception e) {
            Log.e((String)"getIPv4", (String)"\u83b7\u53d6IP\u4fe1\u606f\u51fa\u9519\u3002");
        }
        return null;
    }

    private static String getSystemProperty(String property, String defaultValue) {
        try {
            Class<?> clazz = Class.forName("android.os.SystemProperties");
            Method getter = clazz.getDeclaredMethod("get", String.class);
            String value = (String)getter.invoke(clazz.newInstance(), property);
            if (!TextUtils.isEmpty((CharSequence)value)) {
                return value;
            }
        }
        catch (Exception var6) {
            Log.e((String)"FileUtli", (String)("Unable to read system properties" + var6.toString()));
        }
        return defaultValue;
    }

    public static void deleteFile(String path) {
        File file = new File(path);
        if (file.isFile() && file.exists()) {
            file.delete();
        }
        file = null;
    }

    public static String getFileNameWithoutSuffix(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return "";
        }
        int start = path.lastIndexOf("/");
        if (start != -1) {
            String fname = path.substring(start + 1);
            String prefix = fname.substring(fname.lastIndexOf("."));
            int num = prefix.length();
            String fileOtherName = fname.substring(0, fname.length() - num);
            return fileOtherName;
        }
        return "";
    }

    private static String getAppDataFilePath(Context context) {
        String cachePath = "mounted".equals(Environment.getExternalStorageState()) || !Environment.isExternalStorageRemovable() ? context.getFilesDir().getAbsolutePath() : context.getFilesDir().getAbsolutePath();
        return cachePath;
    }

    public static String getFromAssets(Context context, String fileName) {
        String result = "";
        try {
            InputStream in = context.getResources().getAssets().open(fileName);
            int lenght = in.available();
            byte[] buffer = new byte[lenght];
            in.read(buffer);
            result = new String(buffer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String fmtTime(long tm) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date curDate = new Date(tm);
        String curTime = formatter.format(curDate);
        return curTime;
    }

    public static byte[] getFromAssetsBin(Context context, String fileName) {
        try {
            InputStream in = context.getResources().getAssets().open(fileName);
            int lenght = in.available();
            byte[] buffer = new byte[lenght];
            in.read(buffer);
            return buffer;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getHomeLauncher(Context context) {
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.HOME");
        ResolveInfo resolveInfo = context.getPackageManager().resolveActivity(intent, 0);
        String currentHomePackage = resolveInfo.activityInfo.packageName;
        return currentHomePackage;
    }

    public static String getAppName(Context context, String packageName) {
        String str = packageName;
        PackageInfo info = null;
        PackageManager pm = context.getPackageManager();
        try {
            info = pm.getPackageInfo(str, 1);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        if (info == null) {
            return null;
        }
        return info.applicationInfo.loadLabel(pm).toString();
    }

    public static boolean serviceIsRun(Context mcontext, String serviceName) {
        boolean serviceIsRun = false;
        ActivityManager activityManager = (ActivityManager)mcontext.getSystemService("activity");
        List runningServices = activityManager.getRunningServices(100);
        for (int i = 0; i < runningServices.size(); ++i) {
            String s = ((ActivityManager.RunningServiceInfo)runningServices.get((int)i)).service.getClassName();
            if (!s.equals(serviceName)) continue;
            serviceIsRun = true;
        }
        return serviceIsRun;
    }

    public static boolean isAppExist(Context context, String packname) {
        PackageInfo packageInfo = null;
        try {
            packageInfo = context.getPackageManager().getPackageInfo(packname, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
        return packageInfo != null;
    }

    public static boolean isAppInstalled(Context context, String packageName) {
        PackageManager manager = context.getPackageManager();
        List pkgList = manager.getInstalledPackages(0);
        for (int i = 0; i < pkgList.size(); ++i) {
            PackageInfo pI = (PackageInfo)pkgList.get(i);
            if (!pI.packageName.equalsIgnoreCase(packageName)) continue;
            return true;
        }
        return false;
    }

    public static StringBuffer readFileByBytes(String fileName) {
        File file = new File(fileName);
        StringBuffer sb = new StringBuffer();
        if (file.isFile() && file.exists()) {
            byte[] tempbytes = new byte[1024];
            int byteread = 0;
            try {
                FileInputStream in = new FileInputStream(file);
                while ((byteread = ((InputStream)in).read(tempbytes)) != -1) {
                    String str = new String(tempbytes, 0, byteread);
                    sb.append(str);
                }
            }
            catch (FileNotFoundException e) {
                return sb;
            }
            catch (IOException iOException) {}
        } else {
            return sb;
        }
        return sb;
    }

    public static String md5Decode32(String content) {
        byte[] hash;
        try {
            hash = MessageDigest.getInstance("MD5").digest(content.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("NoSuchAlgorithmException", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UnsupportedEncodingException", e);
        }
        StringBuilder hex = new StringBuilder(hash.length * 2);
        for (byte b : hash) {
            if ((b & 0xFF) < 16) {
                hex.append("0");
            }
            hex.append(Integer.toHexString(b & 0xFF));
        }
        return hex.toString();
    }

    public static Bitmap adjustPhotoRotation(Bitmap bm, int orientationDegree) {
        Matrix m = new Matrix();
        m.setRotate((float)orientationDegree, (float)bm.getWidth() / 2.0f, (float)bm.getHeight() / 2.0f);
        try {
            Bitmap bm1 = Bitmap.createBitmap((Bitmap)bm, (int)0, (int)0, (int)bm.getWidth(), (int)bm.getHeight(), (Matrix)m, (boolean)true);
            return bm1;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return null;
        }
    }

    public static String bytes2HexString(byte[] b, int len) {
        String ret = "";
        for (int i = 0; i < len; ++i) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            ret = ret + hex.toUpperCase();
        }
        return ret;
    }

    public static String getUsbStoragePath() {
        String usbPath = null;
        String usbBasePath = "/mnt/usb_storage/";
        Object ApkPath = null;
        File file = new File(usbBasePath);
        try {
            File[] usbFiles;
            File usbFile;
            File[] files;
            if (file.exists() && file.isDirectory() && (files = file.listFiles()).length > 0 && (usbPath = files[0].getAbsolutePath()).contains("USB_DISK") && (usbFile = new File(usbPath)).exists() && usbFile.isDirectory() && (usbFiles = usbFile.listFiles()).length > 0) {
                usbPath = usbFiles[0].getAbsolutePath();
            }
        }
        catch (Exception var9) {
            var9.printStackTrace();
        }
        return usbPath;
    }

    public static Bitmap bitmapZoomByScale(Bitmap srcBitmap, float scaleWidth, float scaleHeight) {
        int width = srcBitmap.getWidth();
        int height = srcBitmap.getHeight();
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)srcBitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        if (bitmap != null) {
            return bitmap;
        }
        return srcBitmap;
    }

    public static String ReadFileB64(String filePath) {
        File file = new File(filePath);
        if (file.isFile() && file.exists()) {
            StringBuffer sb = new StringBuffer();
            byte[] tempbytes = new byte[1024];
            int byteread = 0;
            try {
                FileInputStream in = new FileInputStream(file);
                while ((byteread = ((InputStream)in).read(tempbytes)) != -1) {
                    String str = new String(tempbytes, 0, byteread);
                    sb.append(str);
                }
            }
            catch (FileNotFoundException e) {
                return null;
            }
            catch (IOException dd) {
                return null;
            }
            String jsonString = new String(sb);
            jsonString = new String(Base64.decode((String)jsonString, (int)0));
            return jsonString;
        }
        return null;
    }

    public static void simpleWriteFile(String path, byte[] data) {
        try {
            FileOutputStream fos = null;
            fos = new FileOutputStream(new File(path));
            fos.write(data, 0, data.length);
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    public static byte[] simpleReadFile(String path) {
        File f = new File(path);
        FileInputStream fileInputStream = null;
        byte[] buffer = null;
        try {
            fileInputStream = new FileInputStream(f);
            buffer = new byte[(int)f.length()];
            int len = fileInputStream.read(buffer);
            fileInputStream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer;
    }

    public static void WriteFileB64(String filePath, String fileContent) {
        String encodedString = Base64.encodeToString((byte[])fileContent.getBytes(), (int)0);
        FileOutputStream outSTr = null;
        try {
            outSTr = new FileOutputStream(new File(filePath));
            BufferedOutputStream Buff = new BufferedOutputStream(outSTr);
            Buff.write(encodedString.getBytes());
            Buff.flush();
            Buff.close();
            outSTr.close();
            outSTr = null;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String byteToStr(byte[] buffer) {
        try {
            int length = 0;
            for (int i = 0; i < buffer.length; ++i) {
                if (buffer[i] != 0) continue;
                length = i;
                break;
            }
            return new String(buffer, 0, length, "UTF-8");
        }
        catch (Exception e) {
            return "";
        }
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(FileUtli.charToByte(hexChars[pos]) << 4 | FileUtli.charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    public static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static byte[] listTobyte1(LinkedList<Byte> list, int cast_byte) {
        if (list == null || list.size() < 0) {
            return null;
        }
        byte[] bytes = new byte[cast_byte];
        Iterator iterator = list.iterator();
        for (int i = 0; iterator.hasNext() && i < cast_byte; ++i) {
            bytes[i] = (Byte)iterator.next();
        }
        return bytes;
    }

    public static Bitmap nv21ToBitmap(byte[] nv21, int width, int height) {
        Bitmap bitmap = null;
        try {
            YuvImage image = new YuvImage(nv21, 17, width, height, null);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            image.compressToJpeg(new Rect(0, 0, width, height), 80, (OutputStream)stream);
            bitmap = BitmapFactory.decodeByteArray((byte[])stream.toByteArray(), (int)0, (int)stream.size());
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bitmap;
    }

    public static NetworkInfo getConnectedType(Context context) {
        if (context == null) {
            return null;
        }
        ConnectivityManager mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo mNetworkInfo = mConnectivityManager.getActiveNetworkInfo();
        if (mNetworkInfo != null && mNetworkInfo.isAvailable()) {
            return mNetworkInfo;
        }
        return null;
    }
}

