/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.xbill.dns;

public class DNSOutput {
    private byte[] array;
    private int pos;
    private int saved_pos;

    public DNSOutput(int n2) {
        this.array = new byte[n2];
        this.pos = 0;
        this.saved_pos = -1;
    }

    public DNSOutput() {
        this(32);
    }

    public int current() {
        return this.pos;
    }

    private void check(long l2, int n2) {
        long l3 = 1L;
        if (l2 < 0L || l2 > (l3 <<= n2)) {
            throw new IllegalArgumentException(l2 + " out of range for " + n2 + " bit value");
        }
    }

    private void need(int n2) {
        if (this.array.length - this.pos >= n2) {
            return;
        }
        int n3 = this.array.length * 2;
        if (n3 < this.pos + n2) {
            n3 = this.pos + n2;
        }
        byte[] byArray = new byte[n3];
        System.arraycopy(this.array, 0, byArray, 0, this.pos);
        this.array = byArray;
    }

    public void jump(int n2) {
        if (n2 > this.pos) {
            throw new IllegalArgumentException("cannot jump past end of data");
        }
        this.pos = n2;
    }

    public void save() {
        this.saved_pos = this.pos;
    }

    public void restore() {
        if (this.saved_pos < 0) {
            throw new IllegalStateException("no previous state");
        }
        this.pos = this.saved_pos;
        this.saved_pos = -1;
    }

    public void writeU8(int n2) {
        this.check(n2, 8);
        this.need(1);
        this.array[this.pos++] = (byte)(n2 & 0xFF);
    }

    public void writeU16(int n2) {
        this.check(n2, 16);
        this.need(2);
        this.array[this.pos++] = (byte)(n2 >>> 8 & 0xFF);
        this.array[this.pos++] = (byte)(n2 & 0xFF);
    }

    public void writeU16At(int n2, int n3) {
        this.check(n2, 16);
        if (n3 > this.pos - 2) {
            throw new IllegalArgumentException("cannot write past end of data");
        }
        this.array[n3++] = (byte)(n2 >>> 8 & 0xFF);
        this.array[n3++] = (byte)(n2 & 0xFF);
    }

    public void writeU32(long l2) {
        this.check(l2, 32);
        this.need(4);
        this.array[this.pos++] = (byte)(l2 >>> 24 & 0xFFL);
        this.array[this.pos++] = (byte)(l2 >>> 16 & 0xFFL);
        this.array[this.pos++] = (byte)(l2 >>> 8 & 0xFFL);
        this.array[this.pos++] = (byte)(l2 & 0xFFL);
    }

    public void writeByteArray(byte[] byArray, int n2, int n3) {
        this.need(n3);
        System.arraycopy(byArray, n2, this.array, this.pos, n3);
        this.pos += n3;
    }

    public void writeByteArray(byte[] byArray) {
        this.writeByteArray(byArray, 0, byArray.length);
    }

    public void writeCountedString(byte[] byArray) {
        if (byArray.length > 255) {
            throw new IllegalArgumentException("Invalid counted string");
        }
        this.need(1 + byArray.length);
        this.array[this.pos++] = (byte)(byArray.length & 0xFF);
        this.writeByteArray(byArray, 0, byArray.length);
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.pos];
        System.arraycopy(this.array, 0, byArray, 0, this.pos);
        return byArray;
    }
}

