/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.model.stream;

import android.content.Context;
import android.text.TextUtils;
import com.hpplay.glide.Glide;
import com.hpplay.glide.load.data.DataFetcher;
import com.hpplay.glide.load.model.GlideUrl;
import com.hpplay.glide.load.model.Headers;
import com.hpplay.glide.load.model.ModelCache;
import com.hpplay.glide.load.model.ModelLoader;
import com.hpplay.glide.load.model.stream.StreamModelLoader;
import java.io.InputStream;

public abstract class BaseGlideUrlLoader<T>
implements StreamModelLoader<T> {
    private final ModelLoader<GlideUrl, InputStream> concreteLoader;
    private final ModelCache<T, GlideUrl> modelCache;

    public BaseGlideUrlLoader(Context context) {
        this(context, null);
    }

    public BaseGlideUrlLoader(Context context, ModelCache<T, GlideUrl> modelCache) {
        this(Glide.buildModelLoader(GlideUrl.class, InputStream.class, context), modelCache);
    }

    public BaseGlideUrlLoader(ModelLoader<GlideUrl, InputStream> modelLoader) {
        this(modelLoader, null);
    }

    public BaseGlideUrlLoader(ModelLoader<GlideUrl, InputStream> modelLoader, ModelCache<T, GlideUrl> modelCache) {
        this.concreteLoader = modelLoader;
        this.modelCache = modelCache;
    }

    @Override
    public DataFetcher<InputStream> getResourceFetcher(T t2, int n2, int n3) {
        GlideUrl glideUrl = null;
        if (this.modelCache != null) {
            glideUrl = this.modelCache.get(t2, n2, n3);
        }
        if (glideUrl == null) {
            String string = this.getUrl(t2, n2, n3);
            if (TextUtils.isEmpty((CharSequence)string)) {
                return null;
            }
            glideUrl = new GlideUrl(string, this.getHeaders(t2, n2, n3));
            if (this.modelCache != null) {
                this.modelCache.put(t2, n2, n3, glideUrl);
            }
        }
        return this.concreteLoader.getResourceFetcher(glideUrl, n2, n3);
    }

    protected abstract String getUrl(T var1, int var2, int var3);

    protected Headers getHeaders(T t2, int n2, int n3) {
        return Headers.DEFAULT;
    }
}

