/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.mirror.rtsp;

import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.hpplay.component.common.ParamsMap;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.component.protocol.NLProtocolBuiler;
import com.hpplay.component.protocol.PlistBuilder;
import com.hpplay.component.protocol.ProtocolSender;
import com.hpplay.component.protocol.ProtocolUtils;
import com.hpplay.component.protocol.encrypt.LelinkEncrypt;
import com.hpplay.component.protocol.encrypt.MirrorFrameEcrypto;
import com.hpplay.component.protocol.mirror.VideoSender;
import com.hpplay.component.protocol.mirror.rtsp.RtspClient;
import com.hpplay.component.protocol.plist.NSArray;
import com.hpplay.component.protocol.plist.NSDictionary;
import com.hpplay.component.protocol.plist.NSNumber;
import com.hpplay.component.protocol.plist.NSObject;
import com.hpplay.component.protocol.plist.PropertyListParser;

public class LelinkV2RtspClient
extends RtspClient {
    private static final String TAG = "LelinkV2RtspClient";
    private static final int AUDIO_MODEL = 96;
    private static final int VIDEO_MODEL = 97;
    private ProtocolSender mProtocolSender;
    private VideoSender mMirrorDataSender;
    public static int mMirrorPort = 0;
    private double mRefreshRate = 60.0;
    private int mlelinkPort;
    private String mDeviceId;
    private String mDeviceName;
    private String mLocalip;
    private int mUdpServerPort = 0;
    private String mSessionId;
    private int cseq = 0;
    private String mMst;
    private String mAst;
    private int mAtv = 0;
    private LelinkEncrypt mLelinkEncrypt;
    private String mScreenCode;
    private String mUri;
    private String mIp;
    private String mMac;
    private boolean mEncrypt;
    private boolean isUseAudio = false;
    private String mUid;
    private int mRudpPort;

    public LelinkV2RtspClient(ParamsMap paramsMap) {
        this.mScreenCode = String.valueOf(paramsMap.getParam("screencode", "000000"));
        this.mUri = paramsMap.getStringParam("uri");
        try {
            this.mIDWidth = Integer.parseInt(paramsMap.getStringParam("phone_width"));
            this.mIDHeight = Integer.parseInt(paramsMap.getStringParam("phone_height"));
        }
        catch (Exception exception) {
            this.mIDWidth = 1080;
            this.mIDHeight = 1920;
            Log.w((String)TAG, (Throwable)exception);
        }
        this.mMac = (String)paramsMap.getParam("mac", "000000000000");
        this.mDeviceId = "0x" + this.mMac;
        this.mSessionId = paramsMap.getStringParam("sessionId");
        this.mIp = paramsMap.getStringParam("ip");
        this.mUid = paramsMap.getCuid();
        String string = paramsMap.getATV();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.mAtv = Integer.valueOf(string);
        }
        this.mlelinkPort = Integer.parseInt(paramsMap.getParam("lelink_port", "0").toString());
        this.mDeviceName = Build.MANUFACTURER + " " + Build.MODEL;
        this.mProtocolSender = new ProtocolSender();
        this.mProtocolSender.setConnectInfo(this.mIp, this.mlelinkPort);
        this.mLocalip = ProtocolUtils.getLoaclIp();
        this.mMirrorDataSender = new VideoSender();
    }

    @Override
    public int exeLelinkRtsp(boolean bl, String ... stringArray) {
        int n2 = 0;
        try {
            boolean bl2;
            int n3 = Integer.parseInt(stringArray[0]);
            String string = stringArray[1];
            n2 = 120105102;
            n2 = this.sendRequestGetMirrorInfo();
            CLog.i(TAG, " sendRequestGetMirrorInfo ");
            if (n2 == 0) {
                return n2;
            }
            if (n2 == 10) {
                return 211026;
            }
            if (n2 == 12) {
                return 211027;
            }
            n2 = 120105106;
            n2 = this.sendRequestVideoSetup(n3, Integer.parseInt(stringArray[2]));
            if (n2 == 12) {
                return 120105110;
            }
            if (n2 == 0) {
                return 120105106;
            }
            if (bl) {
                bl2 = this.sendRequestAudioSetup();
                CLog.i(TAG, "AudioSetup" + bl2);
            }
            n2 = 120105107;
            bl2 = this.sendRequestRecord();
            this.setMirrorMode(string);
            CLog.i(TAG, "tRecord" + bl2);
            if (bl2) {
                return 1;
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
            this.mErrorMsg = CLog.getExceptionStr(exception);
        }
        return n2;
    }

    @Override
    public boolean sendRequestGetMirrorPort() {
        return true;
    }

    @Override
    public int sendRequestGetMirrorInfo() {
        try {
            boolean bl;
            boolean bl2;
            if (this.mProtocolSender == null) {
                this.mProtocolSender = new ProtocolSender();
                this.mProtocolSender.setConnectInfo(this.mIp, this.mlelinkPort);
            }
            if (!(bl2 = this.mProtocolSender.connectServer())) {
                return 0;
            }
            this.mLelinkEncrypt = new LelinkEncrypt(this.mSessionId);
            this.mLelinkEncrypt.setSrpPassword(this.mScreenCode);
            bl2 = this.mProtocolSender.checkEncrypt(this.mLelinkEncrypt, TAG);
            if (!bl2) {
                if (this.mLelinkEncrypt.getEncryptState().equals("603")) {
                    return 10;
                }
                if (this.mLelinkEncrypt.getEncryptState().equals("453")) {
                    return 12;
                }
                return 0;
            }
            this.cseq = 0;
            ++this.cseq;
            byte[] byArray = new NLProtocolBuiler().getActionInfoCmd().setPlatfrom().setUserAgent("HappyCast5,0/500.0").setNewClientDid(this.mDeviceId).setNewSessionId(this.mSessionId).setNewClientName(this.mDeviceName).setNewClientAppid(this.mMac).setNewClientVersion("5.5").setNewClientDid("0x" + this.mMac).setNewClientCU(this.mUid).setNewCSEQ(this.cseq + "").setContentLength("0").getProtocal(true);
            byte[] byArray2 = this.mProtocolSender.interactiveEncryptData(new byte[][]{this.mLelinkEncrypt.buildEncryptData(new byte[][]{byArray})});
            if ((byArray2 = this.mLelinkEncrypt.decryptData(byArray2)) != null && byArray2.length > 0 && (bl = this.parseMirrorInfo(new String(byArray2)))) {
                return 1;
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
            throw exception;
        }
        return 0;
    }

    @Override
    public boolean sendRequestSetOptions() {
        try {
            ++this.cseq;
            String string = this.buildHeader(new NLProtocolBuiler().getRtspFeedbackCmd(), 0);
            byte[] byArray = this.mProtocolSender.interactiveEncryptData(new byte[][]{this.mLelinkEncrypt.buildEncryptData(new byte[][]{string.getBytes()})});
            byArray = this.mLelinkEncrypt.decryptData(byArray);
            if (byArray != null && byArray.length > 0) {
                return true;
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
        return false;
    }

    @Override
    public boolean sendRequestAnnounce() {
        return true;
    }

    @Override
    public int sendRequestVideoSetup(int n2, int n3) {
        ++this.cseq;
        String string = Build.VERSION.SDK_INT >= 24 ? ProtocolUtils.getDateTime(System.currentTimeMillis()) : "20180319000900";
        this.mMirrorFrameEcrypto = new MirrorFrameEcrypto(ProtocolUtils.Encrypt("HappyCast5,0/500.0"), ProtocolUtils.Encrypt(string));
        String string2 = new PlistBuilder().addIntagerToRoot("event-port", n2).addIntagerToRoot("timing-port", 0).addStringToRoot("uuid", this.mUri).addIntagerToRoot("mst", n3).addStringToRoot("stream-time", string).createIPlistArray("streams", 1).addIntagerToArray("streams", 0, "type", 97).addArrayToRoot("streams").getPotocol();
        CLog.i(TAG, "=============>> " + string2 + "   " + n2 + "  " + n3);
        String string3 = this.buildHeader(new NLProtocolBuiler().getVideoSetUpCmd(this.mLocalip, System.currentTimeMillis() + ""), string2.length());
        String string4 = string3 + string2;
        byte[] byArray = new byte[]{};
        byArray = this.mProtocolSender.interactiveEncryptData(new byte[][]{this.mLelinkEncrypt.buildEncryptData(new byte[][]{string4.getBytes()})});
        byArray = this.mLelinkEncrypt.decryptData(byArray);
        if (byArray != null && byArray.length > 0) {
            NSObject nSObject;
            CLog.i(TAG, "=======================================----->\r\n" + new String(byArray));
            String string5 = ProtocolUtils.getHeader(byArray);
            CLog.d(TAG, "SETUP call back agin ----->" + string5);
            if (!TextUtils.isEmpty((CharSequence)string5) && string5.contains("453")) {
                return 12;
            }
            NSDictionary nSDictionary = (NSDictionary)PropertyListParser.parse(ProtocolUtils.removeHeader(byArray));
            if (!nSDictionary.containsKey("timing-port") || (nSObject = (NSNumber)nSDictionary.get("timing-port")) == null || ((NSNumber)nSObject).intValue() > 0) {
                // empty if block
            }
            if (nSDictionary.containsKey("streams") && (nSObject = (NSArray)nSDictionary.get("streams")) != null) {
                boolean bl = false;
                for (int i2 = 0; i2 < ((NSArray)nSObject).count(); ++i2) {
                    String string6;
                    NSDictionary nSDictionary2 = (NSDictionary)((NSArray)nSObject).getArray()[i2];
                    if (nSDictionary2 != null && nSDictionary2.get("data-port") != null) {
                        string6 = nSDictionary2.get("data-port").toString();
                        mMirrorPort = Integer.parseInt(string6);
                    }
                    if (nSDictionary2 != null && nSDictionary2.get("udp-port") != null) {
                        string6 = nSDictionary2.get("udp-port").toString();
                        this.mRudpPort = Integer.parseInt(string6);
                    }
                    if (this.mRudpPort <= 0) continue;
                    bl = this.mMirrorDataSender.connect(this.mIp, this.mRudpPort, 1);
                    this.mBitrate = this.mMirrorDataSender.getInitBitrate();
                }
                if (!bl) {
                    bl = this.mMirrorDataSender.connect(this.mIp, mMirrorPort, 2);
                }
                if (bl) {
                    return 1;
                }
            }
        }
        return 0;
    }

    @Override
    public boolean sendRequestAudioSetup() {
        ++this.cseq;
        this.isUseAudio = true;
        int n2 = 0;
        if (!TextUtils.isEmpty((CharSequence)this.mAst)) {
            n2 = Integer.parseInt(this.mAst);
        }
        String string = new PlistBuilder().addIntagerToRoot("timing-port", 0).addIntagerToRoot("ast", n2).createIPlistArray("streams", 1).addStringToRoot("uuid", this.mUri).addIntagerToArray("streams", 0, "type", 96).addBlooeanToArray("streams", 0, "play-mode", true).addIntagerToArray("streams", 0, "sample-format", 212).addIntagerToArray("streams", 0, "sample-rate", 44100).addIntagerToArray("streams", 0, "control-port", 0).addIntagerToArray("streams", 0, "latencyMax", 3750).addIntagerToArray("streams", 0, "latencyMin", 3750).addArrayToRoot("streams").getPotocol();
        String string2 = this.buildHeader(new NLProtocolBuiler().getAudioSetUpCmd(this.mLocalip, System.currentTimeMillis() + ""), string.length());
        String string3 = string2 + string;
        byte[] byArray = new byte[]{};
        byArray = this.mProtocolSender.interactiveEncryptData(new byte[][]{this.mLelinkEncrypt.buildEncryptData(new byte[][]{string3.getBytes()})});
        if ((byArray = this.mLelinkEncrypt.decryptData(byArray)) != null && byArray.length > 0) {
            NSArray nSArray;
            CLog.d(TAG, "SETUP call back agin ----->" + new String(byArray));
            NSDictionary nSDictionary = (NSDictionary)PropertyListParser.parse(ProtocolUtils.removeHeader(byArray));
            if (nSDictionary.containsKey("streams") && (nSArray = (NSArray)nSDictionary.get("streams")) != null) {
                for (int i2 = 0; i2 < nSArray.getArray().length; ++i2) {
                    NSDictionary nSDictionary2 = (NSDictionary)nSArray.getArray()[i2];
                    if (nSDictionary2 == null || nSDictionary2.get("data-port") == null) continue;
                    String string4 = nSDictionary2.get("data-port").toString();
                    this.mUdpServerPort = Integer.parseInt(string4);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean sendRequestRecord() {
        ++this.cseq;
        String string = this.buildHeader(new NLProtocolBuiler().getRecordCmd(this.mLocalip, System.currentTimeMillis() + ""), 0);
        byte[] byArray = this.mProtocolSender.interactiveEncryptData(new byte[][]{this.mLelinkEncrypt.buildEncryptData(new byte[][]{string.getBytes()})});
        if (byArray == null) {
            this.mProtocolSender.release();
            return false;
        }
        CLog.i(TAG, "RECORD call back  ----->" + new String(this.mLelinkEncrypt.decryptData(byArray)));
        return true;
    }

    @Override
    public boolean sendRequestGetParamter() {
        return true;
    }

    @Override
    public boolean sendRequestSetParamter() {
        return true;
    }

    @Override
    public synchronized boolean sendRequestSetTeardown() {
        boolean bl = false;
        try {
            ++this.cseq;
            String string = this.getTeardownData(97);
            CLog.i(TAG, "start  send teardown \n" + string);
            if (this.mProtocolSender != null && this.mLelinkEncrypt != null) {
                byte[] byArray = this.mProtocolSender.interactiveEncryptData(new byte[][]{this.mLelinkEncrypt.buildEncryptData(new byte[][]{string.getBytes()})});
                if (byArray != null && byArray.length > 0) {
                    bl = true;
                    CLog.i(TAG, "start  send teardown  resutlt : \n" + new String(this.mLelinkEncrypt.decryptData(byArray)));
                } else {
                    bl = false;
                }
                if (this.isUseAudio && (byArray = this.mProtocolSender.interactiveEncryptData(new byte[][]{this.mLelinkEncrypt.buildEncryptData(new byte[][]{(string = this.getTeardownData(96)).getBytes()})})) != null && byArray.length > 0) {
                    bl = true;
                }
                CLog.d(TAG, "start stopTask");
            }
            this.release();
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
        return bl;
    }

    @Override
    public boolean setMirrorMode(String string) {
        try {
            if (this.mProtocolSender != null && !TextUtils.isEmpty((CharSequence)string)) {
                byte[] byArray = new NLProtocolBuiler().getMirrorModeCmd().setPlatfrom().setUserAgent("HappyCast5,0/500.0").setNewClientDid(this.mDeviceId).setNewSessionId(this.mSessionId).setMirrorMode(string).setNewCSEQ(this.cseq + "").setContentLength("0").getProtocal(true);
                byte[] byArray2 = this.mProtocolSender.interactiveEncryptData(new byte[][]{this.mLelinkEncrypt.buildEncryptData(new byte[][]{byArray})});
                CLog.i(TAG, "   send mirror mode " + (byArray2 != null));
                if (byArray2 != null) {
                    byte[] byArray3 = this.mLelinkEncrypt.decryptData(byArray2);
                    CLog.d(TAG, new String(byArray3));
                }
                return true;
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
        return false;
    }

    @Override
    public boolean isEncrypt() {
        return this.mEncrypt;
    }

    @Override
    public double getRefreshRate() {
        return this.mRefreshRate;
    }

    @Override
    public int getBitRate() {
        return this.mBitrate;
    }

    @Override
    public int getSinkWidth() {
        return this.mWidth;
    }

    @Override
    public int getSinkHeight() {
        return this.mHeight;
    }

    @Override
    public void setSinkWidth(int n2) {
        this.mWidth = n2;
    }

    @Override
    public void setSinkHeight(int n2) {
        this.mHeight = n2;
    }

    @Override
    public int getTvWidth() {
        return this.mTvWidth;
    }

    @Override
    public int getTvHeight() {
        return this.mTvHeight;
    }

    @Override
    public VideoSender getVideoDataSender() {
        return this.mMirrorDataSender;
    }

    @Override
    public int getAudioPort() {
        return this.mUdpServerPort;
    }

    @Override
    public String getAudioServerIp() {
        return this.mIp;
    }

    @Override
    public String getEncodeType() {
        return this.mEncodeType;
    }

    @Override
    public void release() {
        CLog.d(TAG, " New LelinkRtspClient stopTask ");
        if (this.mProtocolSender != null) {
            CLog.d(TAG, "close mProtocalSender");
            this.mProtocolSender.release();
            this.mProtocolSender = null;
        }
        if (this.mMirrorDataSender != null) {
            CLog.d(TAG, "close mMirrorDataSender");
            this.mMirrorDataSender.release();
        }
        if (this.mLelinkEncrypt != null) {
            this.mLelinkEncrypt.release();
            this.mLelinkEncrypt = null;
        }
    }

    private String getTeardownData(int n2) {
        String string = new PlistBuilder().createIPlistArray("streams", 1).addIntagerToArray("streams", 0, "type", n2).addArrayToRoot("streams").getPotocol();
        String string2 = this.buildHeader(new NLProtocolBuiler().getTearDownCmd(this.mLocalip, System.currentTimeMillis() + ""), string.length());
        String string3 = string2 + string;
        return string3;
    }

    public boolean parseMirrorInfo(String string) {
        String[] stringArray = null;
        stringArray = string.split("\r\n");
        String string2 = stringArray[0];
        if (!TextUtils.isEmpty((CharSequence)string2) && string2.contains("200")) {
            this.mEncrypt = true;
            byte[] byArray = ProtocolUtils.removeHeader(string.getBytes());
            try {
                CLog.d(TAG, "parseMirrorInfo --->" + new String(byArray));
                NSDictionary nSDictionary = (NSDictionary)PropertyListParser.parse(byArray);
                if (nSDictionary != null) {
                    if (nSDictionary.containsKey("mst")) {
                        this.mMst = nSDictionary.get("mst").toString();
                    }
                    if (nSDictionary.containsKey("ast")) {
                        this.mAst = nSDictionary.get("ast").toString();
                    }
                    if (nSDictionary.containsKey("displays")) {
                        NSArray nSArray = (NSArray)nSDictionary.get("displays");
                        if (nSArray != null) {
                            for (int i2 = 0; i2 < nSArray.getArray().length; ++i2) {
                                NSDictionary nSDictionary2 = (NSDictionary)nSArray.getArray()[i2];
                                for (int i3 = 0; i3 < nSDictionary2.allKeys().length; ++i3) {
                                    if (TextUtils.equals((CharSequence)nSDictionary2.allKeys()[i3], (CharSequence)"width")) {
                                        String string3 = nSDictionary2.get("width").toString();
                                        this.mTvWidth = Integer.valueOf(string3);
                                        continue;
                                    }
                                    if (TextUtils.equals((CharSequence)nSDictionary2.allKeys()[i3], (CharSequence)"height")) {
                                        String string4 = nSDictionary2.get("height").toString();
                                        this.mTvHeight = Integer.valueOf(string4);
                                        continue;
                                    }
                                    if (!TextUtils.equals((CharSequence)nSDictionary2.allKeys()[i3], (CharSequence)"refresh-rate")) continue;
                                    try {
                                        String string5 = nSDictionary2.get("refresh-rate").toString();
                                        double d2 = Float.valueOf(string5).floatValue();
                                        if (d2 < 1.0) {
                                            d2 = 1.0 / d2;
                                        }
                                        this.mRefreshRate = d2;
                                        continue;
                                    }
                                    catch (Exception exception) {
                                        CLog.w(TAG, exception);
                                    }
                                }
                            }
                        }
                        CLog.i(TAG, "" + this.mTvWidth + "x" + this.mTvHeight + "@" + this.mRefreshRate);
                        this.adjustScreenSize();
                        return true;
                    }
                }
            }
            catch (Exception exception) {
                CLog.w(TAG, exception);
            }
        }
        return false;
    }

    private String buildHeader(NLProtocolBuiler nLProtocolBuiler, int n2) {
        return nLProtocolBuiler.setPlatfrom().setUserAgent("HappyCast5,0/500.0").setNewLelinkClientId(this.mDeviceId).setNewSessionId(this.mSessionId).setNewClientUid(this.mUid).setContentType("application/plist+xml").setNewCSEQ(this.cseq + "").setContentLength(n2 + "").getString(true);
    }
}

