/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.util;

import android.util.Log;
import com.hpplay.glide.util.Util;
import java.util.Queue;

public final class ByteArrayPool {
    private static final String TAG = "ByteArrayPool";
    private static final int TEMP_BYTES_SIZE = 65536;
    private static final int MAX_SIZE = 0x20C000;
    private static final int MAX_BYTE_ARRAY_COUNT = 32;
    private final Queue<byte[]> tempQueue = Util.createQueue(0);
    private static final ByteArrayPool BYTE_ARRAY_POOL = new ByteArrayPool();

    public static ByteArrayPool get() {
        return BYTE_ARRAY_POOL;
    }

    private ByteArrayPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Queue<byte[]> queue = this.tempQueue;
        synchronized (queue) {
            this.tempQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() {
        byte[] byArray;
        Queue<byte[]> queue = this.tempQueue;
        synchronized (queue) {
            byArray = this.tempQueue.poll();
        }
        if (byArray == null) {
            byArray = new byte[65536];
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)"Created temp bytes");
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean releaseBytes(byte[] byArray) {
        if (byArray.length != 65536) {
            return false;
        }
        boolean bl = false;
        Queue<byte[]> queue = this.tempQueue;
        synchronized (queue) {
            if (this.tempQueue.size() < 32) {
                bl = true;
                this.tempQueue.offer(byArray);
            }
        }
        return bl;
    }
}

