/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.browse;

import android.net.wifi.WifiManager;
import android.text.TextUtils;
import com.hpplay.component.browse.DLNABrowse;
import com.hpplay.component.browse.LelinkBrowse;
import com.hpplay.component.browse.MDNSBrowse;
import com.hpplay.component.common.browse.IBrowseResultListener;
import com.hpplay.component.common.browse.IBrowser;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.component.modulelinker.api.ModuleLinker;
import org.json.JSONObject;

public class BrowseController
implements IBrowser {
    private static final String TAG = "BrowseController";
    private DLNABrowse mDlnaBrowse;
    private MDNSBrowse mMdnsBrowse;
    private LelinkBrowse mLelinkBrowse = new LelinkBrowse();
    private IBrowseResultListener mBrowseResultListener;
    private static int mType = 3;
    private WifiManager.MulticastLock mLock;

    public BrowseController() {
        CLog.w(TAG, "create BrowseController");
        try {
            this.mBrowseResultListener = (IBrowseResultListener)ModuleLinker.getInstance().callMethod("B2C22E879D5158F81803EA0095FF7B1D", new Object[0]);
        }
        catch (Exception exception) {
            CLog.w(TAG, "BROWSE INFOS POOL MANAGER load failed");
        }
    }

    @Override
    public void startBrowse(int n2, IBrowseResultListener iBrowseResultListener) {
        this.createMulticastLock();
        mType = n2;
        IBrowseResultListener iBrowseResultListener2 = iBrowseResultListener;
        if (this.mBrowseResultListener != null) {
            iBrowseResultListener2 = this.mBrowseResultListener;
            try {
                ModuleLinker.getInstance().callMethod("3A2E9EDE11C4D04E70649EF3CB06FFAD", iBrowseResultListener);
            }
            catch (Exception exception) {
                CLog.w(TAG, "BROWSE INFOS POOL set browse listener failed");
            }
        }
        this.createNewBrowse(n2, iBrowseResultListener2);
    }

    void createNewBrowse(int n2, IBrowseResultListener iBrowseResultListener) {
        if (n2 == 2) {
            this.mDlnaBrowse = new DLNABrowse();
            this.mDlnaBrowse.startBrowse(iBrowseResultListener);
        } else if (n2 == 1) {
            this.mMdnsBrowse = new MDNSBrowse();
            this.mMdnsBrowse.startBrowse(iBrowseResultListener);
            if (this.mLelinkBrowse != null) {
                this.mLelinkBrowse.release();
            }
            if (this.mLelinkBrowse != null) {
                this.mLelinkBrowse.startBrowse(iBrowseResultListener);
            }
        } else {
            this.mDlnaBrowse = new DLNABrowse();
            this.mDlnaBrowse.startBrowse(iBrowseResultListener);
            this.mMdnsBrowse = new MDNSBrowse();
            this.mMdnsBrowse.startBrowse(iBrowseResultListener);
            if (this.mLelinkBrowse != null) {
                this.mLelinkBrowse.release();
            }
            if (this.mLelinkBrowse != null) {
                this.mLelinkBrowse.startBrowse(iBrowseResultListener);
            }
        }
    }

    private void createMulticastLock() {
        try {
            WifiManager wifiManager = (WifiManager)ModuleLinker.getInstance().getContext().getApplicationContext().getSystemService("wifi");
            if (null != wifiManager) {
                this.mLock = wifiManager.createMulticastLock(TAG);
                this.mLock.setReferenceCounted(false);
                this.mLock.acquire();
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
    }

    private void release() {
        try {
            if (null != this.mLock && this.mLock.isHeld()) {
                this.mLock.release();
                this.mLock = null;
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
    }

    @Override
    public void startBrowse(int n2) {
        this.createNewBrowse(n2, this.mBrowseResultListener);
    }

    @Override
    public void stopBrowse() {
        this.release();
        if (this.mDlnaBrowse != null) {
            CLog.i(TAG, " ============ > stop browse ");
            this.mDlnaBrowse.release();
        }
        if (this.mLelinkBrowse != null) {
            CLog.i(TAG, " ============ > stop  LelinkBrowse ");
            this.mLelinkBrowse.release();
        }
        if (this.mMdnsBrowse != null) {
            this.mMdnsBrowse.release();
        }
        CLog.i(TAG, " ============ > stopped ");
    }

    @Override
    public String getBrowseErrorMsg() {
        JSONObject jSONObject = new JSONObject();
        boolean bl = false;
        if (this.mDlnaBrowse != null && !TextUtils.isEmpty((CharSequence)this.mDlnaBrowse.getErrorMsg())) {
            try {
                CLog.i(TAG, this.mDlnaBrowse.getErrorMsg());
                jSONObject.put("dlna", (Object)this.mDlnaBrowse.getErrorMsg());
            }
            catch (Exception exception) {
                CLog.w(TAG, exception);
            }
            bl = true;
        }
        if (this.mMdnsBrowse != null && !TextUtils.isEmpty((CharSequence)this.mMdnsBrowse.getErrorMsg())) {
            try {
                CLog.i(TAG, this.mMdnsBrowse.getErrorMsg());
                jSONObject.put("mdns", (Object)this.mMdnsBrowse.getErrorMsg());
            }
            catch (Exception exception) {
                CLog.w(TAG, exception);
            }
            bl = true;
        }
        return bl ? jSONObject.toString() : null;
    }
}

