/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.xbill.dns;

import com.hpplay.sdk.source.mdns.xbill.dns.DNSInput;
import com.hpplay.sdk.source.mdns.xbill.dns.DNSOutput;
import com.hpplay.sdk.source.mdns.xbill.dns.Flags;
import com.hpplay.sdk.source.mdns.xbill.dns.Opcode;
import com.hpplay.sdk.source.mdns.xbill.dns.Rcode;
import com.hpplay.sdk.source.mdns.xbill.dns.Section;
import java.util.Random;

public class Header
implements Cloneable {
    private int id;
    private int flags;
    private int[] counts;
    private static Random random = new Random();
    public static final int LENGTH = 12;

    private void init() {
        this.counts = new int[4];
        this.flags = 0;
        this.id = -1;
    }

    public Header(int n2) {
        this.init();
        this.setID(n2);
    }

    public Header() {
        this.init();
    }

    Header(DNSInput dNSInput) {
        this(dNSInput.readU16());
        this.flags = dNSInput.readU16();
        for (int i2 = 0; i2 < this.counts.length; ++i2) {
            this.counts[i2] = dNSInput.readU16();
        }
    }

    public Header(byte[] byArray) {
        this(new DNSInput(byArray));
    }

    void toWire(DNSOutput dNSOutput) {
        dNSOutput.writeU16(this.getID());
        dNSOutput.writeU16(this.flags);
        for (int i2 = 0; i2 < this.counts.length; ++i2) {
            dNSOutput.writeU16(this.counts[i2]);
        }
    }

    public byte[] toWire() {
        DNSOutput dNSOutput = new DNSOutput();
        this.toWire(dNSOutput);
        return dNSOutput.toByteArray();
    }

    private static boolean validFlag(int n2) {
        return n2 >= 0 && n2 <= 15 && Flags.isFlag(n2);
    }

    private static void checkFlag(int n2) {
        if (!Header.validFlag(n2)) {
            throw new IllegalArgumentException("invalid flag bit " + n2);
        }
    }

    static int setFlag(int n2, int n3, boolean bl) {
        Header.checkFlag(n3);
        return bl ? n2 | 1 << 15 - n3 : n2 & ~(1 << 15 - n3);
    }

    public void setFlag(int n2) {
        Header.checkFlag(n2);
        this.flags = Header.setFlag(this.flags, n2, true);
    }

    public boolean getFlag(int n2) {
        Header.checkFlag(n2);
        return (this.flags & 1 << 15 - n2) != 0;
    }

    boolean[] getFlags() {
        boolean[] blArray = new boolean[16];
        for (int i2 = 0; i2 < blArray.length; ++i2) {
            if (!Header.validFlag(i2)) continue;
            blArray[i2] = this.getFlag(i2);
        }
        return blArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getID() {
        if (this.id >= 0) {
            return this.id;
        }
        Header header = this;
        synchronized (header) {
            if (this.id < 0) {
                this.id = random.nextInt(65535);
            }
            return this.id;
        }
    }

    public void setID(int n2) {
        if (n2 < 0 || n2 > 65535) {
            throw new IllegalArgumentException("DNS message ID " + n2 + " is out of range");
        }
        this.id = n2;
    }

    public void setRcode(int n2) {
        if (n2 >= 0 && n2 <= 15) {
            this.flags &= 0xFFFFFFF0;
            this.flags |= n2;
        } else {
            throw new IllegalArgumentException("DNS Rcode " + n2 + " is out of range");
        }
    }

    public int getRcode() {
        return this.flags & 0xF;
    }

    public void setOpcode(int n2) {
        if (n2 >= 0 && n2 <= 15) {
            this.flags &= 0x87FF;
            this.flags |= n2 << 11;
        } else {
            throw new IllegalArgumentException("DNS Opcode " + n2 + "is out of range");
        }
    }

    public int getOpcode() {
        return this.flags >> 11 & 0xF;
    }

    void setCount(int n2, int n3) {
        if (n3 < 0 || n3 > 65535) {
            throw new IllegalArgumentException("DNS section count " + n3 + " is out of range");
        }
        this.counts[n2] = n3;
    }

    void incCount(int n2) {
        if (this.counts[n2] == 65535) {
            throw new IllegalStateException("DNS section count cannot be incremented");
        }
        int n3 = n2;
        this.counts[n3] = this.counts[n3] + 1;
    }

    void decCount(int n2) {
        if (this.counts[n2] == 0) {
            throw new IllegalStateException("DNS section count cannot be decremented");
        }
        int n3 = n2;
        this.counts[n3] = this.counts[n3] - 1;
    }

    public int getCount(int n2) {
        return this.counts[n2];
    }

    int getFlagsByte() {
        return this.flags;
    }

    public String printFlags() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < 16; ++i2) {
            if (!Header.validFlag(i2) || !this.getFlag(i2)) continue;
            stringBuffer.append(Flags.string(i2));
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    String toStringWithRcode(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(";; ->>HEADER<<- ");
        stringBuffer.append("opcode: " + Opcode.string(this.getOpcode()));
        stringBuffer.append(", status: " + Rcode.string(n2));
        stringBuffer.append(", id: " + this.getID());
        stringBuffer.append("\n");
        stringBuffer.append(";; flags: " + this.printFlags());
        stringBuffer.append("; ");
        for (int i2 = 0; i2 < 4; ++i2) {
            stringBuffer.append(Section.string(i2) + ": " + this.getCount(i2) + " ");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toStringWithRcode(this.getRcode());
    }

    public Object clone() {
        Header header = new Header();
        header.id = this.id;
        header.flags = this.flags;
        System.arraycopy(this.counts, 0, header.counts, 0, this.counts.length);
        return header;
    }
}

