/*
 * Decompiled with CFR 0.152.
 */
package com.hoho.android.usbserial.util;

import android.util.Log;
import com.hoho.android.usbserial.driver.UsbSerialPort;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class SerialInputOutputManager
implements Runnable {
    private static final String TAG = SerialInputOutputManager.class.getSimpleName();
    private static final boolean DEBUG = false;
    private static final int TRANSFER_WAIT_MILLIS = 3000;
    private static final int BUFSIZE = 0x200000;
    private UsbSerialPort mDriver = null;
    private final ByteBuffer mReadBuffer = ByteBuffer.allocate(0x200000);
    private State mState = State.STOPPED;
    private Listener mListener;

    public SerialInputOutputManager(UsbSerialPort driver) {
        this(driver, null);
    }

    public SerialInputOutputManager(UsbSerialPort driver, Listener listener) {
        this.mDriver = driver;
        this.mListener = listener;
    }

    public synchronized void setListener(Listener listener) {
        this.mListener = listener;
    }

    public synchronized Listener getListener() {
        return this.mListener;
    }

    public void writeAsync(byte[] data) {
        try {
            if (data != null) {
                this.mDriver.write(data, 3000);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeAsync(byte[] data, int data_size) {
        try {
            if (data != null) {
                byte[] bytes = new byte[data_size];
                bytes = Arrays.copyOfRange(data, 0, data_size);
                this.mDriver.write(bytes, 3000);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readData(byte[] data, int data_size, boolean discard_null) {
        int get_size = 0;
        ByteBuffer byteBuffer = this.mReadBuffer;
        synchronized (byteBuffer) {
            int i = 0;
            this.mReadBuffer.flip();
            try {
                for (i = 0; i < data_size && this.mReadBuffer.hasRemaining(); ++i) {
                    byte d = this.mReadBuffer.get();
                    if (discard_null && d == 0) continue;
                    data[get_size] = d;
                    ++get_size;
                }
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                // empty catch block
            }
            this.mReadBuffer.compact();
        }
        return get_size;
    }

    public int readDataAvailable() {
        return this.mReadBuffer.position();
    }

    public void stop() {
        if (this.getState() == State.RUNNING) {
            Log.i((String)TAG, (String)"Stop requested");
            this.mState = State.STOPPING;
        }
    }

    public State getState() {
        return this.mState;
    }

    public UsbSerialPort getDriver() {
        return this.mDriver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SerialInputOutputManager serialInputOutputManager = this;
        synchronized (serialInputOutputManager) {
            if (this.getState() != State.STOPPED) {
                throw new IllegalStateException("Already running.");
            }
            this.mState = State.RUNNING;
        }
        Log.i((String)TAG, (String)"Running ..");
        try {
            while (true) {
                if (this.getState() != State.RUNNING) {
                    Log.i((String)TAG, (String)("Stopping mState=" + (Object)((Object)this.getState())));
                    break;
                }
                this.step();
            }
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)("Run ending due to exception: " + e.getMessage()), (Throwable)e);
            Listener listener = this.getListener();
            if (listener != null) {
                listener.onRunError(e);
            }
        }
        finally {
            SerialInputOutputManager serialInputOutputManager2 = this;
            synchronized (serialInputOutputManager2) {
                this.mState = State.STOPPED;
                Log.i((String)TAG, (String)"Stopped.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void step() throws IOException {
        int len = 0;
        byte[] readbuffer = new byte[4096];
        len = this.mDriver.read(readbuffer, 3000);
        if (len > 0) {
            ByteBuffer byteBuffer = this.mReadBuffer;
            synchronized (byteBuffer) {
                this.mReadBuffer.put(readbuffer, 0, len);
            }
        }
        if (len == -1) {
            throw new IOException("handle close");
        }
    }

    public static interface Listener {
        public void onNewData(byte[] var1);

        public void onRunError(Exception var1);
    }

    public static enum State {
        STOPPED,
        RUNNING,
        STOPPING;

    }
}

