/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.opengl.renderer;

import android.opengl.GLES20;
import android.opengl.Matrix;
import com.serenegiant.opengl.EGLBase;
import com.serenegiant.opengl.GLDrawer2D;
import com.serenegiant.utils.Time;

class RendererSurface {
    private Object mSurface;
    private EGLBase.IEglSurface mEGLSurface;
    final float[] mMvpMatrix = new float[16];
    protected volatile boolean mEnable = true;

    static RendererSurface newInstance(EGLBase egl, Object surface, int maxFps) {
        return maxFps > 0 ? new RendererSurfaceHasWait(egl, surface, maxFps) : new RendererSurface(egl, surface);
    }

    private RendererSurface(EGLBase egl, Object surface) {
        this.mSurface = surface;
        this.mEGLSurface = egl.createFromSurface(surface);
        Matrix.setIdentityM((float[])this.mMvpMatrix, (int)0);
    }

    public void release() {
        if (this.mEGLSurface != null) {
            this.mEGLSurface.release();
            this.mEGLSurface = null;
        }
        this.mSurface = null;
    }

    public boolean isValid() {
        return this.mEGLSurface != null && this.mEGLSurface.isValid();
    }

    private void check() throws IllegalStateException {
        if (this.mEGLSurface == null) {
            throw new IllegalStateException("already released");
        }
    }

    public boolean isEnable() {
        return this.mEnable;
    }

    public void setEnable(boolean enable) {
        this.mEnable = enable;
    }

    public boolean canDraw() {
        return this.mEnable;
    }

    public void draw(GLDrawer2D drawer, int textId, float[] texMatrix) {
        this.draw(drawer, textId, texMatrix, this.mMvpMatrix);
    }

    public void draw(GLDrawer2D drawer, int textId, float[] texMatrix, float[] mvpMatrix) {
        if (drawer != null && this.mEGLSurface != null) {
            this.mEGLSurface.makeCurrent();
            GLES20.glClear((int)16384);
            drawer.setMvpMatrix(mvpMatrix, 0);
            drawer.draw(textId, texMatrix, 0);
            this.mEGLSurface.swap();
        }
    }

    public void clear(int color) {
        if (this.mEGLSurface != null) {
            this.mEGLSurface.makeCurrent();
            GLES20.glClearColor((float)((float)((color & 0xFF0000) >>> 16) / 255.0f), (float)((float)((color & 0xFF00) >>> 8) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)((color & 0xFF000000) >>> 24) / 255.0f));
            GLES20.glClear((int)16384);
            this.mEGLSurface.swap();
        }
    }

    private static class RendererSurfaceHasWait
    extends RendererSurface {
        private long mNextDraw;
        private final long mIntervalsNs;

        private RendererSurfaceHasWait(EGLBase egl, Object surface, int maxFps) {
            super(egl, surface);
            this.mIntervalsNs = 1000000000L / (long)maxFps;
            this.mNextDraw = Time.nanoTime() + this.mIntervalsNs;
        }

        @Override
        public boolean canDraw() {
            return this.mEnable && Time.nanoTime() - this.mNextDraw > 0L;
        }

        @Override
        public void draw(GLDrawer2D drawer, int textId, float[] texMatrix) {
            this.mNextDraw = Time.nanoTime() + this.mIntervalsNs;
            super.draw(drawer, textId, texMatrix);
        }
    }
}

