/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.model;

import android.os.ParcelFileDescriptor;
import android.util.Log;
import com.hpplay.glide.Priority;
import com.hpplay.glide.load.data.DataFetcher;
import com.hpplay.glide.load.model.ImageVideoWrapper;
import com.hpplay.glide.load.model.ModelLoader;
import java.io.InputStream;

public class ImageVideoModelLoader<A>
implements ModelLoader<A, ImageVideoWrapper> {
    private static final String TAG = "IVML";
    private final ModelLoader<A, InputStream> streamLoader;
    private final ModelLoader<A, ParcelFileDescriptor> fileDescriptorLoader;

    public ImageVideoModelLoader(ModelLoader<A, InputStream> modelLoader, ModelLoader<A, ParcelFileDescriptor> modelLoader2) {
        if (modelLoader == null && modelLoader2 == null) {
            throw new NullPointerException("At least one of streamLoader and fileDescriptorLoader must be non null");
        }
        this.streamLoader = modelLoader;
        this.fileDescriptorLoader = modelLoader2;
    }

    @Override
    public DataFetcher<ImageVideoWrapper> getResourceFetcher(A a2, int n2, int n3) {
        DataFetcher<InputStream> dataFetcher = null;
        if (this.streamLoader != null) {
            dataFetcher = this.streamLoader.getResourceFetcher(a2, n2, n3);
        }
        DataFetcher<ParcelFileDescriptor> dataFetcher2 = null;
        if (this.fileDescriptorLoader != null) {
            dataFetcher2 = this.fileDescriptorLoader.getResourceFetcher(a2, n2, n3);
        }
        if (dataFetcher != null || dataFetcher2 != null) {
            return new ImageVideoFetcher(dataFetcher, dataFetcher2);
        }
        return null;
    }

    static class ImageVideoFetcher
    implements DataFetcher<ImageVideoWrapper> {
        private final DataFetcher<InputStream> streamFetcher;
        private final DataFetcher<ParcelFileDescriptor> fileDescriptorFetcher;

        public ImageVideoFetcher(DataFetcher<InputStream> dataFetcher, DataFetcher<ParcelFileDescriptor> dataFetcher2) {
            this.streamFetcher = dataFetcher;
            this.fileDescriptorFetcher = dataFetcher2;
        }

        @Override
        public ImageVideoWrapper loadData(Priority priority) {
            ParcelFileDescriptor parcelFileDescriptor;
            InputStream inputStream;
            block9: {
                block8: {
                    inputStream = null;
                    if (this.streamFetcher != null) {
                        try {
                            inputStream = this.streamFetcher.loadData(priority);
                        }
                        catch (Exception exception) {
                            if (Log.isLoggable((String)ImageVideoModelLoader.TAG, (int)2)) {
                                Log.v((String)ImageVideoModelLoader.TAG, (String)"Exception fetching input stream, trying ParcelFileDescriptor", (Throwable)exception);
                            }
                            if (this.fileDescriptorFetcher != null) break block8;
                            throw exception;
                        }
                    }
                }
                parcelFileDescriptor = null;
                if (this.fileDescriptorFetcher != null) {
                    try {
                        parcelFileDescriptor = this.fileDescriptorFetcher.loadData(priority);
                    }
                    catch (Exception exception) {
                        if (Log.isLoggable((String)ImageVideoModelLoader.TAG, (int)2)) {
                            Log.v((String)ImageVideoModelLoader.TAG, (String)"Exception fetching ParcelFileDescriptor", (Throwable)exception);
                        }
                        if (inputStream != null) break block9;
                        throw exception;
                    }
                }
            }
            return new ImageVideoWrapper(inputStream, parcelFileDescriptor);
        }

        @Override
        public void cleanup() {
            if (this.streamFetcher != null) {
                this.streamFetcher.cleanup();
            }
            if (this.fileDescriptorFetcher != null) {
                this.fileDescriptorFetcher.cleanup();
            }
        }

        @Override
        public String getId() {
            if (this.streamFetcher != null) {
                return this.streamFetcher.getId();
            }
            return this.fileDescriptorFetcher.getId();
        }

        @Override
        public void cancel() {
            if (this.streamFetcher != null) {
                this.streamFetcher.cancel();
            }
            if (this.fileDescriptorFetcher != null) {
                this.fileDescriptorFetcher.cancel();
            }
        }
    }
}

