/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol;

import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.component.protocol.ProtocolBuilder;
import com.hpplay.component.protocol.ProtocolUtils;
import com.hpplay.component.protocol.encrypt.LelinkEncrypt;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Random;

public class ProtocolCore {
    private static final String TAG = "ProtocolCreater";
    public static final String ERR_MSG_DETAIL = "sink is not response";
    public Socket mSocket = null;
    public ParcelFileDescriptor mPfd;
    public FileDescriptor mLocalFileDescriptor;
    public FileOutputStream mLocalFileOutputStream;
    public ParcelFileDescriptor.AutoCloseInputStream mLocalAutoCloseInputStream;
    public String mIP;
    public int mPort;
    public ServerSocket mMirrorEventServer;
    public DatagramSocket mBrowseBroadCast;
    public DatagramSocket mBrowseServSocket;
    private static final int DATA_PACKET_LENGTH = 256;
    private static byte[] data = new byte[256];
    private static final int BROWSE_PORT = 25353;
    private static final int RECEIVE_DATA_PACKET_LENGTH = 2048;
    private static byte[] rcData = new byte[2048];
    private DatagramPacket mBrowsePacket = new DatagramPacket(data, 256);
    public DatagramPacket mReceiverPacket = new DatagramPacket(rcData, 2048);
    private static final int TCP_TIMEOUT = 30000;
    private static final int TCP_KEEP_ALIVE_TIMEOUT = 30000;
    private static final int TCP_READ_DATA_TIMEOUT = 10000;
    public static final String BROADCAST_IP_NAME = "255.255.255.255";
    private static String ifAddress = "";
    public static boolean USE_LOOPBACK_ADDR = false;
    public static boolean USE_ONLY_IPV4_ADDR = true;
    public static boolean USE_ONLY_IPV6_ADDR = false;
    public String mErrorMsg = "unknow";
    public int mErrorCode = 0;
    public static final Random random = new Random();

    public boolean connectServer() {
        return this.connectServer(30000);
    }

    public boolean connectServer(int n2) {
        CLog.i(TAG, "========>  connect host  " + this.mIP.replace(".", "") + " port " + this.mPort + "  timeout :" + n2);
        String string = ProtocolCore.matchLocalIp(this.mIP);
        this.mSocket = new Socket();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            InetAddress inetAddress = InetAddress.getByName(this.mIP);
            InetAddress inetAddress2 = InetAddress.getByName(string);
            this.bindLocal(this.mSocket, inetAddress2);
            this.mSocket.connect(new InetSocketAddress(inetAddress, this.mPort), n2);
        } else {
            this.mSocket.connect(new InetSocketAddress(this.mIP, this.mPort), n2);
        }
        this.mSocket.setReuseAddress(true);
        this.mSocket.setSoTimeout(n2);
        this.mSocket.setPerformancePreferences(0, 1, 2);
        this.mSocket.setKeepAlive(true);
        this.mPfd = ParcelFileDescriptor.fromSocket((Socket)this.mSocket);
        this.mLocalAutoCloseInputStream = new ParcelFileDescriptor.AutoCloseInputStream(this.mPfd);
        this.mLocalFileDescriptor = this.mPfd.getFileDescriptor();
        this.mLocalFileOutputStream = new FileOutputStream(this.mLocalFileDescriptor);
        return true;
    }

    public ParcelFileDescriptor.AutoCloseInputStream getInputStream() {
        return this.mLocalAutoCloseInputStream;
    }

    public boolean createMirrorEventServer(String string, int n2) {
        try {
            this.mMirrorEventServer = new ServerSocket();
            this.mMirrorEventServer.setReuseAddress(true);
            if (TextUtils.isEmpty((CharSequence)string)) {
                this.mMirrorEventServer.bind(new InetSocketAddress(n2));
            } else {
                this.mMirrorEventServer.bind(new InetSocketAddress(string, n2));
            }
            return true;
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
            return false;
        }
    }

    public boolean createMirrorSocket(String string, int n2) {
        try {
            String string2 = ProtocolCore.matchLocalIp(string);
            this.mSocket = new Socket();
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                InetAddress inetAddress = InetAddress.getByName(string);
                InetAddress inetAddress2 = InetAddress.getByName(string2);
                this.mSocket.connect(new InetSocketAddress(inetAddress, n2), 30000);
            } else {
                this.mSocket.connect(new InetSocketAddress(string, n2), 30000);
            }
            this.mSocket.setSoTimeout(30000);
            this.mSocket.setPerformancePreferences(2, 1, 3);
            this.mSocket.setTrafficClass(24);
            this.mSocket.setPerformancePreferences(0, 1, 2);
            this.mSocket.setReuseAddress(true);
            this.mPfd = ParcelFileDescriptor.fromSocket((Socket)this.mSocket);
            this.mLocalAutoCloseInputStream = new ParcelFileDescriptor.AutoCloseInputStream(this.mPfd);
            this.mLocalFileDescriptor = this.mPfd.getFileDescriptor();
            this.mLocalFileOutputStream = new FileOutputStream(this.mLocalFileDescriptor);
            return true;
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
            return false;
        }
    }

    public boolean createUDPServer() {
        try {
            this.mBrowseServSocket = new DatagramSocket(null);
            this.mBrowseServSocket.setReuseAddress(true);
            this.mBrowseServSocket.bind(new InetSocketAddress(25353));
            return true;
        }
        catch (SocketException socketException) {
            CLog.w(TAG, socketException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tcpCheckTvState(String string, int n2) {
        boolean bl = false;
        Socket socket = null;
        try {
            socket = new Socket();
            socket.setReuseAddress(true);
            socket.setSoTimeout(30000);
            String string2 = ProtocolCore.matchLocalIp(string);
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                InetAddress inetAddress = InetAddress.getByName(string);
                InetAddress inetAddress2 = InetAddress.getByName(string2);
                this.bindLocal(socket, inetAddress2);
                socket.connect(new InetSocketAddress(inetAddress, n2), 30000);
            } else {
                socket.connect(new InetSocketAddress(string, n2), 30000);
            }
            bl = true;
        }
        catch (Exception exception) {
            CLog.w(TAG, "local device : " + string.replace(".", "") + " is offline");
        }
        finally {
            if (null != socket) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    CLog.w(TAG, iOException);
                }
            }
        }
        return bl;
    }

    public void sendBrowseData() {
        try {
            if (this.mBrowseBroadCast == null) {
                this.createBroadCast();
            }
            ProtocolBuilder protocolBuilder = new ProtocolBuilder();
            protocolBuilder.setBrowseMgcNum("PTBL");
            protocolBuilder.setBrowseXorkey("0000");
            protocolBuilder.setBrowseInfo("search", String.valueOf(31899), "", "");
            CLog.i(TAG, protocolBuilder.getString(true));
            byte[] byArray = protocolBuilder.getProtocal(true);
            this.mBrowsePacket.setPort(25353);
            this.mBrowsePacket.setData(byArray);
            this.mBrowsePacket.setLength(byArray.length);
            this.mBrowsePacket.setAddress(InetAddress.getByName(BROADCAST_IP_NAME));
            this.mBrowseBroadCast.send(this.mBrowsePacket);
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
    }

    public void closeBrowseBroadCast() {
        if (this.mBrowseBroadCast != null) {
            this.mBrowseBroadCast.close();
        }
    }

    public boolean createBroadCast() {
        try {
            this.mBrowseBroadCast = new DatagramSocket(null);
            this.mBrowseBroadCast.setBroadcast(true);
            return true;
        }
        catch (SocketException socketException) {
            CLog.w(TAG, socketException);
            return false;
        }
    }

    public boolean checkEncrypt(LelinkEncrypt lelinkEncrypt, String string) {
        try {
            boolean bl;
            byte[] byArray;
            long l2;
            long l3 = l2 = System.currentTimeMillis();
            long l4 = l2;
            l2 = System.currentTimeMillis();
            if (!TextUtils.isEmpty((CharSequence)lelinkEncrypt.getSrpPassword())) {
                byArray = this.interactiveData(new byte[][]{lelinkEncrypt.genPlayInfoRequest()});
                if (byArray == null) {
                    return false;
                }
                CLog.d("dataa2", new String(byArray));
                bl = lelinkEncrypt.parsePlayerInfoResponse(byArray);
                if (!bl) {
                    return false;
                }
            }
            byte[] byArray2 = lelinkEncrypt.genSetupRequest();
            long l5 = System.currentTimeMillis() - l4;
            byArray = this.interactiveData(new byte[][]{byArray2});
            CLog.d(string + "utime", "genSetupRequest  " + (System.currentTimeMillis() - l2));
            if (byArray == null) {
                return false;
            }
            CLog.d(string + "utime", " start parseSetupResponse ");
            bl = lelinkEncrypt.parseSetupResponse(byArray);
            if (!bl) {
                return false;
            }
            CLog.d(string + "utime", "parseSetupResponse  " + (System.currentTimeMillis() - l2));
            l2 = System.currentTimeMillis();
            l4 = System.currentTimeMillis();
            byArray2 = lelinkEncrypt.genVerrifyM1Request();
            l5 += System.currentTimeMillis() - l4;
            byArray = this.interactiveData(new byte[][]{byArray2});
            if (byArray == null) {
                return false;
            }
            CLog.d(string + "utime", "genVerrifyM1Request  " + (System.currentTimeMillis() - l2));
            l2 = System.currentTimeMillis();
            l4 = System.currentTimeMillis();
            bl = lelinkEncrypt.parseVerifyM1Response(byArray);
            l5 += System.currentTimeMillis() - l4;
            if (!bl) {
                return false;
            }
            CLog.d(string + "utime", "parseVerifyM1Response  " + (System.currentTimeMillis() - l2));
            l2 = System.currentTimeMillis();
            l4 = System.currentTimeMillis();
            byArray2 = lelinkEncrypt.genVerrifyM2Request();
            l5 += System.currentTimeMillis() - l4;
            byArray = this.interactiveData(new byte[][]{byArray2});
            CLog.d(string + "utime", "genVerrifyM2Request  " + (System.currentTimeMillis() - l2));
            l2 = System.currentTimeMillis();
            if (byArray == null) {
                return false;
            }
            boolean bl2 = lelinkEncrypt.parseVerifyM2Response(byArray);
            CLog.d(string + "utime", "encrypt time -->" + (l5 += System.currentTimeMillis() - l3));
            CLog.d(string + "utime", "parseVerifyM2Response  " + (System.currentTimeMillis() - l2));
            CLog.d(string + "utime", "net time " + (System.currentTimeMillis() - l3 - l5));
            return bl2;
        }
        catch (Exception exception) {
            CLog.w(string, exception);
            return false;
        }
    }

    public byte[] interactiveData(byte[] ... byArray) {
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        byte[] byArray2 = null;
        if (this.mLocalFileOutputStream != null) {
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                this.mLocalFileOutputStream.write(byArray[i2]);
            }
            this.mLocalFileOutputStream.flush();
            long l2 = System.currentTimeMillis();
            byte[] byArray3 = new byte[1];
            int n2 = 0;
            String string = null;
            while (System.currentTimeMillis() - l2 < 10000L) {
                int n3 = 0;
                if (string == null && this.mLocalAutoCloseInputStream.available() > 0) {
                    n3 = this.mLocalAutoCloseInputStream.read(byArray3, 0, byArray3.length);
                }
                if (n3 > 0) {
                    int n4;
                    arrayList.add(byArray3[0]);
                    if (!ProtocolUtils.getProtocolDivide(arrayList)) continue;
                    byte[] byArray4 = new byte[arrayList.size()];
                    for (n4 = 0; n4 < byArray4.length; ++n4) {
                        byArray4[n4] = arrayList.get(n4);
                    }
                    string = new String(byArray4);
                    int n5 = ProtocolUtils.getContentLength(string);
                    byArray2 = new byte[byArray4.length + n5];
                    System.arraycopy(byArray4, 0, byArray2, 0, byArray4.length);
                    n2 = byArray4.length;
                    if (n5 == 0) break;
                    n4 = this.mLocalAutoCloseInputStream.available();
                    this.mLocalAutoCloseInputStream.read(byArray2, byArray4.length, n4);
                    if (n4 == n5) break;
                    n2 += n4;
                    continue;
                }
                if (byArray2 == null) continue;
                int n6 = this.mLocalAutoCloseInputStream.available();
                this.mLocalAutoCloseInputStream.read(byArray2, n2, n6);
                if ((n2 += n6) != byArray2.length) continue;
                break;
            }
            return byArray2;
        }
        return null;
    }

    public byte[] interactiveDataNoHeader(byte[] ... byArray) {
        try {
            ArrayList<Byte> arrayList = new ArrayList<Byte>();
            byte[] byArray2 = null;
            if (this.mLocalFileOutputStream != null) {
                for (int i2 = 0; i2 < byArray.length; ++i2) {
                    this.mLocalFileOutputStream.write(byArray[i2]);
                }
                this.mLocalFileOutputStream.flush();
                long l2 = System.currentTimeMillis();
                byte[] byArray3 = new byte[1];
                int n2 = 0;
                String string = null;
                while (System.currentTimeMillis() - l2 < 10000L) {
                    int n3 = 0;
                    if (string == null && this.mLocalAutoCloseInputStream.available() > 0) {
                        n3 = this.mLocalAutoCloseInputStream.read(byArray3, 0, byArray3.length);
                    }
                    if (n3 > 0 && n2 == 0) {
                        int n4;
                        arrayList.add(byArray3[0]);
                        if (!ProtocolUtils.getProtocolDivide(arrayList)) continue;
                        byte[] byArray4 = new byte[arrayList.size()];
                        for (n4 = 0; n4 < byArray4.length; ++n4) {
                            byArray4[n4] = arrayList.get(n4);
                        }
                        string = new String(byArray4);
                        int n5 = ProtocolUtils.getContentLength(string);
                        byArray2 = new byte[n5];
                        if (n5 == 0) break;
                        n4 = this.mLocalAutoCloseInputStream.available();
                        this.mLocalAutoCloseInputStream.read(byArray2, 0, n4);
                        if (n4 == n5) break;
                        n2 += n4;
                        continue;
                    }
                    if (byArray2 == null) continue;
                    int n6 = this.mLocalAutoCloseInputStream.available();
                    this.mLocalAutoCloseInputStream.read(byArray2, n2, n6);
                    if ((n2 += n6) != byArray2.length) continue;
                    break;
                }
                return byArray2;
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
        return null;
    }

    public byte[] interactiveEncryptData(byte[] ... byArray) {
        byte[] byArray2 = null;
        if (this.mLocalFileOutputStream != null) {
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                this.mLocalFileOutputStream.write(byArray[i2]);
            }
            this.mLocalFileOutputStream.flush();
            long l2 = System.currentTimeMillis();
            int n2 = 0;
            byte[] byArray3 = new byte[4];
            while (System.currentTimeMillis() - l2 < 10000L) {
                if (n2 == 0 && this.mLocalAutoCloseInputStream.available() > 4) {
                    int n3 = this.mLocalAutoCloseInputStream.read(byArray3, 0, 4);
                    if (n3 <= 0) continue;
                    int n4 = ProtocolUtils.bytesToInt(byArray3);
                    if (n4 == 0 || n4 > 0x200000) break;
                    n2 = n4 + 16;
                    byArray2 = new byte[n2 + 4];
                    System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
                    continue;
                }
                if (n2 <= 0 || this.mLocalAutoCloseInputStream.available() < n2) continue;
                this.mLocalAutoCloseInputStream.read(byArray2, byArray3.length, n2);
                break;
            }
            return byArray2;
        }
        return null;
    }

    private static boolean hasAssignedInterface() {
        return 0 < ifAddress.length();
    }

    public static int getNHostAddresses() {
        if (ProtocolCore.hasAssignedInterface()) {
            return 1;
        }
        int n2 = 0;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (!ProtocolCore.isUsableAddress(inetAddress)) continue;
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            CLog.d(TAG, null, exception);
        }
        return n2;
    }

    private static boolean isUsableAddress(InetAddress inetAddress) {
        if (!USE_LOOPBACK_ADDR && inetAddress.isLoopbackAddress()) {
            return false;
        }
        if (USE_ONLY_IPV4_ADDR && inetAddress instanceof Inet6Address) {
            return false;
        }
        return !USE_ONLY_IPV6_ADDR || !(inetAddress instanceof Inet4Address);
    }

    public static String getHostAddress(int n2) {
        if (ProtocolCore.hasAssignedInterface()) {
            return ProtocolCore.getInterface();
        }
        int n3 = 0;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (!ProtocolCore.isUsableAddress(inetAddress)) continue;
                    if (n3 < n2) {
                        ++n3;
                        continue;
                    }
                    String string = inetAddress.getHostAddress();
                    return string;
                }
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
        return "";
    }

    public static final String getInterface() {
        return ifAddress;
    }

    public static int getAvailablePort() {
        int n2 = 10090;
        try {
            for (int i2 = n2 = random.nextInt(10000) + 10000 + random.nextInt(1000); i2 <= 65535; ++i2) {
                try {
                    new ServerSocket(i2).close();
                    CLog.i(TAG, "get availabel port " + i2);
                    return i2;
                }
                catch (IOException iOException) {
                    continue;
                }
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
        return n2;
    }

    private void bindLocal(Socket socket, InetAddress inetAddress) {
        try {
            socket.bind(new InetSocketAddress(inetAddress, ProtocolCore.getAvailablePort()));
        }
        catch (Exception exception) {
            try {
                socket.bind(new InetSocketAddress(inetAddress, ProtocolCore.getAvailablePort()));
            }
            catch (Exception exception2) {
                socket.bind(new InetSocketAddress(inetAddress, ProtocolCore.getAvailablePort()));
            }
        }
    }

    private static String matchLocalIp(String string) {
        String string2 = null;
        try {
            String string3 = string.substring(0, string.lastIndexOf("."));
            int n2 = ProtocolCore.getNHostAddresses();
            if (n2 < 2) {
                return null;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                String string4 = ProtocolCore.getHostAddress(i2);
                if (string4.contains(string3)) {
                    string2 = string4;
                }
                CLog.i(TAG, "check local host ====> " + string4.replace(".", ""));
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
        return string2;
    }
}

