/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.signature;

import com.hpplay.glide.load.Key;
import java.nio.ByteBuffer;
import java.security.MessageDigest;

public class MediaStoreSignature
implements Key {
    private final String mimeType;
    private final long dateModified;
    private final int orientation;

    public MediaStoreSignature(String string, long l2, int n2) {
        this.mimeType = string;
        this.dateModified = l2;
        this.orientation = n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MediaStoreSignature mediaStoreSignature = (MediaStoreSignature)object;
        if (this.dateModified != mediaStoreSignature.dateModified) {
            return false;
        }
        if (this.orientation != mediaStoreSignature.orientation) {
            return false;
        }
        return !(this.mimeType != null ? !this.mimeType.equals(mediaStoreSignature.mimeType) : mediaStoreSignature.mimeType != null);
    }

    @Override
    public int hashCode() {
        int n2 = this.mimeType != null ? this.mimeType.hashCode() : 0;
        n2 = 31 * n2 + (int)(this.dateModified ^ this.dateModified >>> 32);
        n2 = 31 * n2 + this.orientation;
        return n2;
    }

    @Override
    public void updateDiskCacheKey(MessageDigest messageDigest) {
        byte[] byArray = ByteBuffer.allocate(12).putLong(this.dateModified).putInt(this.orientation).array();
        messageDigest.update(byArray);
        messageDigest.update(this.mimeType.getBytes("UTF-8"));
    }
}

