/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.plist;

import com.hpplay.component.protocol.plist.NSArray;
import com.hpplay.component.protocol.plist.NSData;
import com.hpplay.component.protocol.plist.NSDate;
import com.hpplay.component.protocol.plist.NSDictionary;
import com.hpplay.component.protocol.plist.NSNumber;
import com.hpplay.component.protocol.plist.NSObject;
import com.hpplay.component.protocol.plist.NSSet;
import com.hpplay.component.protocol.plist.NSString;
import com.hpplay.component.protocol.plist.PropertyListFormatException;
import com.hpplay.component.protocol.plist.PropertyListParser;
import com.hpplay.component.protocol.plist.UID;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public final class BinaryPropertyListParser {
    private int majorVersion;
    private int minorVersion;
    private byte[] bytes;
    private int objectRefSize;
    private int[] offsetTable;

    private BinaryPropertyListParser() {
    }

    public static NSObject parse(byte[] byArray) {
        BinaryPropertyListParser binaryPropertyListParser = new BinaryPropertyListParser();
        return binaryPropertyListParser.doParse(byArray);
    }

    private NSObject doParse(byte[] byArray) {
        this.bytes = byArray;
        String string = new String(BinaryPropertyListParser.copyOfRange(this.bytes, 0, 8));
        if (!string.startsWith("bplist")) {
            throw new IllegalArgumentException("The given data is no binary property list. Wrong magic bytes: " + string);
        }
        this.majorVersion = string.charAt(6) - 48;
        this.minorVersion = string.charAt(7) - 48;
        if (this.majorVersion > 0) {
            throw new PropertyListFormatException("Unsupported binary property list format: v" + this.majorVersion + "." + this.minorVersion + ". Version 1.0 and later are not yet supported.");
        }
        if (this.bytes.length < 40) {
            throw new PropertyListFormatException("The binary property list does not contain a complete object offset table.");
        }
        byte[] byArray2 = BinaryPropertyListParser.copyOfRange(this.bytes, this.bytes.length - 32, this.bytes.length);
        int n2 = (int)BinaryPropertyListParser.parseUnsignedInt(byArray2, 6, 7);
        this.objectRefSize = (int)BinaryPropertyListParser.parseUnsignedInt(byArray2, 7, 8);
        int n3 = (int)BinaryPropertyListParser.parseUnsignedInt(byArray2, 8, 16);
        int n4 = (int)BinaryPropertyListParser.parseUnsignedInt(byArray2, 16, 24);
        int n5 = (int)BinaryPropertyListParser.parseUnsignedInt(byArray2, 24, 32);
        if (n5 + (n3 + 1) * n2 > this.bytes.length || n4 >= this.bytes.length - 32) {
            throw new PropertyListFormatException("The binary property list contains a corrupted object offset table.");
        }
        this.offsetTable = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            this.offsetTable[i2] = (int)BinaryPropertyListParser.parseUnsignedInt(this.bytes, n5 + i2 * n2, n5 + (i2 + 1) * n2);
        }
        return this.parseObject(n4);
    }

    public static NSObject parse(InputStream inputStream) {
        return BinaryPropertyListParser.parse(PropertyListParser.readAll(inputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NSObject parse(File file) {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            NSObject nSObject = BinaryPropertyListParser.parse(fileInputStream);
            return nSObject;
        }
        finally {
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {}
        }
    }

    private NSObject parseObject(int n2) {
        int n3 = this.offsetTable[n2];
        byte by = this.bytes[n3];
        int n4 = (by & 0xF0) >> 4;
        int n5 = by & 0xF;
        switch (n4) {
            case 0: {
                switch (n5) {
                    case 0: {
                        return null;
                    }
                    case 8: {
                        return new NSNumber(false);
                    }
                    case 9: {
                        return new NSNumber(true);
                    }
                    case 12: {
                        throw new UnsupportedOperationException("The given binary property list contains a URL object. Parsing of this object type is not yet implemented.");
                    }
                    case 13: {
                        throw new UnsupportedOperationException("The given binary property list contains a URL object. Parsing of this object type is not yet implemented.");
                    }
                    case 14: {
                        throw new UnsupportedOperationException("The given binary property list contains a UUID object. Parsing of this object type is not yet implemented.");
                    }
                }
                throw new PropertyListFormatException("The given binary property list contains an object of unknown type (" + n4 + ")");
            }
            case 1: {
                int n6 = (int)Math.pow(2.0, n5);
                return new NSNumber(this.bytes, n3 + 1, n3 + 1 + n6, 0);
            }
            case 2: {
                int n7 = (int)Math.pow(2.0, n5);
                return new NSNumber(this.bytes, n3 + 1, n3 + 1 + n7, 1);
            }
            case 3: {
                if (n5 != 3) {
                    throw new PropertyListFormatException("The given binary property list contains a date object of an unknown type (" + n5 + ")");
                }
                return new NSDate(this.bytes, n3 + 1, n3 + 9);
            }
            case 4: {
                int[] nArray = this.readLengthAndOffset(n5, n3);
                int n8 = nArray[0];
                int n9 = nArray[1];
                return new NSData(BinaryPropertyListParser.copyOfRange(this.bytes, n3 + n9, n3 + n9 + n8));
            }
            case 5: {
                int[] nArray = this.readLengthAndOffset(n5, n3);
                int n10 = nArray[0];
                int n11 = nArray[1];
                return new NSString(this.bytes, n3 + n11, n3 + n11 + n10, "ASCII");
            }
            case 6: {
                int[] nArray = this.readLengthAndOffset(n5, n3);
                int n12 = nArray[0];
                int n13 = nArray[1];
                int n14 = n12 * 2;
                return new NSString(this.bytes, n3 + n13, n3 + n13 + n14, "UTF-16BE");
            }
            case 7: {
                int[] nArray = this.readLengthAndOffset(n5, n3);
                int n15 = nArray[1];
                int n16 = nArray[0];
                int n17 = this.calculateUtf8StringLength(this.bytes, n3 + n15, n16);
                return new NSString(this.bytes, n3 + n15, n3 + n15 + n17, "UTF-8");
            }
            case 8: {
                int n18 = n5 + 1;
                return new UID(String.valueOf(n2), BinaryPropertyListParser.copyOfRange(this.bytes, n3 + 1, n3 + 1 + n18));
            }
            case 10: {
                int[] nArray = this.readLengthAndOffset(n5, n3);
                int n19 = nArray[0];
                int n20 = nArray[1];
                NSArray nSArray = new NSArray(n19);
                for (int i2 = 0; i2 < n19; ++i2) {
                    int n21 = (int)BinaryPropertyListParser.parseUnsignedInt(this.bytes, n3 + n20 + i2 * this.objectRefSize, n3 + n20 + (i2 + 1) * this.objectRefSize);
                    nSArray.setValue(i2, this.parseObject(n21));
                }
                return nSArray;
            }
            case 11: {
                int[] nArray = this.readLengthAndOffset(n5, n3);
                int n22 = nArray[0];
                int n23 = nArray[1];
                NSSet nSSet = new NSSet(true);
                for (int i3 = 0; i3 < n22; ++i3) {
                    int n24 = (int)BinaryPropertyListParser.parseUnsignedInt(this.bytes, n3 + n23 + i3 * this.objectRefSize, n3 + n23 + (i3 + 1) * this.objectRefSize);
                    nSSet.addObject(this.parseObject(n24));
                }
                return nSSet;
            }
            case 12: {
                int[] nArray = this.readLengthAndOffset(n5, n3);
                int n25 = nArray[0];
                int n26 = nArray[1];
                NSSet nSSet = new NSSet();
                for (int i4 = 0; i4 < n25; ++i4) {
                    int n27 = (int)BinaryPropertyListParser.parseUnsignedInt(this.bytes, n3 + n26 + i4 * this.objectRefSize, n3 + n26 + (i4 + 1) * this.objectRefSize);
                    nSSet.addObject(this.parseObject(n27));
                }
                return nSSet;
            }
            case 13: {
                int[] nArray = this.readLengthAndOffset(n5, n3);
                int n28 = nArray[0];
                int n29 = nArray[1];
                NSDictionary nSDictionary = new NSDictionary();
                for (int i5 = 0; i5 < n28; ++i5) {
                    int n30 = (int)BinaryPropertyListParser.parseUnsignedInt(this.bytes, n3 + n29 + i5 * this.objectRefSize, n3 + n29 + (i5 + 1) * this.objectRefSize);
                    int n31 = (int)BinaryPropertyListParser.parseUnsignedInt(this.bytes, n3 + n29 + n28 * this.objectRefSize + i5 * this.objectRefSize, n3 + n29 + n28 * this.objectRefSize + (i5 + 1) * this.objectRefSize);
                    NSObject nSObject = this.parseObject(n30);
                    NSObject nSObject2 = this.parseObject(n31);
                    assert (nSObject != null);
                    nSDictionary.put(nSObject.toString(), nSObject2);
                }
                return nSDictionary;
            }
        }
        throw new PropertyListFormatException("The given binary property list contains an object of unknown type (" + n4 + ")");
    }

    private int[] readLengthAndOffset(int n2, int n3) {
        int n4 = n2;
        int n5 = 1;
        if (n2 == 15) {
            byte by = this.bytes[n3 + 1];
            int n6 = (by & 0xF0) >> 4;
            if (n6 != 1) {
                System.err.println("BinaryPropertyListParser: Length integer has an unexpected type" + n6 + ". Attempting to parse anyway...");
            }
            int n7 = by & 0xF;
            int n8 = (int)Math.pow(2.0, n7);
            n5 = 2 + n8;
            n4 = n8 < 3 ? (int)BinaryPropertyListParser.parseUnsignedInt(this.bytes, n3 + 2, n3 + 2 + n8) : new BigInteger(BinaryPropertyListParser.copyOfRange(this.bytes, n3 + 2, n3 + 2 + n8)).intValue();
        }
        return new int[]{n4, n5};
    }

    private int calculateUtf8StringLength(byte[] byArray, int n2, int n3) {
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n5 = n2 + n4;
            if (byArray.length <= n5) {
                return n3;
            }
            if (byArray[n5] < 128) {
                ++n4;
            }
            if (byArray[n5] < 194) {
                return n3;
            }
            if (byArray[n5] < 224) {
                if ((byArray[n5 + 1] & 0xC0) != 128) {
                    return n3;
                }
                n4 += 2;
                continue;
            }
            if (byArray[n5] < 240) {
                if ((byArray[n5 + 1] & 0xC0) != 128 || (byArray[n5 + 2] & 0xC0) != 128) {
                    return n3;
                }
                n4 += 3;
                continue;
            }
            if (byArray[n5] >= 245) continue;
            if ((byArray[n5 + 1] & 0xC0) != 128 || (byArray[n5 + 2] & 0xC0) != 128 || (byArray[n5 + 3] & 0xC0) != 128) {
                return n3;
            }
            n4 += 4;
        }
        return n4;
    }

    public static long parseUnsignedInt(byte[] byArray) {
        return BinaryPropertyListParser.parseUnsignedInt(byArray, 0, byArray.length);
    }

    public static long parseUnsignedInt(byte[] byArray, int n2, int n3) {
        long l2 = 0L;
        for (int i2 = n2; i2 < n3; ++i2) {
            l2 <<= 8;
            l2 |= (long)(byArray[i2] & 0xFF);
        }
        return l2 &= 0xFFFFFFFFL;
    }

    public static long parseLong(byte[] byArray) {
        return BinaryPropertyListParser.parseLong(byArray, 0, byArray.length);
    }

    public static long parseLong(byte[] byArray, int n2, int n3) {
        long l2 = 0L;
        for (int i2 = n2; i2 < n3; ++i2) {
            l2 <<= 8;
            l2 |= (long)(byArray[i2] & 0xFF);
        }
        return l2;
    }

    public static double parseDouble(byte[] byArray) {
        return BinaryPropertyListParser.parseDouble(byArray, 0, byArray.length);
    }

    public static double parseDouble(byte[] byArray, int n2, int n3) {
        if (n3 - n2 == 8) {
            return Double.longBitsToDouble(BinaryPropertyListParser.parseLong(byArray, n2, n3));
        }
        if (n3 - n2 == 4) {
            return Float.intBitsToFloat((int)BinaryPropertyListParser.parseLong(byArray, n2, n3));
        }
        throw new IllegalArgumentException("endIndex (" + n3 + ") - startIndex (" + n2 + ") != 4 or 8");
    }

    public static byte[] copyOfRange(byte[] byArray, int n2, int n3) {
        int n4 = n3 - n2;
        if (n4 < 0) {
            throw new IllegalArgumentException("startIndex (" + n2 + ") > endIndex (" + n3 + ")");
        }
        byte[] byArray2 = new byte[n4];
        System.arraycopy(byArray, n2, byArray2, 0, n4);
        return byArray2;
    }
}

