/*
 * Decompiled with CFR 0.152.
 */
package com.example.serialport;

import android.util.Log;
import android_serialport_api.ComPort;
import dcutli.FileUtli;

public class serialport_api {
    private static String TAG;
    private ComPort com = null;
    private String comName = "";
    private int serialPortId;

    static native void SerialPortProcess(byte[] var0, int var1, int var2);

    public int initSerialPort(String comName, int boardRate) {
        this.comName = comName;
        this.serialPortId = this.generateUniqueId();
        Log.i((String)TAG, (String)("\u521d\u59cb\u5316\u4e32\u53e3 serialPortId:" + this.serialPortId + ",comName:" + comName + ", boardRate:" + boardRate));
        this.com = new ComPort();
        boolean bOpen = this.com.open(comName, boardRate, new ComPort.DataHandler(){

            @Override
            public void onDataReceived(String comName, byte[] buffer, int size) {
                String comdata = FileUtli.bytes2HexString(buffer, size);
                Log.i((String)TAG, (String)("\u63a5\u6536\u5230[" + comName + "]\u4e32\u53e3\u6570\u636e: " + comdata));
                serialport_api.SerialPortProcess(buffer, size, serialport_api.this.serialPortId);
            }
        });
        if (bOpen) {
            Log.i((String)TAG, (String)("\u4e32\u53e3[" + comName + "]\u6253\u5f00\u6210\u529f"));
        } else {
            Log.e((String)TAG, (String)("\u4e32\u53e3[" + comName + "]\u6253\u5f00\u5931\u8d25"));
        }
        return bOpen ? this.serialPortId : -1;
    }

    public void closeSerialPort() {
        if (this.com != null) {
            this.com.close();
            Log.i((String)TAG, (String)("\u4e32\u53e3[" + this.comName + "]\u5173\u95ed\u6210\u529f"));
        }
    }

    public void sendSerialPort(byte[] buffer, int size) {
        String comdata = FileUtli.bytes2HexString(buffer, size);
        Log.w((String)TAG, (String)("\u53d1\u9001\u7ed9[" + this.comName + "]\u4e32\u53e3\u7684\u6570\u636e: " + comdata));
        if (this.com != null) {
            this.com.sendData(buffer, size);
        }
    }

    public void SendTest() {
        byte[] simulatedData = new byte[]{-86, -128, 7, 1, 1, -119, 93};
        serialport_api.SerialPortProcess(simulatedData, simulatedData.length, this.serialPortId);
        byte[] firstData = new byte[]{-86, -127, 7, 31, 36, -67, 85};
        serialport_api.SerialPortProcess(firstData, firstData.length, this.serialPortId);
        byte[] secondData = new byte[]{10, 0, 0, 0, 11, 0, 0, 0, 0, 1, 0, 0};
        serialport_api.SerialPortProcess(secondData, secondData.length, this.serialPortId);
    }

    private int generateUniqueId() {
        return this.comName.hashCode();
    }

    static {
        System.loadLibrary("SerialPortCustom");
        TAG = "SerialPortAPI";
    }
}

