/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.modulelinker.patch;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import com.hpplay.component.modulelinker.api.ModuleLinker;

public class Preference {
    private static final String TAG = "Preference";
    private static Preference mPreference;
    private SharedPreferences mPref;

    private Preference(Context context) {
        this.mPref = PreferenceManager.getDefaultSharedPreferences((Context)context);
    }

    public static synchronized Preference getInstance() {
        if (mPreference == null) {
            Preference.init(ModuleLinker.getInstance().getContext());
        }
        return mPreference;
    }

    public static synchronized Preference init(Context context) {
        if (mPreference == null) {
            mPreference = new Preference(context);
        }
        return mPreference;
    }

    public boolean get(String string, boolean bl) {
        return this.mPref.getBoolean(string, bl);
    }

    public int get(String string, int n2) {
        return this.mPref.getInt(string, n2);
    }

    public float get(String string, float f2) {
        return this.mPref.getFloat(string, f2);
    }

    public long get(String string, long l2) {
        return this.mPref.getLong(string, l2);
    }

    public String get(String string) {
        return this.get(string, null);
    }

    public String get(String string, String string2) {
        return this.mPref.getString(string, string2);
    }

    public void put(String string, boolean bl) {
        this.mPref.edit().putBoolean(string, bl).apply();
    }

    public void put(String string, int n2) {
        this.mPref.edit().putInt(string, n2).apply();
    }

    public void put(String string, float f2) {
        this.mPref.edit().putFloat(string, f2).apply();
    }

    public void put(String string, long l2) {
        this.mPref.edit().putLong(string, l2).apply();
    }

    public void put(String string, String string2) {
        this.mPref.edit().putString(string, string2).apply();
    }
}

