/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.pass.sinktouch;

import android.graphics.PointF;
import android.os.SystemClock;
import android.view.MotionEvent;
import com.hpplay.common.utils.ScreenUtil;
import com.hpplay.sdk.source.bean.SinkTouchEvent;
import com.hpplay.sdk.source.bean.SinkTouchEventArea;
import com.hpplay.sdk.source.bean.SinkTouchPointerInfo;
import com.hpplay.sdk.source.pass.sinktouch.SinkTouchEventDispatcher;
import com.hpplay.sdk.source.pass.sinktouch.SinkTouchEventMonitor;
import com.hpplay.sdk.source.utils.AppContextUtils;
import java.util.HashMap;
import java.util.Map;

class SinkTouchEventTransformer {
    private static final String TAG = "SinkTouchEventTransform";
    private static long sDownTime = 0L;
    private static final Map<Integer, PointF> sPrePointers = new HashMap<Integer, PointF>();
    private static int scaleCount = 0;
    private static boolean hasDownEvent = false;

    SinkTouchEventTransformer() {
    }

    static void transformEvent(SinkTouchEvent sinkTouchEvent) {
        SinkTouchEventTransformer.transformPointerEvent(sinkTouchEvent.pointerInfos);
    }

    private static void transformPointerEvent(SinkTouchPointerInfo[] motionEvent) {
        boolean bl;
        if (((SinkTouchPointerInfo[])motionEvent).length <= 0) {
            return;
        }
        MotionEvent.PointerCoords[] pointerCoordsArray = new MotionEvent.PointerCoords[((SinkTouchPointerInfo[])motionEvent).length];
        MotionEvent.PointerProperties[] pointerPropertiesArray = new MotionEvent.PointerProperties[((SinkTouchPointerInfo[])motionEvent).length];
        int n2 = 0;
        if (SinkTouchEventMonitor.getInstance().getTouchScaleModulus() > 1.0f && scaleCount < 2 && (bl = SinkTouchEventTransformer.isScaleGesture((SinkTouchPointerInfo[])motionEvent))) {
            ++scaleCount;
        }
        PointF pointF = null;
        if (scaleCount >= 2) {
            pointF = SinkTouchEventTransformer.calculateCenterXY((SinkTouchPointerInfo[])motionEvent);
        }
        int n3 = motionEvent[0].actionType;
        for (SinkTouchPointerInfo sinkTouchPointerInfo : motionEvent) {
            PointF pointF2 = SinkTouchEventTransformer.calculatePoint(sinkTouchPointerInfo.ratioX, sinkTouchPointerInfo.ratioY);
            MotionEvent.PointerCoords pointerCoords = new MotionEvent.PointerCoords();
            if (scaleCount >= 2) {
                assert (pointF != null);
                pointerCoords.x = pointF2.x + (pointF2.x - pointF.x) * SinkTouchEventMonitor.getInstance().getTouchScaleModulus();
                pointerCoords.y = pointF2.y + (pointF2.y - pointF.y) * SinkTouchEventMonitor.getInstance().getTouchScaleModulus();
            } else {
                pointerCoords.x = pointF2.x;
                pointerCoords.y = pointF2.y;
            }
            pointerCoordsArray[n2] = pointerCoords;
            MotionEvent.PointerProperties pointerProperties = new MotionEvent.PointerProperties();
            pointerProperties.id = sinkTouchPointerInfo.pointerId;
            pointerProperties.toolType = 1;
            pointerPropertiesArray[n2] = pointerProperties;
            if (sinkTouchPointerInfo.actionType == 0 || !hasDownEvent) {
                sPrePointers.clear();
                scaleCount = 0;
                sDownTime = SystemClock.uptimeMillis();
                n3 = 0;
                hasDownEvent = true;
                sPrePointers.put(sinkTouchPointerInfo.pointerId, pointF2);
                break;
            }
            sPrePointers.put(sinkTouchPointerInfo.pointerId, pointF2);
            ++n2;
        }
        if (n3 == 1) {
            hasDownEvent = false;
        }
        if (((SinkTouchPointerInfo[])motionEvent).length > 1) {
            n3 = (n3 | 0xFF00) & (0xFF | motionEvent[0].activePointerId << 8);
        }
        MotionEvent motionEvent2 = MotionEvent.obtain((long)sDownTime, (long)SystemClock.uptimeMillis(), (int)n3, (int)((SinkTouchPointerInfo[])motionEvent).length, (MotionEvent.PointerProperties[])pointerPropertiesArray, (MotionEvent.PointerCoords[])pointerCoordsArray, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)8, (int)0, (int)4098, (int)2);
        SinkTouchEventDispatcher.getInstance().notifyTouchEvent(motionEvent2);
    }

    private static PointF calculateCenterXY(SinkTouchPointerInfo[] sinkTouchPointerInfoArray) {
        double d2 = 0.0;
        double d3 = 0.0;
        for (SinkTouchPointerInfo sinkTouchPointerInfo : sinkTouchPointerInfoArray) {
            PointF pointF = SinkTouchEventTransformer.calculatePoint(sinkTouchPointerInfo.ratioX, sinkTouchPointerInfo.ratioY);
            d2 += (double)pointF.x;
            d3 += (double)pointF.y;
        }
        return new PointF((float)(d2 / (double)sinkTouchPointerInfoArray.length), (float)(d3 / (double)sinkTouchPointerInfoArray.length));
    }

    private static PointF calculatePoint(double d2, double d3) {
        double d4;
        double d5;
        SinkTouchEventArea sinkTouchEventArea = SinkTouchEventMonitor.getInstance().getTouchEventArea();
        if (sinkTouchEventArea == null) {
            int[] nArray = ScreenUtil.getRelScreenSize(AppContextUtils.getInstance().getAppContext());
            d5 = (double)nArray[0] * d2;
            d4 = (double)nArray[1] * d3;
        } else {
            d5 = (double)sinkTouchEventArea.width * d2;
            d4 = (double)sinkTouchEventArea.height * d3;
        }
        return new PointF((float)d5, (float)d4);
    }

    private static boolean isScaleGesture(SinkTouchPointerInfo[] sinkTouchPointerInfoArray) {
        int n2;
        if (sinkTouchPointerInfoArray.length == 1) {
            return false;
        }
        int[] nArray = new int[sinkTouchPointerInfoArray.length];
        int n3 = 0;
        int n4 = 0;
        SinkTouchPointerInfo[] sinkTouchPointerInfoArray2 = sinkTouchPointerInfoArray;
        int n5 = sinkTouchPointerInfoArray2.length;
        for (n2 = 0; n2 < n5; ++n2) {
            SinkTouchPointerInfo sinkTouchPointerInfo = sinkTouchPointerInfoArray2[n2];
            PointF pointF = sPrePointers.get(sinkTouchPointerInfo.pointerId);
            if (pointF == null) continue;
            PointF pointF2 = SinkTouchEventTransformer.calculatePoint(sinkTouchPointerInfo.ratioX, sinkTouchPointerInfo.ratioY);
            nArray[n4] = SinkTouchEventTransformer.calculateAngle(pointF.x, pointF.y, pointF2.x, pointF2.y);
            ++n3;
            ++n4;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            for (n5 = i2 + 1; n5 < n3; ++n5) {
                n2 = Math.abs(nArray[i2] - nArray[n5]);
                if (n2 <= 120 || n2 >= 240) continue;
                return true;
            }
        }
        return false;
    }

    private static int calculateAngle(double d2, double d3, double d4, double d5) {
        double d6 = d4 - d2;
        double d7 = d5 - d3;
        if (d6 == 0.0) {
            if (d7 > 0.0) {
                return 90;
            }
            return 270;
        }
        if (d7 == 0.0) {
            if (d6 >= 0.0) {
                return 0;
            }
            return 180;
        }
        int n2 = (int)(180.0 * Math.atan(d7 / d6) / Math.PI);
        if (d6 > 0.0 && d7 > 0.0) {
            return n2;
        }
        if (d6 < 0.0 && d7 > 0.0) {
            return 180 + n2;
        }
        if (d6 < 0.0 && d7 < 0.0) {
            return 180 + n2;
        }
        if (d6 > 0.0 && d7 < 0.0) {
            return 360 + n2;
        }
        return 0;
    }
}

