/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.xbill.dns;

import com.hpplay.sdk.source.mdns.xbill.dns.InvalidDClassException;

public final class TTL {
    public static final long MAX_VALUE = Integer.MAX_VALUE;

    private TTL() {
    }

    static void check(long l2) {
        if (l2 < 0L || l2 > Integer.MAX_VALUE) {
            throw new InvalidDClassException((int)l2);
        }
    }

    public static long parse(String string, boolean bl) {
        if (string == null || string.length() == 0 || !Character.isDigit(string.charAt(0))) {
            throw new NumberFormatException();
        }
        long l2 = 0L;
        long l3 = 0L;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            long l4 = l2;
            if (Character.isDigit(c2)) {
                if ((l2 = l2 * 10L + (long)Character.getNumericValue(c2)) >= l4) continue;
                throw new NumberFormatException();
            }
            switch (Character.toUpperCase(c2)) {
                default: {
                    throw new NumberFormatException();
                }
                case 'W': {
                    l2 *= 7L;
                }
                case 'D': {
                    l2 *= 24L;
                }
                case 'H': {
                    l2 *= 60L;
                }
                case 'M': {
                    l2 *= 60L;
                }
                case 'S': 
            }
            l2 = 0L;
            if ((l3 += l2) <= 0xFFFFFFFFL) continue;
            throw new NumberFormatException();
        }
        if (l3 == 0L) {
            l3 = l2;
        }
        if (l3 > 0xFFFFFFFFL) {
            throw new NumberFormatException();
        }
        if (l3 > Integer.MAX_VALUE && bl) {
            l3 = Integer.MAX_VALUE;
        }
        return l3;
    }

    public static long parseTTL(String string) {
        return TTL.parse(string, true);
    }

    public static String format(long l2) {
        TTL.check(l2);
        StringBuffer stringBuffer = new StringBuffer();
        long l3 = l2 % 60L;
        long l4 = (l2 /= 60L) % 60L;
        long l5 = (l2 /= 60L) % 24L;
        long l6 = (l2 /= 24L) % 7L;
        long l7 = l2 /= 7L;
        if (l7 > 0L) {
            stringBuffer.append(l7 + "W");
        }
        if (l6 > 0L) {
            stringBuffer.append(l6 + "D");
        }
        if (l5 > 0L) {
            stringBuffer.append(l5 + "H");
        }
        if (l4 > 0L) {
            stringBuffer.append(l4 + "M");
        }
        if (l3 > 0L || l7 == 0L && l6 == 0L && l5 == 0L && l4 == 0L) {
            stringBuffer.append(l3 + "S");
        }
        return stringBuffer.toString();
    }
}

