/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.xbill.dns;

import com.hpplay.sdk.source.mdns.xbill.dns.DNSInput;
import com.hpplay.sdk.source.mdns.xbill.dns.DNSKEYRecord;
import com.hpplay.sdk.source.mdns.xbill.dns.DNSOutput;
import com.hpplay.sdk.source.mdns.xbill.dns.KEYBase;
import com.hpplay.sdk.source.mdns.xbill.dns.Message;
import com.hpplay.sdk.source.mdns.xbill.dns.Mnemonic;
import com.hpplay.sdk.source.mdns.xbill.dns.Name;
import com.hpplay.sdk.source.mdns.xbill.dns.RRSIGRecord;
import com.hpplay.sdk.source.mdns.xbill.dns.RRset;
import com.hpplay.sdk.source.mdns.xbill.dns.Record;
import com.hpplay.sdk.source.mdns.xbill.dns.SIGBase;
import com.hpplay.sdk.source.mdns.xbill.dns.SIGRecord;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;

public class DNSSEC {
    private static final ECKeyInfo GOST = new ECKeyInfo(32, "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFD97", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFD94", "A6", "1", "8D91E471E0989CDA27DF505A453F2B7635294F2DDF23E3B122ACC99C9E9F1E14", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF6C611070995AD10045841B09B761B893");
    private static final ECKeyInfo ECDSA_P256 = new ECKeyInfo(32, "FFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF", "FFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFC", "5AC635D8AA3A93E7B3EBBD55769886BC651D06B0CC53B0F63BCE3C3E27D2604B", "6B17D1F2E12C4247F8BCE6E563A440F277037D812DEB33A0F4A13945D898C296", "4FE342E2FE1A7F9B8EE7EB4A7C0F9E162BCE33576B315ECECBB6406837BF51F5", "FFFFFFFF00000000FFFFFFFFFFFFFFFFBCE6FAADA7179E84F3B9CAC2FC632551");
    private static final ECKeyInfo ECDSA_P384 = new ECKeyInfo(48, "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFF0000000000000000FFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFF0000000000000000FFFFFFFC", "B3312FA7E23EE7E4988E056BE3F82D19181D9C6EFE8141120314088F5013875AC656398D8A2ED19D2A85C8EDD3EC2AEF", "AA87CA22BE8B05378EB1C71EF320AD746E1D3B628BA79B9859F741E082542A385502F25DBF55296C3A545E3872760AB7", "3617DE4A96262C6F5D9E98BF9292DC29F8F41DBD289A147CE9DA3113B5F0B8C00A60B1CE1D7E819D7A431D7C90EA0E5F", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC7634D81F4372DDF581A0DB248B0A77AECEC196ACCC52973");

    private DNSSEC() {
    }

    private static void digestSIG(DNSOutput dNSOutput, SIGBase sIGBase) {
        dNSOutput.writeU16(sIGBase.getTypeCovered());
        dNSOutput.writeU8(sIGBase.getAlgorithm());
        dNSOutput.writeU8(sIGBase.getLabels());
        dNSOutput.writeU32(sIGBase.getOrigTTL());
        dNSOutput.writeU32(sIGBase.getExpire().getTime() / 1000L);
        dNSOutput.writeU32(sIGBase.getTimeSigned().getTime() / 1000L);
        dNSOutput.writeU16(sIGBase.getFootprint());
        sIGBase.getSigner().toWireCanonical(dNSOutput);
    }

    public static byte[] digestRRset(RRSIGRecord rRSIGRecord, RRset rRset) {
        DNSOutput dNSOutput = new DNSOutput();
        DNSSEC.digestSIG(dNSOutput, rRSIGRecord);
        int n2 = rRset.size();
        Object[] objectArray = new Record[n2];
        Iterator iterator = rRset.rrs();
        Name name = rRset.getName();
        Name name2 = null;
        int n3 = rRSIGRecord.getLabels() + 1;
        if (name.labels() > n3) {
            name2 = name.wild(name.labels() - n3);
        }
        while (iterator.hasNext()) {
            objectArray[--n2] = (Record)iterator.next();
        }
        Arrays.sort(objectArray);
        DNSOutput dNSOutput2 = new DNSOutput();
        if (name2 != null) {
            name2.toWireCanonical(dNSOutput2);
        } else {
            name.toWireCanonical(dNSOutput2);
        }
        dNSOutput2.writeU16(rRset.getType());
        dNSOutput2.writeU16(rRset.getDClass());
        dNSOutput2.writeU32(rRSIGRecord.getOrigTTL());
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            dNSOutput.writeByteArray(dNSOutput2.toByteArray());
            int n4 = dNSOutput.current();
            dNSOutput.writeU16(0);
            dNSOutput.writeByteArray(((Record)objectArray[i2]).rdataToWireCanonical());
            int n5 = dNSOutput.current() - n4 - 2;
            dNSOutput.save();
            dNSOutput.jump(n4);
            dNSOutput.writeU16(n5);
            dNSOutput.restore();
        }
        return dNSOutput.toByteArray();
    }

    public static byte[] digestMessage(SIGRecord sIGRecord, Message message, byte[] byArray) {
        DNSOutput dNSOutput = new DNSOutput();
        DNSSEC.digestSIG(dNSOutput, sIGRecord);
        if (byArray != null) {
            dNSOutput.writeByteArray(byArray);
        }
        message.toWire(dNSOutput);
        return dNSOutput.toByteArray();
    }

    private static int BigIntegerLength(BigInteger bigInteger) {
        return (bigInteger.bitLength() + 7) / 8;
    }

    private static BigInteger readBigInteger(DNSInput dNSInput, int n2) {
        byte[] byArray = dNSInput.readByteArray(n2);
        return new BigInteger(1, byArray);
    }

    private static BigInteger readBigInteger(DNSInput dNSInput) {
        byte[] byArray = dNSInput.readByteArray();
        return new BigInteger(1, byArray);
    }

    private static byte[] trimByteArray(byte[] byArray) {
        if (byArray[0] == 0) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray.length - 1);
            return byArray2;
        }
        return byArray;
    }

    private static void reverseByteArray(byte[] byArray) {
        for (int i2 = 0; i2 < byArray.length / 2; ++i2) {
            int n2 = byArray.length - i2 - 1;
            byte by = byArray[i2];
            byArray[i2] = byArray[n2];
            byArray[n2] = by;
        }
    }

    private static BigInteger readBigIntegerLittleEndian(DNSInput dNSInput, int n2) {
        byte[] byArray = dNSInput.readByteArray(n2);
        DNSSEC.reverseByteArray(byArray);
        return new BigInteger(1, byArray);
    }

    private static void writeBigInteger(DNSOutput dNSOutput, BigInteger bigInteger) {
        byte[] byArray = DNSSEC.trimByteArray(bigInteger.toByteArray());
        dNSOutput.writeByteArray(byArray);
    }

    private static void writePaddedBigInteger(DNSOutput dNSOutput, BigInteger bigInteger, int n2) {
        byte[] byArray = DNSSEC.trimByteArray(bigInteger.toByteArray());
        if (byArray.length > n2) {
            throw new IllegalArgumentException();
        }
        if (byArray.length < n2) {
            byte[] byArray2 = new byte[n2 - byArray.length];
            dNSOutput.writeByteArray(byArray2);
        }
        dNSOutput.writeByteArray(byArray);
    }

    private static void writePaddedBigIntegerLittleEndian(DNSOutput dNSOutput, BigInteger bigInteger, int n2) {
        byte[] byArray = DNSSEC.trimByteArray(bigInteger.toByteArray());
        if (byArray.length > n2) {
            throw new IllegalArgumentException();
        }
        DNSSEC.reverseByteArray(byArray);
        dNSOutput.writeByteArray(byArray);
        if (byArray.length < n2) {
            byte[] byArray2 = new byte[n2 - byArray.length];
            dNSOutput.writeByteArray(byArray2);
        }
    }

    private static PublicKey toRSAPublicKey(KEYBase kEYBase) {
        DNSInput dNSInput = new DNSInput(kEYBase.getKey());
        int n2 = dNSInput.readU8();
        if (n2 == 0) {
            n2 = dNSInput.readU16();
        }
        BigInteger bigInteger = DNSSEC.readBigInteger(dNSInput, n2);
        BigInteger bigInteger2 = DNSSEC.readBigInteger(dNSInput);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(new RSAPublicKeySpec(bigInteger2, bigInteger));
    }

    private static PublicKey toDSAPublicKey(KEYBase kEYBase) {
        DNSInput dNSInput = new DNSInput(kEYBase.getKey());
        int n2 = dNSInput.readU8();
        if (n2 > 8) {
            throw new MalformedKeyException(kEYBase);
        }
        BigInteger bigInteger = DNSSEC.readBigInteger(dNSInput, 20);
        BigInteger bigInteger2 = DNSSEC.readBigInteger(dNSInput, 64 + n2 * 8);
        BigInteger bigInteger3 = DNSSEC.readBigInteger(dNSInput, 64 + n2 * 8);
        BigInteger bigInteger4 = DNSSEC.readBigInteger(dNSInput, 64 + n2 * 8);
        KeyFactory keyFactory = KeyFactory.getInstance("DSA");
        return keyFactory.generatePublic(new DSAPublicKeySpec(bigInteger4, bigInteger2, bigInteger, bigInteger3));
    }

    private static PublicKey toECGOSTPublicKey(KEYBase kEYBase, ECKeyInfo eCKeyInfo) {
        DNSInput dNSInput = new DNSInput(kEYBase.getKey());
        BigInteger bigInteger = DNSSEC.readBigIntegerLittleEndian(dNSInput, eCKeyInfo.length);
        BigInteger bigInteger2 = DNSSEC.readBigIntegerLittleEndian(dNSInput, eCKeyInfo.length);
        ECPoint eCPoint = new ECPoint(bigInteger, bigInteger2);
        KeyFactory keyFactory = KeyFactory.getInstance("ECGOST3410");
        return keyFactory.generatePublic(new ECPublicKeySpec(eCPoint, eCKeyInfo.spec));
    }

    private static PublicKey toECDSAPublicKey(KEYBase kEYBase, ECKeyInfo eCKeyInfo) {
        DNSInput dNSInput = new DNSInput(kEYBase.getKey());
        BigInteger bigInteger = DNSSEC.readBigInteger(dNSInput, eCKeyInfo.length);
        BigInteger bigInteger2 = DNSSEC.readBigInteger(dNSInput, eCKeyInfo.length);
        ECPoint eCPoint = new ECPoint(bigInteger, bigInteger2);
        KeyFactory keyFactory = KeyFactory.getInstance("EC");
        return keyFactory.generatePublic(new ECPublicKeySpec(eCPoint, eCKeyInfo.spec));
    }

    static PublicKey toPublicKey(KEYBase kEYBase) {
        int n2 = kEYBase.getAlgorithm();
        try {
            switch (n2) {
                case 1: 
                case 5: 
                case 7: 
                case 8: 
                case 10: {
                    return DNSSEC.toRSAPublicKey(kEYBase);
                }
                default: {
                    throw new UnsupportedAlgorithmException(n2);
                }
                case 3: 
                case 6: {
                    return DNSSEC.toDSAPublicKey(kEYBase);
                }
                case 12: {
                    return DNSSEC.toECGOSTPublicKey(kEYBase, GOST);
                }
                case 13: {
                    return DNSSEC.toECDSAPublicKey(kEYBase, ECDSA_P256);
                }
                case 14: 
            }
            return DNSSEC.toECDSAPublicKey(kEYBase, ECDSA_P384);
        }
        catch (Exception exception) {
            throw new MalformedKeyException(kEYBase);
        }
    }

    private static byte[] fromRSAPublicKey(RSAPublicKey rSAPublicKey) {
        DNSOutput dNSOutput = new DNSOutput();
        BigInteger bigInteger = rSAPublicKey.getPublicExponent();
        BigInteger bigInteger2 = rSAPublicKey.getModulus();
        int n2 = DNSSEC.BigIntegerLength(bigInteger);
        if (n2 < 256) {
            dNSOutput.writeU8(n2);
        } else {
            dNSOutput.writeU8(0);
            dNSOutput.writeU16(n2);
        }
        DNSSEC.writeBigInteger(dNSOutput, bigInteger);
        DNSSEC.writeBigInteger(dNSOutput, bigInteger2);
        return dNSOutput.toByteArray();
    }

    private static byte[] fromDSAPublicKey(DSAPublicKey dSAPublicKey) {
        DNSOutput dNSOutput = new DNSOutput();
        BigInteger bigInteger = dSAPublicKey.getParams().getQ();
        BigInteger bigInteger2 = dSAPublicKey.getParams().getP();
        BigInteger bigInteger3 = dSAPublicKey.getParams().getG();
        BigInteger bigInteger4 = dSAPublicKey.getY();
        int n2 = (bigInteger2.toByteArray().length - 64) / 8;
        dNSOutput.writeU8(n2);
        DNSSEC.writeBigInteger(dNSOutput, bigInteger);
        DNSSEC.writeBigInteger(dNSOutput, bigInteger2);
        DNSSEC.writePaddedBigInteger(dNSOutput, bigInteger3, 8 * n2 + 64);
        DNSSEC.writePaddedBigInteger(dNSOutput, bigInteger4, 8 * n2 + 64);
        return dNSOutput.toByteArray();
    }

    private static byte[] fromECGOSTPublicKey(ECPublicKey eCPublicKey, ECKeyInfo eCKeyInfo) {
        DNSOutput dNSOutput = new DNSOutput();
        BigInteger bigInteger = eCPublicKey.getW().getAffineX();
        BigInteger bigInteger2 = eCPublicKey.getW().getAffineY();
        DNSSEC.writePaddedBigIntegerLittleEndian(dNSOutput, bigInteger, eCKeyInfo.length);
        DNSSEC.writePaddedBigIntegerLittleEndian(dNSOutput, bigInteger2, eCKeyInfo.length);
        return dNSOutput.toByteArray();
    }

    private static byte[] fromECDSAPublicKey(ECPublicKey eCPublicKey, ECKeyInfo eCKeyInfo) {
        DNSOutput dNSOutput = new DNSOutput();
        BigInteger bigInteger = eCPublicKey.getW().getAffineX();
        BigInteger bigInteger2 = eCPublicKey.getW().getAffineY();
        DNSSEC.writePaddedBigInteger(dNSOutput, bigInteger, eCKeyInfo.length);
        DNSSEC.writePaddedBigInteger(dNSOutput, bigInteger2, eCKeyInfo.length);
        return dNSOutput.toByteArray();
    }

    static byte[] fromPublicKey(PublicKey publicKey, int n2) {
        switch (n2) {
            case 1: 
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                if (!(publicKey instanceof RSAPublicKey)) {
                    throw new IncompatibleKeyException();
                }
                return DNSSEC.fromRSAPublicKey((RSAPublicKey)publicKey);
            }
            default: {
                throw new UnsupportedAlgorithmException(n2);
            }
            case 3: 
            case 6: {
                if (!(publicKey instanceof DSAPublicKey)) {
                    throw new IncompatibleKeyException();
                }
                return DNSSEC.fromDSAPublicKey((DSAPublicKey)publicKey);
            }
            case 12: {
                if (!(publicKey instanceof ECPublicKey)) {
                    throw new IncompatibleKeyException();
                }
                return DNSSEC.fromECGOSTPublicKey((ECPublicKey)publicKey, GOST);
            }
            case 13: {
                if (!(publicKey instanceof ECPublicKey)) {
                    throw new IncompatibleKeyException();
                }
                return DNSSEC.fromECDSAPublicKey((ECPublicKey)publicKey, ECDSA_P256);
            }
            case 14: 
        }
        if (!(publicKey instanceof ECPublicKey)) {
            throw new IncompatibleKeyException();
        }
        return DNSSEC.fromECDSAPublicKey((ECPublicKey)publicKey, ECDSA_P384);
    }

    public static String algString(int n2) {
        switch (n2) {
            case 1: {
                return "MD5withRSA";
            }
            default: {
                throw new UnsupportedAlgorithmException(n2);
            }
            case 3: 
            case 6: {
                return "SHA1withDSA";
            }
            case 5: 
            case 7: {
                return "SHA1withRSA";
            }
            case 8: {
                return "SHA256withRSA";
            }
            case 10: {
                return "SHA512withRSA";
            }
            case 12: {
                return "GOST3411withECGOST3410";
            }
            case 13: {
                return "SHA256withECDSA";
            }
            case 14: 
        }
        return "SHA384withECDSA";
    }

    private static byte[] DSASignaturefromDNS(byte[] byArray) {
        if (byArray.length != 41) {
            throw new SignatureVerificationException();
        }
        DNSInput dNSInput = new DNSInput(byArray);
        DNSOutput dNSOutput = new DNSOutput();
        int n2 = dNSInput.readU8();
        byte[] byArray2 = dNSInput.readByteArray(20);
        int n3 = 20;
        if (byArray2[0] < 0) {
            ++n3;
        }
        byte[] byArray3 = dNSInput.readByteArray(20);
        int n4 = 20;
        if (byArray3[0] < 0) {
            ++n4;
        }
        dNSOutput.writeU8(48);
        dNSOutput.writeU8(n3 + n4 + 4);
        dNSOutput.writeU8(2);
        dNSOutput.writeU8(n3);
        if (n3 > 20) {
            dNSOutput.writeU8(0);
        }
        dNSOutput.writeByteArray(byArray2);
        dNSOutput.writeU8(2);
        dNSOutput.writeU8(n4);
        if (n4 > 20) {
            dNSOutput.writeU8(0);
        }
        dNSOutput.writeByteArray(byArray3);
        return dNSOutput.toByteArray();
    }

    private static byte[] DSASignaturetoDNS(byte[] byArray, int n2) {
        DNSInput dNSInput = new DNSInput(byArray);
        DNSOutput dNSOutput = new DNSOutput();
        dNSOutput.writeU8(n2);
        int n3 = dNSInput.readU8();
        if (n3 != 48) {
            throw new Exception();
        }
        int n4 = dNSInput.readU8();
        n3 = dNSInput.readU8();
        if (n3 != 2) {
            throw new Exception();
        }
        int n5 = dNSInput.readU8();
        if (n5 == 21 ? dNSInput.readU8() != 0 : n5 != 20) {
            throw new Exception();
        }
        byte[] byArray2 = dNSInput.readByteArray(20);
        dNSOutput.writeByteArray(byArray2);
        n3 = dNSInput.readU8();
        if (n3 != 2) {
            throw new Exception();
        }
        int n6 = dNSInput.readU8();
        if (n6 == 21 ? dNSInput.readU8() != 0 : n6 != 20) {
            throw new Exception();
        }
        byArray2 = dNSInput.readByteArray(20);
        dNSOutput.writeByteArray(byArray2);
        return dNSOutput.toByteArray();
    }

    private static byte[] ECGOSTSignaturefromDNS(byte[] byArray, ECKeyInfo eCKeyInfo) {
        if (byArray.length != eCKeyInfo.length * 2) {
            throw new SignatureVerificationException();
        }
        return byArray;
    }

    private static byte[] ECDSASignaturefromDNS(byte[] byArray, ECKeyInfo eCKeyInfo) {
        if (byArray.length != eCKeyInfo.length * 2) {
            throw new SignatureVerificationException();
        }
        DNSInput dNSInput = new DNSInput(byArray);
        DNSOutput dNSOutput = new DNSOutput();
        byte[] byArray2 = dNSInput.readByteArray(eCKeyInfo.length);
        int n2 = eCKeyInfo.length;
        if (byArray2[0] < 0) {
            ++n2;
        }
        byte[] byArray3 = dNSInput.readByteArray(eCKeyInfo.length);
        int n3 = eCKeyInfo.length;
        if (byArray3[0] < 0) {
            ++n3;
        }
        dNSOutput.writeU8(48);
        dNSOutput.writeU8(n2 + n3 + 4);
        dNSOutput.writeU8(2);
        dNSOutput.writeU8(n2);
        if (n2 > eCKeyInfo.length) {
            dNSOutput.writeU8(0);
        }
        dNSOutput.writeByteArray(byArray2);
        dNSOutput.writeU8(2);
        dNSOutput.writeU8(n3);
        if (n3 > eCKeyInfo.length) {
            dNSOutput.writeU8(0);
        }
        dNSOutput.writeByteArray(byArray3);
        return dNSOutput.toByteArray();
    }

    private static byte[] ECDSASignaturetoDNS(byte[] byArray, ECKeyInfo eCKeyInfo) {
        DNSInput dNSInput = new DNSInput(byArray);
        DNSOutput dNSOutput = new DNSOutput();
        int n2 = dNSInput.readU8();
        if (n2 != 48) {
            throw new Exception();
        }
        int n3 = dNSInput.readU8();
        n2 = dNSInput.readU8();
        if (n2 != 2) {
            throw new Exception();
        }
        int n4 = dNSInput.readU8();
        if (n4 == eCKeyInfo.length + 1 ? dNSInput.readU8() != 0 : n4 != eCKeyInfo.length) {
            throw new Exception();
        }
        byte[] byArray2 = dNSInput.readByteArray(eCKeyInfo.length);
        dNSOutput.writeByteArray(byArray2);
        n2 = dNSInput.readU8();
        if (n2 != 2) {
            throw new Exception();
        }
        int n5 = dNSInput.readU8();
        if (n5 == eCKeyInfo.length + 1 ? dNSInput.readU8() != 0 : n5 != eCKeyInfo.length) {
            throw new Exception();
        }
        byArray2 = dNSInput.readByteArray(eCKeyInfo.length);
        dNSOutput.writeByteArray(byArray2);
        return dNSOutput.toByteArray();
    }

    private static void verify(PublicKey publicKey, int n2, byte[] byArray, byte[] byArray2) {
        if (publicKey instanceof DSAPublicKey) {
            try {
                byArray2 = DNSSEC.DSASignaturefromDNS(byArray2);
            }
            catch (Exception exception) {
                throw new IllegalStateException();
            }
        }
        if (publicKey instanceof ECPublicKey) {
            try {
                switch (n2) {
                    case 12: {
                        byArray2 = DNSSEC.ECGOSTSignaturefromDNS(byArray2, GOST);
                        break;
                    }
                    case 13: {
                        byArray2 = DNSSEC.ECDSASignaturefromDNS(byArray2, ECDSA_P256);
                        break;
                    }
                    case 14: {
                        byArray2 = DNSSEC.ECDSASignaturefromDNS(byArray2, ECDSA_P384);
                        break;
                    }
                    default: {
                        throw new UnsupportedAlgorithmException(n2);
                    }
                }
            }
            catch (Exception exception) {
                throw new IllegalStateException();
            }
        }
        try {
            Signature signature = Signature.getInstance(DNSSEC.algString(n2));
            signature.initVerify(publicKey);
            signature.update(byArray);
            if (!signature.verify(byArray2)) {
                throw new SignatureVerificationException();
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new DNSSECException(generalSecurityException.toString());
        }
    }

    private static boolean matches(SIGBase sIGBase, KEYBase kEYBase) {
        return kEYBase.getAlgorithm() == sIGBase.getAlgorithm() && kEYBase.getFootprint() == sIGBase.getFootprint() && kEYBase.getName().equals(sIGBase.getSigner());
    }

    private static byte[] sign(PrivateKey privateKey, PublicKey publicKey, int n2, byte[] byArray, String string) {
        byte[] byArray2;
        Object object;
        try {
            object = string != null ? Signature.getInstance(DNSSEC.algString(n2), string) : Signature.getInstance(DNSSEC.algString(n2));
            ((Signature)object).initSign(privateKey);
            ((Signature)object).update(byArray);
            byArray2 = ((Signature)object).sign();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new DNSSECException(generalSecurityException.toString());
        }
        if (publicKey instanceof DSAPublicKey) {
            try {
                object = (DSAPublicKey)publicKey;
                BigInteger bigInteger = object.getParams().getP();
                int n3 = (DNSSEC.BigIntegerLength(bigInteger) - 64) / 8;
                byArray2 = DNSSEC.DSASignaturetoDNS(byArray2, n3);
            }
            catch (Exception exception) {
                throw new IllegalStateException();
            }
        }
        if (publicKey instanceof ECPublicKey) {
            try {
                switch (n2) {
                    case 12: {
                        break;
                    }
                    case 13: {
                        byArray2 = DNSSEC.ECDSASignaturetoDNS(byArray2, ECDSA_P256);
                        break;
                    }
                    case 14: {
                        byArray2 = DNSSEC.ECDSASignaturetoDNS(byArray2, ECDSA_P384);
                        break;
                    }
                    default: {
                        throw new UnsupportedAlgorithmException(n2);
                    }
                }
            }
            catch (Exception exception) {
                throw new IllegalStateException();
            }
        }
        return byArray2;
    }

    static void checkAlgorithm(PrivateKey privateKey, int n2) {
        switch (n2) {
            case 1: 
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                if (privateKey instanceof RSAPrivateKey) break;
                throw new IncompatibleKeyException();
            }
            default: {
                throw new UnsupportedAlgorithmException(n2);
            }
            case 3: 
            case 6: {
                if (privateKey instanceof DSAPrivateKey) break;
                throw new IncompatibleKeyException();
            }
            case 12: 
            case 13: 
            case 14: {
                if (privateKey instanceof ECPrivateKey) break;
                throw new IncompatibleKeyException();
            }
        }
    }

    public static RRSIGRecord sign(RRset rRset, DNSKEYRecord dNSKEYRecord, PrivateKey privateKey, Date date, Date date2, String string) {
        int n2 = dNSKEYRecord.getAlgorithm();
        DNSSEC.checkAlgorithm(privateKey, n2);
        RRSIGRecord rRSIGRecord = new RRSIGRecord(rRset.getName(), rRset.getDClass(), rRset.getTTL(), rRset.getType(), n2, rRset.getTTL(), date2, date, dNSKEYRecord.getFootprint(), dNSKEYRecord.getName(), null);
        rRSIGRecord.setSignature(DNSSEC.sign(privateKey, dNSKEYRecord.getPublicKey(), n2, DNSSEC.digestRRset(rRSIGRecord, rRset), string));
        return rRSIGRecord;
    }

    public static class Algorithm {
        private static Mnemonic algs = new Mnemonic("DNSSEC algorithm", 2);

        private Algorithm() {
        }

        public static String string(int n2) {
            return algs.getText(n2);
        }

        public static int value(String string) {
            return algs.getValue(string);
        }

        static {
            algs.setMaximum(255);
            algs.setNumericAllowed(true);
            algs.add(1, "RSAMD5");
            algs.add(2, "DH");
            algs.add(3, "DSA");
            algs.add(5, "RSASHA1");
            algs.add(6, "DSA-NSEC3-SHA1");
            algs.add(7, "RSA-NSEC3-SHA1");
            algs.add(8, "RSASHA256");
            algs.add(10, "RSASHA512");
            algs.add(12, "ECC-GOST");
            algs.add(13, "ECDSAP256SHA256");
            algs.add(14, "ECDSAP384SHA384");
            algs.add(252, "INDIRECT");
            algs.add(253, "PRIVATEDNS");
            algs.add(254, "PRIVATEOID");
        }
    }

    public static class DNSSECException
    extends Exception {
        DNSSECException(String string) {
            super(string);
        }
    }

    public static class UnsupportedAlgorithmException
    extends DNSSECException {
        UnsupportedAlgorithmException(int n2) {
            super("Unsupported algorithm: " + n2);
        }
    }

    public static class MalformedKeyException
    extends DNSSECException {
        MalformedKeyException(KEYBase kEYBase) {
            super("Invalid key data: " + kEYBase.rdataToString());
        }
    }

    public static class SignatureVerificationException
    extends DNSSECException {
        SignatureVerificationException() {
            super("signature verification failed");
        }
    }

    public static class IncompatibleKeyException
    extends IllegalArgumentException {
        IncompatibleKeyException() {
            super("incompatible keys");
        }
    }

    private static class ECKeyInfo {
        int length;
        public BigInteger p;
        public BigInteger a;
        public BigInteger b;
        public BigInteger gx;
        public BigInteger gy;
        public BigInteger n;
        EllipticCurve curve;
        ECParameterSpec spec;

        ECKeyInfo(int n2, String string, String string2, String string3, String string4, String string5, String string6) {
            this.length = n2;
            this.p = new BigInteger(string, 16);
            this.a = new BigInteger(string2, 16);
            this.b = new BigInteger(string3, 16);
            this.gx = new BigInteger(string4, 16);
            this.gy = new BigInteger(string5, 16);
            this.n = new BigInteger(string6, 16);
            this.curve = new EllipticCurve(new ECFieldFp(this.p), this.a, this.b);
            this.spec = new ECParameterSpec(this.curve, new ECPoint(this.gx, this.gy), this.n, 1);
        }
    }
}

