/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.xbill.dns;

import com.hpplay.sdk.source.mdns.xbill.dns.Entry;
import com.hpplay.sdk.source.mdns.xbill.dns.Name;
import com.hpplay.sdk.source.mdns.xbill.dns.Options;

public class Compression {
    private Entry[] table;
    private boolean verbose = Options.check("verbosecompression");

    public Compression() {
        this.table = new Entry[17];
    }

    public void add(int n2, Name name) {
        if (n2 > 16383) {
            return;
        }
        int n3 = (name.hashCode() & Integer.MAX_VALUE) % 17;
        Entry entry = new Entry();
        entry.name = name;
        entry.pos = n2;
        entry.next = this.table[n3];
        this.table[n3] = entry;
        if (this.verbose) {
            System.err.println("Adding " + name + " at " + n2);
        }
    }

    public int get(Name name) {
        int n2 = (name.hashCode() & Integer.MAX_VALUE) % 17;
        int n3 = -1;
        Entry entry = this.table[n2];
        while (entry != null) {
            if (entry.name.equals(name)) {
                n3 = entry.pos;
            }
            entry = entry.next;
        }
        if (this.verbose) {
            System.err.println("Looking for " + name + ", found " + n3);
        }
        return n3;
    }
}

