/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.business;

import android.text.TextUtils;
import com.hpplay.sdk.source.api.IDaPlayerListener;
import com.hpplay.sdk.source.api.ILelinkPlayerListener;
import com.hpplay.sdk.source.api.INewPlayerListener;
import com.hpplay.sdk.source.bean.CastBean;
import com.hpplay.sdk.source.bean.DaCastBean;
import com.hpplay.sdk.source.bean.OutParameter;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.process.ConnectManager;

public class LelinkPlayerListenerDispatcher {
    private static final String TAG = "LelinkPlayerListenerDispatcher";
    private OutParameter mCurrentPlayInfo;
    private ILelinkPlayerListener mOuterLelinkPlayerListener;
    private INewPlayerListener mOuterNewPlayerListener;
    private IDaPlayerListener mOuterDaPlayerListener;

    public void setPlayerListener(ILelinkPlayerListener iLelinkPlayerListener) {
        SourceLog.i(TAG, "setPlayerListener " + iLelinkPlayerListener);
        this.mOuterLelinkPlayerListener = iLelinkPlayerListener;
    }

    public void setNewPlayerListener(INewPlayerListener iNewPlayerListener) {
        SourceLog.i(TAG, "setNewPlayerListener " + iNewPlayerListener);
        this.mOuterNewPlayerListener = iNewPlayerListener;
    }

    public void setDaPlayListener(IDaPlayerListener iDaPlayerListener) {
        this.mOuterDaPlayerListener = iDaPlayerListener;
    }

    public void setCurrentPlayInfo(OutParameter outParameter) {
        this.mCurrentPlayInfo = outParameter;
    }

    public void onDaResult(OutParameter outParameter, boolean bl) {
        if (this.mOuterDaPlayerListener != null) {
            this.mOuterDaPlayerListener.onResult(this.createDaCastBean(outParameter), bl);
        }
    }

    public void onLoading(OutParameter outParameter) {
        if (!ConnectManager.getInstance().isConnected(outParameter)) {
            SourceLog.w(TAG, "onLoading ignore, device is disconnect");
            return;
        }
        if (outParameter != null && outParameter.pushType == 1) {
            if (this.mOuterDaPlayerListener != null) {
                this.mOuterDaPlayerListener.onLoading(this.createDaCastBean(outParameter));
            }
            return;
        }
        if (this.mOuterNewPlayerListener != null) {
            this.mOuterNewPlayerListener.onLoading(this.createCastBean(outParameter));
        } else if (this.mOuterLelinkPlayerListener != null) {
            this.mOuterLelinkPlayerListener.onLoading();
        } else {
            SourceLog.w(TAG, "onLoading invalid listener");
        }
    }

    public void onStart(OutParameter outParameter) {
        if (!ConnectManager.getInstance().isConnected(outParameter)) {
            SourceLog.w(TAG, "onStart ignore, device is disconnect");
            return;
        }
        if (outParameter != null && outParameter.pushType == 1) {
            if (this.mOuterDaPlayerListener != null) {
                this.mOuterDaPlayerListener.onStart(this.createDaCastBean(outParameter));
            }
            return;
        }
        if (this.mOuterNewPlayerListener != null) {
            this.mOuterNewPlayerListener.onStart(this.createCastBean(outParameter));
        } else if (this.mOuterLelinkPlayerListener != null) {
            this.mOuterLelinkPlayerListener.onStart();
        } else {
            SourceLog.w(TAG, "onStart invalid listener");
        }
    }

    public void onPause(OutParameter outParameter) {
        if (outParameter != null && outParameter.pushType == 1) {
            return;
        }
        if (this.mOuterNewPlayerListener != null) {
            this.mOuterNewPlayerListener.onPause(this.createCastBean(outParameter));
        } else if (this.mOuterLelinkPlayerListener != null) {
            this.mOuterLelinkPlayerListener.onPause();
        } else {
            SourceLog.w(TAG, "onPause invalid listener");
        }
    }

    public void onCompletion(OutParameter outParameter, int n2) {
        if (outParameter != null && outParameter.pushType == 1) {
            return;
        }
        if (this.mOuterNewPlayerListener != null) {
            this.mOuterNewPlayerListener.onCompletion(this.createCastBean(outParameter), n2);
        } else if (this.mOuterLelinkPlayerListener != null) {
            this.mOuterLelinkPlayerListener.onCompletion();
        } else {
            SourceLog.w(TAG, "onCompletion invalid listener");
        }
    }

    public void onStop(OutParameter outParameter) {
        if (outParameter != null && outParameter.pushType == 1) {
            if (this.mOuterDaPlayerListener != null) {
                this.mOuterDaPlayerListener.onStop(this.createDaCastBean(outParameter));
            }
            return;
        }
        if (!this.isSamePlayInfo(outParameter, this.mCurrentPlayInfo)) {
            if (outParameter != null && this.mCurrentPlayInfo != null) {
                SourceLog.w(TAG, "onStop ignore, unEqual playInfo " + outParameter.urlID + "/" + this.mCurrentPlayInfo.urlID);
            } else {
                SourceLog.w(TAG, "onStop ignore, unEqual playInfo");
            }
            return;
        }
        if (this.mOuterNewPlayerListener != null) {
            this.mOuterNewPlayerListener.onStop(this.createCastBean(outParameter));
        } else if (this.mOuterLelinkPlayerListener != null) {
            this.mOuterLelinkPlayerListener.onStop();
        } else {
            SourceLog.w(TAG, "onStop invalid listener");
        }
    }

    public void onSeekComplete(OutParameter outParameter, int n2) {
        if (outParameter != null && outParameter.pushType == 1) {
            return;
        }
        if (this.mOuterNewPlayerListener != null) {
            this.mOuterNewPlayerListener.onSeekComplete(this.createCastBean(outParameter), n2);
        } else if (this.mOuterLelinkPlayerListener != null) {
            this.mOuterLelinkPlayerListener.onSeekComplete(n2);
        } else {
            SourceLog.w(TAG, "onSeekComplete invalid listener");
        }
    }

    public void onInfo(OutParameter outParameter, int n2, int n3) {
        if (outParameter != null && outParameter.pushType == 1) {
            return;
        }
        if (this.mOuterNewPlayerListener != null) {
            this.mOuterNewPlayerListener.onInfo(this.createCastBean(outParameter), n2, n3);
        } else if (this.mOuterLelinkPlayerListener != null) {
            this.mOuterLelinkPlayerListener.onInfo(n2, n3);
        } else {
            SourceLog.w(TAG, "onInfo invalid listener");
        }
    }

    public void onInfo(OutParameter outParameter, int n2, String string) {
        if (outParameter != null && outParameter.pushType == 1) {
            return;
        }
        if (this.mOuterNewPlayerListener != null) {
            this.mOuterNewPlayerListener.onInfo(this.createCastBean(outParameter), n2, string);
        } else if (this.mOuterLelinkPlayerListener != null) {
            this.mOuterLelinkPlayerListener.onInfo(n2, string);
        } else {
            SourceLog.w(TAG, "onInfo invalid listener");
        }
    }

    public void onError(OutParameter outParameter, int n2, int n3) {
        this.onError(outParameter, n2, n3, "");
    }

    public void onError(OutParameter outParameter, int n2, int n3, String string) {
        if (outParameter != null && outParameter.pushType == 1) {
            return;
        }
        if (this.mOuterNewPlayerListener != null) {
            SourceLog.i(TAG, " New  PlayerListener onError callback");
            CastBean castBean = this.createCastBean(outParameter);
            castBean.errorInfo = string;
            this.mOuterNewPlayerListener.onError(castBean, n2, n3);
        } else if (this.mOuterLelinkPlayerListener != null) {
            SourceLog.i(TAG, " PlayerListener onError callback");
            this.mOuterLelinkPlayerListener.onError(n2, n3);
        } else {
            SourceLog.w(TAG, "onError invalid listener");
        }
    }

    public void onVolumeChanged(OutParameter outParameter, float f2) {
        if (outParameter != null && outParameter.pushType == 1) {
            return;
        }
        if (this.mOuterNewPlayerListener != null) {
            this.mOuterNewPlayerListener.onVolumeChanged(this.createCastBean(outParameter), f2);
        } else if (this.mOuterLelinkPlayerListener != null) {
            this.mOuterLelinkPlayerListener.onVolumeChanged(f2);
        } else {
            SourceLog.w(TAG, "onVolumeChanged invalid listener");
        }
    }

    public void onPositionUpdate(OutParameter outParameter, long l2, long l3) {
        if (outParameter != null && outParameter.pushType == 1) {
            return;
        }
        if (this.mOuterNewPlayerListener != null) {
            this.mOuterNewPlayerListener.onPositionUpdate(this.createCastBean(outParameter), l2, l3);
        } else if (this.mOuterLelinkPlayerListener != null) {
            this.mOuterLelinkPlayerListener.onPositionUpdate(l2, l3);
        } else {
            SourceLog.w(TAG, "onPositionUpdate invalid listener");
        }
    }

    private boolean isSamePlayInfo(OutParameter outParameter, OutParameter outParameter2) {
        if (outParameter == null || outParameter2 == null) {
            return false;
        }
        return TextUtils.equals((CharSequence)outParameter.urlID, (CharSequence)outParameter2.urlID) && outParameter.castType == outParameter2.castType && outParameter.mimeType == outParameter2.mimeType;
    }

    private CastBean createCastBean(OutParameter outParameter) {
        if (outParameter == null) {
            return new CastBean();
        }
        CastBean castBean = new CastBean();
        castBean.url = outParameter.getPlayUrl();
        castBean.dramaID = outParameter.dramaID;
        return castBean;
    }

    private DaCastBean createDaCastBean(OutParameter outParameter) {
        DaCastBean daCastBean = new DaCastBean();
        return daCastBean;
    }
}

