/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.resource.bitmap;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.Gravity;
import com.hpplay.glide.load.resource.drawable.GlideDrawable;

public class GlideBitmapDrawable
extends GlideDrawable {
    private final Rect destRect = new Rect();
    private int width;
    private int height;
    private boolean applyGravity;
    private boolean mutated;
    private BitmapState state;

    public GlideBitmapDrawable(Resources resources, Bitmap bitmap) {
        this(resources, new BitmapState(bitmap));
    }

    GlideBitmapDrawable(Resources resources, BitmapState bitmapState) {
        int n2;
        if (bitmapState == null) {
            throw new NullPointerException("BitmapState must not be null");
        }
        this.state = bitmapState;
        if (resources != null) {
            int n3 = resources.getDisplayMetrics().densityDpi;
            bitmapState.targetDensity = n2 = n3 == 0 ? 160 : n3;
        } else {
            n2 = bitmapState.targetDensity;
        }
        this.width = bitmapState.bitmap.getScaledWidth(n2);
        this.height = bitmapState.bitmap.getScaledHeight(n2);
    }

    public int getIntrinsicWidth() {
        return this.width;
    }

    public int getIntrinsicHeight() {
        return this.height;
    }

    @Override
    public boolean isAnimated() {
        return false;
    }

    @Override
    public void setLoopCount(int n2) {
    }

    public void start() {
    }

    public void stop() {
    }

    public boolean isRunning() {
        return false;
    }

    protected void onBoundsChange(Rect rect) {
        super.onBoundsChange(rect);
        this.applyGravity = true;
    }

    public Drawable.ConstantState getConstantState() {
        return this.state;
    }

    public void draw(Canvas canvas) {
        if (this.applyGravity) {
            Gravity.apply((int)119, (int)this.width, (int)this.height, (Rect)this.getBounds(), (Rect)this.destRect);
            this.applyGravity = false;
        }
        canvas.drawBitmap(this.state.bitmap, null, this.destRect, this.state.paint);
    }

    public void setAlpha(int n2) {
        int n3 = this.state.paint.getAlpha();
        if (n3 != n2) {
            this.state.setAlpha(n2);
            this.invalidateSelf();
        }
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.state.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    public int getOpacity() {
        Bitmap bitmap = this.state.bitmap;
        return bitmap == null || bitmap.hasAlpha() || this.state.paint.getAlpha() < 255 ? -3 : -1;
    }

    public Drawable mutate() {
        if (!this.mutated && super.mutate() == this) {
            this.state = new BitmapState(this.state);
            this.mutated = true;
        }
        return this;
    }

    public Bitmap getBitmap() {
        return this.state.bitmap;
    }

    static class BitmapState
    extends Drawable.ConstantState {
        private static final int DEFAULT_PAINT_FLAGS = 6;
        private static final Paint DEFAULT_PAINT = new Paint(6);
        private static final int GRAVITY = 119;
        final Bitmap bitmap;
        int targetDensity;
        Paint paint = DEFAULT_PAINT;

        public BitmapState(Bitmap bitmap) {
            this.bitmap = bitmap;
        }

        BitmapState(BitmapState bitmapState) {
            this(bitmapState.bitmap);
            this.targetDensity = bitmapState.targetDensity;
        }

        void setColorFilter(ColorFilter colorFilter) {
            this.mutatePaint();
            this.paint.setColorFilter(colorFilter);
        }

        void setAlpha(int n2) {
            this.mutatePaint();
            this.paint.setAlpha(n2);
        }

        void mutatePaint() {
            if (DEFAULT_PAINT == this.paint) {
                this.paint = new Paint(6);
            }
        }

        public Drawable newDrawable() {
            return new GlideBitmapDrawable(null, this);
        }

        public Drawable newDrawable(Resources resources) {
            return new GlideBitmapDrawable(resources, this);
        }

        public int getChangingConfigurations() {
            return 0;
        }
    }
}

