/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.model;

import android.content.Context;
import android.content.res.Resources;
import android.net.Uri;
import android.util.Log;
import com.hpplay.glide.load.data.DataFetcher;
import com.hpplay.glide.load.model.ModelLoader;

public class ResourceLoader<T>
implements ModelLoader<Integer, T> {
    private static final String TAG = "ResourceLoader";
    private final ModelLoader<Uri, T> uriLoader;
    private final Resources resources;

    public ResourceLoader(Context context, ModelLoader<Uri, T> modelLoader) {
        this(context.getResources(), modelLoader);
    }

    public ResourceLoader(Resources resources, ModelLoader<Uri, T> modelLoader) {
        this.resources = resources;
        this.uriLoader = modelLoader;
    }

    @Override
    public DataFetcher<T> getResourceFetcher(Integer n2, int n3, int n4) {
        Uri uri;
        block3: {
            uri = null;
            try {
                uri = Uri.parse((String)("android.resource://" + this.resources.getResourcePackageName(n2.intValue()) + '/' + this.resources.getResourceTypeName(n2.intValue()) + '/' + this.resources.getResourceEntryName(n2.intValue())));
            }
            catch (Resources.NotFoundException notFoundException) {
                if (!Log.isLoggable((String)TAG, (int)5)) break block3;
                Log.w((String)TAG, (String)("Received invalid resource id: " + n2), (Throwable)notFoundException);
            }
        }
        if (uri != null) {
            return this.uriLoader.getResourceFetcher(uri, n3, n4);
        }
        return null;
    }
}

