/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.cybergarage.upnp.event;

import com.hpplay.cybergarage.http.HTTP;
import com.hpplay.cybergarage.http.HTTPRequest;
import com.hpplay.cybergarage.http.HTTPResponse;
import com.hpplay.cybergarage.upnp.Device;
import com.hpplay.cybergarage.upnp.Service;
import com.hpplay.cybergarage.upnp.event.Subscription;
import com.hpplay.cybergarage.upnp.event.SubscriptionResponse;

public class SubscriptionRequest
extends HTTPRequest {
    private static final String CALLBACK_START_WITH = "<";
    private static final String CALLBACK_END_WITH = ">";

    public SubscriptionRequest() {
        this.setContentLength(0L);
    }

    public SubscriptionRequest(HTTPRequest hTTPRequest) {
        this();
        this.set(hTTPRequest);
    }

    private void setService(Service service) {
        Object object;
        String string = service.getEventSubURL();
        this.setURI(string, true);
        String string2 = "";
        Device device = service.getDevice();
        if (device != null) {
            string2 = device.getLocation();
        }
        if ((string2 == null || string2.length() <= 0) && (object = service.getRootDevice()) != null) {
            string2 = ((Device)object).getLocation();
        }
        if ((string2 == null || string2.length() <= 0) && (object = service.getRootDevice()) != null) {
            string2 = ((Device)object).getURLBase();
        }
        if ((string2 == null || string2.length() <= 0) && HTTP.isAbsoluteURL(string)) {
            string2 = string;
        }
        object = HTTP.getHost(string2);
        int n2 = HTTP.getPort(string2);
        this.setHost((String)object, n2);
        this.setRequestHost((String)object);
        this.setRequestPort(n2);
    }

    public void setSubscribeRequest(Service service, String string, long l2) {
        this.setMethod("SUBSCRIBE");
        this.setService(service);
        this.setCallback(string);
        this.setNT("upnp:event");
        this.setTimeout(l2);
    }

    public void setRenewRequest(Service service, String string, long l2) {
        this.setMethod("SUBSCRIBE");
        this.setService(service);
        this.setSID(string);
        this.setTimeout(l2);
    }

    public void setUnsubscribeRequest(Service service) {
        this.setMethod("UNSUBSCRIBE");
        this.setService(service);
        this.setSID(service.getSID());
    }

    public void setNT(String string) {
        this.setHeader("NT", string);
    }

    public String getNT() {
        return this.getHeaderValue("NT");
    }

    public boolean hasNT() {
        String string = this.getNT();
        return string != null && 0 < string.length();
    }

    public void setCallback(String string) {
        this.setStringHeader("CALLBACK", string, CALLBACK_START_WITH, CALLBACK_END_WITH);
    }

    public String getCallback() {
        return this.getStringHeaderValue("CALLBACK", CALLBACK_START_WITH, CALLBACK_END_WITH);
    }

    public boolean hasCallback() {
        String string = this.getCallback();
        return string != null && 0 < string.length();
    }

    public void setSID(String string) {
        this.setHeader("SID", Subscription.toSIDHeaderString(string));
    }

    public String getSID() {
        String string = Subscription.getSID(this.getHeaderValue("SID"));
        if (string == null) {
            return "";
        }
        return string;
    }

    public boolean hasSID() {
        String string = this.getSID();
        return string != null && 0 < string.length();
    }

    public final void setTimeout(long l2) {
        this.setHeader("TIMEOUT", Subscription.toTimeoutHeaderString(l2));
    }

    public long getTimeout() {
        return Subscription.getTimeout(this.getHeaderValue("TIMEOUT"));
    }

    public void post(SubscriptionResponse subscriptionResponse) {
        super.post(subscriptionResponse);
    }

    public SubscriptionResponse post() {
        HTTPResponse hTTPResponse = this.post(this.getRequestHost(), this.getRequestPort());
        return new SubscriptionResponse(hTTPResponse);
    }
}

