/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.srp6.cli;

import com.hpplay.component.protocol.srp6.BigIntegerUtils;
import com.hpplay.component.protocol.srp6.SRP6ClientCredentials;
import com.hpplay.component.protocol.srp6.SRP6ClientSession;
import com.hpplay.component.protocol.srp6.SRP6CryptoParams;
import com.hpplay.component.protocol.srp6.SRP6Exception;
import com.hpplay.component.protocol.srp6.SRP6VerifierGenerator;
import com.hpplay.component.protocol.srp6.cli.SRP6Tool;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SRP6Client
extends SRP6Tool {
    protected SecureRandom random = new SecureRandom();

    @Override
    public void run() {
        String string;
        this.println("*** Nimbus SRP-6a client / verifier generator ***");
        this.println();
        this.println("Choose mode: ");
        this.println("\t1 = generate password verifier");
        this.println("\t2 = client auth session");
        this.println();
        this.print("Your choice [1]: ");
        switch (string = this.readInput("1")) {
            case "1": {
                this.println();
                this.generatePasswordVerifier();
                break;
            }
            case "2": {
                this.println();
                this.clientSession();
                break;
            }
            default: {
                this.println("Unknown choice, aborting...");
            }
        }
    }

    private void generatePasswordVerifier() {
        int n2;
        this.println("Initialize verifier generator");
        SRP6CryptoParams sRP6CryptoParams = this.getConfig("\t");
        SRP6VerifierGenerator sRP6VerifierGenerator = new SRP6VerifierGenerator(sRP6CryptoParams);
        User user = this.getUser("");
        this.println();
        this.print("Enter preferred salt 's' byte size [16]: ");
        String string = this.readInput("16");
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.println("Couldn't parse salt 's' byte size: " + numberFormatException.getMessage());
            return;
        }
        BigInteger bigInteger = BigIntegerUtils.bigIntegerFromBytes(sRP6VerifierGenerator.generateRandomSalt(n2, this.random));
        BigInteger bigInteger2 = sRP6VerifierGenerator.generateVerifier(bigInteger, user.I, user.P);
        this.logSalt(BigIntegerUtils.toHex(bigInteger));
        this.println();
        this.logV(BigIntegerUtils.toHex(bigInteger2));
    }

    protected void logV(String string) {
        this.println("Computed password verifier 'v' (hex): " + string);
    }

    protected void logSalt(String string) {
        this.println("Generated salt 's' (hex): " + string);
    }

    private void clientSession() {
        SRP6ClientCredentials sRP6ClientCredentials;
        this.println("Client session step 1");
        SRP6ClientSession sRP6ClientSession = new SRP6ClientSession(){
            {
                this.random = SRP6Client.this.random;
            }
        };
        User user = this.getUser("\t");
        sRP6ClientSession.step1(user.I, user.P);
        this.println();
        this.println("Client session step 2");
        SRP6CryptoParams sRP6CryptoParams = this.getConfig("\t");
        this.print("\tEnter salt 's' (hex): ");
        BigInteger bigInteger = this.readBigInteger();
        this.println();
        this.print("\tEnter public server value 'B' (hex): ");
        BigInteger bigInteger2 = this.readBigInteger();
        this.println();
        try {
            sRP6ClientCredentials = sRP6ClientSession.step2(sRP6CryptoParams, bigInteger, bigInteger2);
        }
        catch (SRP6Exception sRP6Exception) {
            this.println(sRP6Exception.getMessage());
            return;
        }
        this.logA(BigIntegerUtils.toHex(sRP6ClientCredentials.A));
        this.logM1(BigIntegerUtils.toHex(sRP6ClientCredentials.M1));
        this.println();
        this.println("Client session step 3");
        this.print("\tEnter server evidence message 'M2' (hex): ");
        BigInteger bigInteger3 = this.readBigInteger();
        try {
            sRP6ClientSession.step3(bigInteger3);
        }
        catch (SRP6Exception sRP6Exception) {
            this.println(sRP6Exception.getMessage());
            throw sRP6Exception;
        }
        this.println();
        this.println("Client authentication successfully completed");
        this.println();
        this.logS(BigIntegerUtils.toHex(sRP6ClientSession.getSessionKey()));
        this.logShash(sRP6ClientSession.getSessionKeyHash());
    }

    void logM1(String string) {
        this.println("\tComputed evidence message 'M1' (hex): " + string);
    }

    void logA(String string) {
        this.println("\tComputed public value 'A' (hex): " + string);
    }

    private User getUser(String string) {
        this.print(string + "Enter user identity 'I': ");
        String string2 = this.readInput();
        this.print(string + "Enter user password 'P': ");
        String string3 = this.readInput();
        return new User(string2, string3);
    }

    public static void main(String[] stringArray) {
        SRP6Client sRP6Client = new SRP6Client();
        sRP6Client.run();
    }

    public static class User {
        public final String I;
        public final String P;

        public User(String string, String string2) {
            this.I = string;
            this.P = string2;
        }
    }
}

