/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.srp6;

import com.hpplay.component.protocol.srp6.BigIntegerUtils;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.SecureRandom;

public class SRP6Routines
implements Serializable {
    protected SecureRandom random = new SecureRandom();

    public BigInteger computeK(MessageDigest messageDigest, BigInteger bigInteger, BigInteger bigInteger2) {
        return this.hashPaddedPair(messageDigest, bigInteger, bigInteger, bigInteger2);
    }

    public byte[] generateRandomSalt(int n2) {
        return this.generateRandomSalt(n2, this.random);
    }

    public byte[] generateRandomSalt(int n2, SecureRandom secureRandom) {
        byte[] byArray = new byte[n2];
        secureRandom.nextBytes(byArray);
        return byArray;
    }

    public BigInteger computeX(MessageDigest messageDigest, byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = messageDigest.digest(byArray2);
        messageDigest.update(byArray);
        messageDigest.update(byArray3);
        return BigIntegerUtils.bigIntegerFromBytes(messageDigest.digest());
    }

    public BigInteger computeVerifier(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        return bigInteger2.modPow(bigInteger3, bigInteger);
    }

    public BigInteger generatePrivateValue(BigInteger bigInteger, SecureRandom secureRandom) {
        int n2 = Math.max(256, bigInteger.bitLength());
        BigInteger bigInteger2 = BigInteger.ZERO;
        while (BigInteger.ZERO.equals(bigInteger2)) {
            bigInteger2 = new BigInteger(n2, secureRandom).mod(bigInteger);
        }
        return bigInteger2;
    }

    public BigInteger computePublicClientValue(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        return bigInteger2.modPow(bigInteger3, bigInteger);
    }

    public BigInteger computePublicServerValue(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5) {
        return bigInteger2.modPow(bigInteger5, bigInteger).add(bigInteger4.multiply(bigInteger3)).mod(bigInteger);
    }

    public boolean isValidPublicValue(BigInteger bigInteger, BigInteger bigInteger2) {
        return !bigInteger2.mod(bigInteger).equals(BigInteger.ZERO);
    }

    public BigInteger computeU(MessageDigest messageDigest, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        return this.hashPaddedPair(messageDigest, bigInteger, bigInteger2, bigInteger3);
    }

    public BigInteger computeSessionKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7) {
        BigInteger bigInteger8 = bigInteger5.multiply(bigInteger4).add(bigInteger6);
        BigInteger bigInteger9 = bigInteger2.modPow(bigInteger4, bigInteger).multiply(bigInteger3);
        return bigInteger7.subtract(bigInteger9).modPow(bigInteger8, bigInteger);
    }

    public BigInteger computeSessionKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5) {
        return bigInteger2.modPow(bigInteger3, bigInteger).multiply(bigInteger4).modPow(bigInteger5, bigInteger);
    }

    public BigInteger computeClientEvidence(MessageDigest messageDigest, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        messageDigest.update(BigIntegerUtils.bigIntegerToBytes(bigInteger));
        messageDigest.update(BigIntegerUtils.bigIntegerToBytes(bigInteger2));
        messageDigest.update(BigIntegerUtils.bigIntegerToBytes(bigInteger3));
        return BigIntegerUtils.bigIntegerFromBytes(messageDigest.digest());
    }

    protected BigInteger computeServerEvidence(MessageDigest messageDigest, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        messageDigest.update(BigIntegerUtils.bigIntegerToBytes(bigInteger));
        messageDigest.update(BigIntegerUtils.bigIntegerToBytes(bigInteger2));
        messageDigest.update(BigIntegerUtils.bigIntegerToBytes(bigInteger3));
        return BigIntegerUtils.bigIntegerFromBytes(messageDigest.digest());
    }

    protected BigInteger hashPaddedPair(MessageDigest messageDigest, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        int n2 = (bigInteger.bitLength() + 7) / 8;
        byte[] byArray = this.getPadded(bigInteger2, n2);
        byte[] byArray2 = this.getPadded(bigInteger3, n2);
        messageDigest.update(byArray);
        messageDigest.update(byArray2);
        byte[] byArray3 = messageDigest.digest();
        return BigIntegerUtils.bigIntegerFromBytes(byArray3);
    }

    protected byte[] getPadded(BigInteger bigInteger, int n2) {
        byte[] byArray = BigIntegerUtils.bigIntegerToBytes(bigInteger);
        if (byArray.length < n2) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, n2 - byArray.length, byArray.length);
            byArray = byArray2;
        }
        return byArray;
    }
}

