/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.netcore;

import com.hpplay.component.common.protocol.IMirrorStateListener;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.component.netcore.OnNetStateChangeCallback;

public class LelinkNetCore {
    private IMirrorStateListener mMirrorStateListener;
    private OnNetStateChangeCallback mOnNetStateChangeCallback;
    private int mWidth;
    private int mHeight;

    public native int init();

    public native int getInitBitrate();

    public native int connect(String var1, int var2);

    public native int send(byte[] var1, int var2);

    public native int recv(byte[] var1, int var2);

    public native int flush();

    public native int close();

    public native int unInit();

    public native int probeStart(String var1, int var2);

    public native int probeStop();

    public int onNetStateCallback(int n2) {
        CLog.i("LelinkNetCore", "onNetStateCallback state " + n2);
        return 1;
    }

    public int onBitrateCallback(int n2) {
        CLog.i("MirrorDataSender", "callback bitrate " + n2);
        if (this.mMirrorStateListener != null) {
            this.mMirrorStateListener.onBitrateCallback(n2);
        }
        return 1;
    }

    public int onFrameCallback(int n2) {
        CLog.i("MirrorDataSender", "callback frameRate " + n2);
        if (this.mMirrorStateListener != null) {
            this.mMirrorStateListener.onFrameCallback(n2);
        }
        return 1;
    }

    public int onEncoderControl(int n2) {
        CLog.i("MirrorDataSender", "onEncoderControl" + n2);
        if (n2 == 0) {
            this.mMirrorStateListener.onPauseEncode();
        } else {
            this.mMirrorStateListener.resetEncoder();
        }
        return 1;
    }

    public void setMirrorStateListener(IMirrorStateListener iMirrorStateListener) {
        this.mMirrorStateListener = iMirrorStateListener;
    }

    public void setNetStateChangeListener(OnNetStateChangeCallback onNetStateChangeCallback) {
        this.mOnNetStateChangeCallback = onNetStateChangeCallback;
    }

    public int onResolutionCallback(int n2, int n3) {
        CLog.i("MirrorDataSender", "onResolutionCallback\uff1a " + n2 + "  height\uff1a " + n3);
        if (this.mMirrorStateListener != null) {
            this.mMirrorStateListener.onResolutionCallback(n2, n3);
            if (this.mWidth > 0 && n2 != n3 && this.mHeight != n3) {
                this.mMirrorStateListener.resetEncoder();
            }
        }
        this.mWidth = n2;
        this.mHeight = n3;
        return 1;
    }

    static {
        System.loadLibrary("netcore");
    }
}

