/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.common.asyncmanager;

import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import com.hpplay.common.asyncmanager.AsyncHttpParameter;
import com.hpplay.common.asyncmanager.AsyncHttpRequestListener;
import com.hpplay.common.asyncmanager.HttpRequest;
import com.hpplay.common.asyncmanager.HttpResult;
import com.hpplay.common.log.LeLog;

public abstract class AsyncHttpJob
extends AsyncTask {
    private final String TAG = "AsyncHttpJob";
    public int id;
    private AsyncHttpParameter inParameter;
    private AsyncHttpRequestListener requestListener;
    private int method;
    private HttpRequest httpRequest;
    private Runnable mTimeOutRunnable = new Runnable(){

        @Override
        public void run() {
            LeLog.w("AsyncHttpJob", "http request timeout");
            AsyncHttpJob.this.onPostExecute(null);
        }
    };
    private Handler mHandler = new Handler(Looper.getMainLooper());

    public AsyncHttpJob(int n2, AsyncHttpParameter asyncHttpParameter, AsyncHttpRequestListener asyncHttpRequestListener) {
        this.method = n2;
        this.inParameter = asyncHttpParameter;
        this.requestListener = asyncHttpRequestListener;
    }

    protected Object doInBackground(Object[] objectArray) {
        this.httpRequest = new HttpRequest(this.inParameter.in, this);
        this.mHandler.postDelayed(this.mTimeOutRunnable, (long)(this.inParameter.in.readTimeout + this.inParameter.in.readTimeout));
        HttpResult httpResult = null;
        httpResult = this.method == 1 ? this.httpRequest.doPost() : this.httpRequest.doGet();
        return httpResult;
    }

    protected void onPostExecute(Object object) {
        super.onPostExecute(object);
        if (this.requestListener != null) {
            if (object == null || !(object instanceof HttpResult)) {
                this.inParameter.out.resultType = 1;
                this.requestListener.onRequestResult(this.inParameter);
            } else {
                HttpResult httpResult = (HttpResult)object;
                this.inParameter.out.resultType = httpResult.resultType;
                this.inParameter.out.result = httpResult.result;
                this.inParameter.out.responseCode = httpResult.responseCode;
                this.inParameter.out.requestTryCount = this.httpRequest.getCount();
                this.inParameter.out.headers = httpResult.headers;
                this.requestListener.onRequestResult(this.inParameter);
            }
            this.requestListener = null;
        }
        this.cancelTimeOut();
    }

    protected void onCancelled() {
        super.onCancelled();
        LeLog.i("AsyncHttpJob", "onCancelled");
        if (this.requestListener != null) {
            this.inParameter.out.resultType = 2;
            this.requestListener.onRequestResult(this.inParameter);
            this.requestListener = null;
        }
        this.cancelTimeOut();
    }

    void cancelTimeOut() {
        if (this.mHandler != null) {
            this.mHandler.removeCallbacks(this.mTimeOutRunnable);
            this.mHandler = null;
        }
    }
}

