/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.encoder;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import android.view.Surface;
import com.serenegiant.encoder.MediaMuxerWrapper;
import com.serenegiant.uvccamera.BuildConfig;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;

public abstract class MediaEncoder
extends Thread {
    private static final boolean DEBUG = BuildConfig.DEBUG;
    private static final String TAG = MediaEncoder.class.getSimpleName();
    protected static final int TIMEOUT_US = 10000;
    protected volatile boolean mIsCapturing;
    protected boolean mMuxerStarted;
    protected volatile boolean mIsPaused;
    protected volatile long mStartTime;
    protected volatile long mLastPauseTime;
    protected volatile long mPauseTotalTime;
    protected int mTrackIndex;
    protected MediaCodec mMediaCodec;
    protected final WeakReference<MediaMuxerWrapper> mWeakMuxer;
    private MediaCodec.BufferInfo mBufferInfo;
    protected final MediaEncoderListener mListener;
    protected Surface mSurface;
    long prevPTS = 0L;

    public MediaEncoder(MediaMuxerWrapper muxer, MediaEncoderListener listener) {
        if (listener == null) {
            throw new NullPointerException("MediaEncoderListener is null");
        }
        if (muxer == null) {
            throw new NullPointerException("MediaMuxerWrapper is null");
        }
        this.mWeakMuxer = new WeakReference<MediaMuxerWrapper>(muxer);
        muxer.addEncoder(this);
        this.mListener = listener;
        this.mBufferInfo = new MediaCodec.BufferInfo();
        if (DEBUG) {
            Log.v((String)TAG, (String)("MediaEncoder:" + this.getClass().getSimpleName()));
        }
    }

    public Uri getOutputUri() {
        MediaMuxerWrapper muxer = (MediaMuxerWrapper)this.mWeakMuxer.get();
        return muxer != null ? muxer.getOutputUri() : null;
    }

    public Surface getInputSurface() {
        return this.mSurface;
    }

    public boolean frameAvailableSoon() {
        return this.mIsCapturing;
    }

    @Override
    public void run() {
        if (DEBUG) {
            Log.v((String)TAG, (String)("Encoder thread start:" + this.getClass().getCanonicalName()));
        }
        this.drain();
        if (DEBUG) {
            Log.v((String)TAG, (String)("release:" + this.getClass().getCanonicalName()));
        }
        this.release();
        if (DEBUG) {
            Log.d((String)TAG, (String)("Encoder thread exiting:" + this.getClass().getCanonicalName()));
        }
    }

    abstract void prepare() throws IOException;

    void startRecording() {
        if (DEBUG) {
            Log.v((String)TAG, (String)"startRecording");
        }
        this.mIsCapturing = true;
        this.mIsPaused = false;
        this.mStartTime = System.nanoTime();
        this.mLastPauseTime = 0L;
        this.mPauseTotalTime = 0L;
        this.start();
    }

    void pauseRecording() {
        if (DEBUG) {
            Log.v((String)TAG, (String)"pauseRecording");
        }
        this.mIsPaused = true;
        this.mLastPauseTime = System.nanoTime();
        if (DEBUG) {
            Log.v((String)TAG, (String)("pauseRecording:" + this.mLastPauseTime));
        }
    }

    void resumeRecording() {
        if (DEBUG) {
            Log.v((String)TAG, (String)"resumeRecording");
        }
        this.mIsPaused = false;
        long pauseTime = System.nanoTime() - this.mLastPauseTime;
        if (pauseTime > 0L) {
            this.mPauseTotalTime += pauseTime / 1000L;
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("resumeRecording:" + this.mPauseTotalTime));
        }
    }

    void stopRecording() {
        if (DEBUG) {
            Log.v((String)TAG, (String)"stopRecording");
        }
        if (!this.mIsCapturing) {
            return;
        }
        this.mIsPaused = false;
        this.signalEndOfInputStream();
        if (DEBUG) {
            Log.v((String)TAG, (String)("stopRecording " + this.getClass().getCanonicalName() + ":" + this.mIsCapturing));
        }
    }

    protected void release() {
        if (DEBUG) {
            Log.d((String)TAG, (String)"release:");
        }
        try {
            this.mListener.onStopped(this);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"failed onStopped", (Throwable)e);
        }
        this.mIsCapturing = false;
        if (this.mMediaCodec != null) {
            try {
                this.mMediaCodec.stop();
                this.mMediaCodec.release();
                this.mMediaCodec = null;
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"failed releasing MediaCodec", (Throwable)e);
            }
        }
        if (this.mMuxerStarted) {
            MediaMuxerWrapper muxer = (MediaMuxerWrapper)this.mWeakMuxer.get();
            if (muxer != null) {
                try {
                    muxer.stop();
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"failed stopping muxer", (Throwable)e);
                }
            }
            this.mMuxerStarted = false;
        }
        this.mBufferInfo = null;
        if (this.mSurface != null) {
            this.mSurface.release();
            this.mSurface = null;
        }
    }

    protected void signalEndOfInputStream() {
        block5: {
            if (DEBUG) {
                Log.d((String)TAG, (String)"sending EOS to encoder");
            }
            try {
                if (this.mSurface != null) {
                    this.mMediaCodec.signalEndOfInputStream();
                } else {
                    this.encode(null, 0, this.getPTSUs());
                }
            }
            catch (Exception e) {
                if (!DEBUG) break block5;
                Log.e((String)TAG, (String)"failed to send EOS to encoder", (Throwable)e);
            }
        }
    }

    protected void encode(ByteBuffer buffer, int length, long presentationTimeUs) {
        block9: {
            if (!this.mIsCapturing || this.mIsPaused) {
                return;
            }
            try {
                if (length <= 0) {
                    while (this.mIsCapturing) {
                        int inputBufferIndex = this.mMediaCodec.dequeueInputBuffer(10000L);
                        if (inputBufferIndex < 0) continue;
                        if (DEBUG) {
                            Log.i((String)TAG, (String)"send BUFFER_FLAG_END_OF_STREAM");
                        }
                        this.mMediaCodec.queueInputBuffer(inputBufferIndex, 0, 0, presentationTimeUs, 4);
                        break block9;
                    }
                    break block9;
                }
                int current = 0;
                while (this.mIsCapturing && current < length) {
                    int inputBufferId = this.mMediaCodec.dequeueInputBuffer(10000L);
                    if (inputBufferId >= 0) {
                        ByteBuffer inputBuffer = Build.VERSION.SDK_INT < 21 ? this.mMediaCodec.getInputBuffers()[inputBufferId] : this.mMediaCodec.getInputBuffer(inputBufferId);
                        inputBuffer.clear();
                        int inputSize = inputBuffer.capacity();
                        int n = inputSize = current + inputSize < length ? inputSize : length - current;
                        if (inputSize > 0 && buffer != null) {
                            buffer.position(current);
                            buffer.limit(current + inputSize);
                            inputBuffer.put(buffer);
                        }
                        current += inputSize;
                        this.mMediaCodec.queueInputBuffer(inputBufferId, 0, inputSize, presentationTimeUs, 0);
                        continue;
                    }
                    if (inputBufferId != -1) continue;
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drain() {
        if (DEBUG) {
            Log.v((String)TAG, (String)"drain start:");
        }
        if (this.mMediaCodec == null) {
            return;
        }
        MediaMuxerWrapper muxer = (MediaMuxerWrapper)this.mWeakMuxer.get();
        if (muxer == null) {
            Log.w((String)TAG, (String)"muxer is unexpectedly null");
            return;
        }
        block7: while (this.mIsCapturing) {
            try {
                ByteBuffer encodedData;
                int outputBufferId = this.mMediaCodec.dequeueOutputBuffer(this.mBufferInfo, 10000L);
                if (outputBufferId == -1) continue;
                if (outputBufferId == -3) {
                    if (!DEBUG) continue;
                    Log.v((String)TAG, (String)"INFO_OUTPUT_BUFFERS_CHANGED");
                    continue;
                }
                if (outputBufferId == -2) {
                    if (DEBUG) {
                        Log.v((String)TAG, (String)"INFO_OUTPUT_FORMAT_CHANGED");
                    }
                    if (this.mMuxerStarted) {
                        throw new RuntimeException("format changed twice");
                    }
                    MediaFormat format = this.mMediaCodec.getOutputFormat();
                    this.mTrackIndex = muxer.addTrack(format);
                    this.mMuxerStarted = true;
                    if (muxer.start()) continue;
                    MediaMuxerWrapper mediaMuxerWrapper = muxer;
                    synchronized (mediaMuxerWrapper) {
                        while (!muxer.isStarted()) {
                            try {
                                muxer.wait(100L);
                            }
                            catch (InterruptedException e) {
                                break block7;
                            }
                        }
                        continue;
                    }
                }
                if (outputBufferId < 0) {
                    if (!DEBUG) continue;
                    Log.w((String)TAG, (String)("drain:unexpected result from encoder#dequeueOutputBuffer: " + outputBufferId));
                    continue;
                }
                ByteBuffer byteBuffer = encodedData = Build.VERSION.SDK_INT < 21 ? this.mMediaCodec.getOutputBuffers()[outputBufferId] : this.mMediaCodec.getOutputBuffer(outputBufferId);
                if (encodedData == null) {
                    throw new RuntimeException("encoderOutputBuffer " + outputBufferId + " was null");
                }
                if ((this.mBufferInfo.flags & 2) != 0 && DEBUG) {
                    Log.d((String)TAG, (String)"drain:BUFFER_FLAG_CODEC_CONFIG");
                }
                if ((this.mBufferInfo.flags & 1) != 0 && DEBUG) {
                    Log.d((String)TAG, (String)"drain:BUFFER_FLAG_SYNC_FRAME");
                }
                if (!this.mMuxerStarted) {
                    throw new RuntimeException("drain:muxer hasn't started");
                }
                this.mBufferInfo.presentationTimeUs = this.getPTSUs();
                if (DEBUG) {
                    Log.v((String)TAG, (String)(this + ":presentationTimeUs:" + this.mBufferInfo.presentationTimeUs));
                }
                if ((this.mBufferInfo.flags & 4) != 0) {
                    this.mIsCapturing = false;
                } else {
                    muxer.writeSampleData(this.mTrackIndex, encodedData, this.mBufferInfo);
                }
                this.mMediaCodec.releaseOutputBuffer(outputBufferId, false);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
                break;
            }
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)"drain end:");
        }
    }

    protected long getPTSUs() {
        long currentTime = System.nanoTime();
        long pts = (currentTime - this.mStartTime - this.mPauseTotalTime) / 1000L;
        if (pts < this.prevPTS) {
            pts = this.prevPTS;
        }
        return pts;
    }

    public static interface MediaEncoderListener {
        public void onPrepared(MediaEncoder var1);

        public void onStopped(MediaEncoder var1);
    }
}

