/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.utils;

import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import com.hpplay.sdk.source.log.SourceLog;
import java.io.File;

public class FileUtils {
    private static final String TAG = "FileUtils";

    public static boolean isExternalStorageAvailable() {
        try {
            return Environment.getExternalStorageState().equals("mounted");
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
            return false;
        }
    }

    public static long getSDAvailableSize() {
        try {
            long l2;
            long l3;
            File file = Environment.getExternalStorageDirectory();
            StatFs statFs = new StatFs(file.getPath());
            if (Build.VERSION.SDK_INT >= 18) {
                l3 = statFs.getBlockSizeLong();
                l2 = statFs.getAvailableBlocksLong();
            } else {
                l3 = statFs.getBlockSize();
                l2 = statFs.getAvailableBlocks();
            }
            return l3 * l2;
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
            return 0L;
        }
    }
}

