/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.xbill.dns;

import com.hpplay.sdk.source.mdns.xbill.dns.InvalidDClassException;
import com.hpplay.sdk.source.mdns.xbill.dns.Mnemonic;

public final class DClass {
    public static final int IN = 1;
    public static final int CH = 3;
    public static final int CHAOS = 3;
    public static final int HS = 4;
    public static final int HESIOD = 4;
    public static final int NONE = 254;
    public static final int ANY = 255;
    private static Mnemonic classes = new DClassMnemonic();

    private DClass() {
    }

    public static void check(int n2) {
        if (n2 < 0 || n2 > 65535) {
            throw new InvalidDClassException(n2);
        }
    }

    public static String string(int n2) {
        return classes.getText(n2);
    }

    public static int value(String string) {
        return classes.getValue(string);
    }

    static {
        classes.add(1, "IN");
        classes.add(3, "CH");
        classes.addAlias(3, "CHAOS");
        classes.add(4, "HS");
        classes.addAlias(4, "HESIOD");
        classes.add(254, "NONE");
        classes.add(255, "ANY");
    }

    private static class DClassMnemonic
    extends Mnemonic {
        @Override
        public void check(int n2) {
            DClass.check(n2);
        }

        public DClassMnemonic() {
            super("DClass", 2);
            this.setPrefix("CLASS");
        }
    }
}

